/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sync;

public class SimpleQueue {
    private int _waiters = 0;
    private Element _firstQ = null;
    private Element _lastQ = null;
    private int _sizeQ = 0;
    private int _maxQ = Integer.MAX_VALUE;
    private Element _firstFree = null;
    private int _sizeFree = 0;
    private int _maxFree = 1024;

    public SimpleQueue() {
    }

    public SimpleQueue(int free) {
        while (free-- > 0) {
            Element r = new Element(null);
            r.next = this._firstFree;
            this._firstFree = r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enq(Object o) {
        while (this._sizeQ >= this._maxQ) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {}
        }
        SimpleQueue simpleQueue = this;
        synchronized (simpleQueue) {
            Element r;
            if (this._firstFree != null) {
                r = this._firstFree;
                this._firstFree = r.next;
                r.entry = o;
                r.next = null;
                --this._sizeFree;
            } else {
                r = new Element(o);
            }
            if (this._firstQ == null) {
                this._firstQ = r;
                this._lastQ = r;
            } else {
                Element r1 = this._lastQ;
                r1.next = r;
                this._lastQ = r;
            }
            ++this._sizeQ;
            if (this._waiters > 0) {
                this.notify();
            }
        }
    }

    public synchronized Object deq() {
        return this.deq(0L);
    }

    public synchronized Object deq(long timeout) {
        Object o = null;
        do {
            if (this._firstQ != null) {
                Element r = this._firstQ;
                this._firstQ = r.next;
                if (this._lastQ == r) {
                    this._lastQ = null;
                }
                --this._sizeQ;
                o = r.entry;
                if (this._sizeFree >= this._maxFree) break;
                Element r1 = this._firstFree;
                r.entry = null;
                r.next = r1;
                this._firstFree = r;
                ++this._sizeFree;
                break;
            }
            if (timeout == -1L) break;
            ++this._waiters;
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            --this._waiters;
        } while (this._firstQ != null);
        return o;
    }

    public boolean isEmpty() {
        return this._firstQ == null;
    }

    public int length() {
        return this._sizeQ;
    }

    public void setMax(int i) {
        this._maxQ = i;
    }

    public static void main(String[] args) {
        int cnt = 0;
        int loop = 1000;
        SimpleQueue queue = new SimpleQueue(50);
        queue.setMax(100);
        System.out.println("enq()=" + cnt);
        queue.enq(new Integer(cnt++));
        System.out.println("enq()=" + cnt);
        queue.enq(new Integer(cnt++));
        Thread thread = new Thread((Runnable)new TestThread(queue), "TestThread");
        thread.setDaemon(true);
        thread.start();
        System.out.println("thread started");
        while (cnt < loop) {
            System.out.println("enq()=" + cnt);
            queue.enq(new Integer(cnt++));
        }
        while (!queue.isEmpty()) {
            Thread.yield();
        }
    }

    static class TestThread
    implements Runnable {
        SimpleQueue queue;

        TestThread(SimpleQueue q) {
            this.queue = q;
        }

        public void run() {
            System.out.println("TestThread: start");
            while (true) {
                Object o = this.queue.deq();
                System.out.println("deq()=" + o);
                Thread.yield();
            }
        }
    }

    class Element {
        Object entry;
        Element next;

        Element(Object o) {
            this.entry = o;
            this.next = null;
        }
    }
}

