/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sync;

public class Semaphore {
    int count = 0;

    public Semaphore(int i) {
        this.count = i;
    }

    public Semaphore() {
        this.count = 0;
    }

    public synchronized void init(int i) {
        this.count = i;
    }

    public synchronized void semWait() {
        while (this.count == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.count;
    }

    public synchronized void semPost() {
        ++this.count;
        this.notify();
    }

    public synchronized boolean semAttempt(long msecs) {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        long start = System.currentTimeMillis();
        long waitTime = msecs;
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.count <= 0) continue;
            --this.count;
            return true;
        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }
}

