/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sync;

import com.wm.util.BasisRuntimeException;

public class Mutex {
    private static final String COREBUNDLE = "com.wm.resources.CoreExcpMsgs";
    private Thread owner;

    public synchronized void lock() {
        while (this.owner != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.owner = Thread.currentThread();
    }

    public synchronized void unlock() {
        if (!this.owner.equals(Thread.currentThread())) {
            throw new BasisRuntimeException("BAC.0008.0030", COREBUNDLE, new String[]{"thread"});
        }
        this.owner = null;
        this.notify();
    }

    public synchronized boolean attempt(long msecs) {
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            return true;
        }
        if (msecs <= 0L) {
            return false;
        }
        long waitTime = msecs;
        long start = System.currentTimeMillis();
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.owner != null) continue;
            this.owner = Thread.currentThread();
            return true;
        } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }
}

