/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sync;

public class CountingSemaphore {
    int _waiters = 0;
    int _signaled = 0;

    public CountingSemaphore(int signaled) {
        this._signaled = signaled;
    }

    public CountingSemaphore() {
    }

    public synchronized void semDecrBy(int amt) {
        this._signaled -= amt;
    }

    public synchronized void semIncrBy(int amt) {
        this._signaled += amt;
    }

    public synchronized int getSignalCount() {
        return this._signaled;
    }

    public synchronized void semWait() throws InterruptedException {
        this.semWait(0);
    }

    public synchronized void semWait(int time) throws InterruptedException {
        ++this._waiters;
        while (this._signaled < 1) {
            if (time == 0) {
                this.wait();
                continue;
            }
            this.wait(time);
            break;
        }
        --this._waiters;
        --this._signaled;
        if (this._signaled > 0 && this._waiters > 0) {
            this.notify();
        }
    }

    public synchronized void semPost() {
        ++this._signaled;
        if (this._waiters > 0) {
            this.notify();
        }
    }
}

