/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.sort;

import com.wm.util.sort.SString;
import com.wm.util.sort.Sortable;

public class QuickSort {
    Sortable[] items = null;
    boolean reverse = false;
    sortInfo free = new sortInfo();

    public QuickSort(Sortable[] i) {
        this(i, false, 0);
    }

    public QuickSort(Sortable[] i, int column) {
        this(i, false, column);
    }

    public QuickSort(Sortable[] i, boolean reverse, int column) {
        if (i != null && i.length > 0) {
            this.internalSort(i, reverse, column);
        }
        this.items = i;
    }

    public static Sortable[] sort(Sortable[] i) {
        return QuickSort.sort(i, false, 0);
    }

    public static Sortable[] sort(Sortable[] i, int column) {
        return QuickSort.sort(i, false, column);
    }

    public static Sortable[] sort(Sortable[] i, boolean reverse, int column) {
        return new QuickSort(i, reverse, column).getItems();
    }

    public Sortable[] getItems() {
        return this.items;
    }

    private void internalSort(Sortable[] A, boolean reverse, int column) {
        sortInfo info = new sortInfo(0, A.length - 1);
        while (info != null) {
            sortInfo oinfo = info;
            this.internalSort(info, A, reverse, column);
            info = info.next;
            oinfo.next = this.free;
            this.free = oinfo;
        }
    }

    private void internalSort(sortInfo info, Sortable[] A, boolean reverse, int column) {
        int low = info.low;
        int high = info.high;
        Sortable temp = null;
        if (high - low <= 0) {
            return;
        }
        if (high - low == 1) {
            if (A[high].compare(A[low], reverse, column) < 0) {
                temp = A[low];
                A[low] = A[high];
                A[high] = temp;
            }
            return;
        }
        int mid = (low + high) / 2 + 1;
        Sortable pivot = A[mid];
        temp = A[mid];
        A[mid] = A[low];
        A[low] = temp;
        int scanUp = low + 1;
        int scanDown = high;
        while (true) {
            if (scanUp <= scanDown && A[scanUp].compare(pivot, reverse, column) <= 0) {
                ++scanUp;
                continue;
            }
            while (pivot.compare(A[scanDown], reverse, column) < 0) {
                --scanDown;
            }
            if (scanUp < scanDown) {
                temp = A[scanUp];
                A[scanUp] = A[scanDown];
                A[scanDown] = temp;
            }
            if (scanUp >= scanDown) break;
        }
        A[low] = A[scanDown];
        A[scanDown] = pivot;
        if (low < scanDown - 1) {
            info = info.setNext(low, scanDown - 1);
        }
        if (scanDown + 1 < high) {
            info = info.setNext(scanDown + 1, high);
        }
    }

    public static String[] sort(String[] s) {
        Sortable[] ss = new SString[s.length];
        for (int i = 0; i < s.length; ++i) {
            ss[i] = new SString(s[i]);
        }
        SString[] sr = (SString[])new QuickSort(ss).getItems();
        String[] rv = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            rv[i] = sr[i].getValue();
        }
        return rv;
    }

    public static void main(String[] args) {
        String[] s = new String[]{"def", "abc", "hij", "zik", "xxs", "crt", "opw", "msd", "loi", "aaa"};
        s = QuickSort.sort(s);
        for (int i = 0; i < s.length; ++i) {
            System.out.println(i + ") " + s[i]);
        }
    }

    class sortInfo {
        Sortable a;
        int low;
        int high;
        sortInfo next;

        sortInfo() {
        }

        sortInfo(int low, int high) {
            this.setInfo(low, high);
        }

        void setInfo(int low, int high) {
            this.low = low;
            this.high = high;
        }

        sortInfo setNext(int low, int high) {
            if (QuickSort.this.free != null) {
                sortInfo nf = QuickSort.this.free;
                QuickSort.this.free = QuickSort.this.free.next;
                nf.next = null;
                nf.setInfo(low, high);
                return this.setNext(nf);
            }
            return this.setNext(new sortInfo(low, high));
        }

        sortInfo setNext(sortInfo newnext) {
            if (this.next != null) {
                newnext.getLast().next = this.next;
            }
            this.next = newnext;
            return newnext;
        }

        sortInfo getLast() {
            if (this.next == null) {
                return this;
            }
            sortInfo ptr = this.next;
            while (ptr.next != null) {
                ptr = ptr.next;
            }
            return ptr;
        }
    }
}

