/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.security;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class WmSecureString
implements Serializable {
    private char[] _data;
    static final long serialVersionUID = -3370279143903436200L;

    public WmSecureString(char[] inArray) {
        this.initFromCharArray(inArray);
    }

    public WmSecureString(byte[] inArray) {
        this.initFromString(new String(inArray));
    }

    public WmSecureString(byte[] inArray, String inEncoding) throws UnsupportedEncodingException {
        this.initFromByteArray(inArray, inEncoding);
    }

    public WmSecureString(String inStr) {
        this.initFromString(inStr);
    }

    public WmSecureString(WmSecureString inBuff) {
        if (inBuff == null) {
            this.initFromCharArray(null);
        } else {
            this.initFromCharArray(inBuff._data);
        }
    }

    public int length() {
        return this.wasErased() ? 0 : this._data.length;
    }

    public byte[] toByteArray() {
        return this.toString().getBytes();
    }

    public byte[] toByteArray(String inEnc) throws UnsupportedEncodingException {
        return inEnc == null ? this.toString().getBytes() : this.toString().getBytes(inEnc);
    }

    public char[] getChars() {
        if (this.wasErased()) {
            throw new NullPointerException("erased");
        }
        char[] returnArray = new char[this._data.length];
        System.arraycopy(this._data, 0, returnArray, 0, this._data.length);
        return returnArray;
    }

    public String toString() {
        if (this.wasErased()) {
            return new String();
        }
        return new String(this._data);
    }

    public void erase() {
        if (!this.wasErased()) {
            for (int ndx = 0; ndx < this._data.length; ++ndx) {
                this._data[ndx] = 32;
            }
            this._data = null;
        }
    }

    public boolean equals(Object inObj) {
        boolean rc = false;
        if (inObj instanceof WmSecureString) {
            WmSecureString inBuff = (WmSecureString)inObj;
            if (this.wasErased() && inBuff.wasErased()) {
                rc = true;
            } else if (!this.wasErased() && !inBuff.wasErased()) {
                rc = Arrays.equals(this._data, inBuff._data);
            }
        }
        return rc;
    }

    public int hashCode() {
        return this.wasErased() ? super.hashCode() : this._data.hashCode();
    }

    public boolean wasErased() {
        return this._data == null;
    }

    private void initFromCharArray(char[] inArray) {
        if (inArray == null) {
            throw new NullPointerException("null input");
        }
        int inLen = inArray.length;
        this._data = new char[inLen];
        if (inLen > 0) {
            System.arraycopy(inArray, 0, this._data, 0, inLen);
        }
    }

    private void initFromString(String inStr) {
        if (inStr == null) {
            throw new NullPointerException("null input");
        }
        int inLen = inStr.length();
        this._data = new char[inLen];
        if (inLen > 0) {
            inStr.getChars(0, inLen, this._data, 0);
        }
    }

    public void initFromByteArray(byte[] inArray, String inEncoding) throws UnsupportedEncodingException {
        if (inArray == null) {
            throw new NullPointerException("null input");
        }
        if (inArray.length == 0) {
            this._data = new char[0];
        } else if (inEncoding == null) {
            this.initFromString(new String(inArray));
        } else {
            this.initFromString(new String(inArray, inEncoding));
        }
    }
}

