/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.security;

import java.util.Random;

public class Bytes {
    private static final int COPY = 0;
    private static final int ROTATE = 1;
    private static final int TRANSPOSE = 2;
    private static final int REVERSE = 3;

    public static byte[] copy(byte[] x) {
        byte[] dest = null;
        if (x != null) {
            dest = new byte[x.length];
            System.arraycopy(x, 0, dest, 0, x.length);
        }
        return dest;
    }

    public static byte[] rotate(byte[] x, int amount) {
        byte[] dest = null;
        if (x != null) {
            dest = new byte[x.length];
            for (int i = 0; i < dest.length; ++i) {
                dest[i] = x[Bytes.modulus(i - amount, dest.length)];
            }
        }
        return dest;
    }

    public static byte[] rotate(byte[] x, int amount, int size) {
        byte[] dest = null;
        if (x != null) {
            dest = new byte[x.length];
            System.arraycopy(x, 0, dest, 0, x.length);
            int di = 0;
            for (int xi = 0; size != 0 && xi < x.length / size; ++xi) {
                int i = 0;
                while (i < size) {
                    dest[di] = x[xi * size + Bytes.modulus(i - amount, size)];
                    ++i;
                    ++di;
                }
            }
        }
        return dest;
    }

    public static byte[] reverse(byte[] x) {
        byte[] dest = null;
        if (x != null) {
            dest = new byte[x.length];
            int maxNdx = x.length - 1;
            for (int i = 0; i < x.length; ++i) {
                dest[i] = x[maxNdx - i];
            }
        }
        return dest;
    }

    public static byte[] transpose(byte[] x) {
        return Bytes.transpose(x, 2);
    }

    public static byte[] transpose(byte[] x, int size) {
        byte[] dest = null;
        if (x != null) {
            dest = new byte[x.length];
            System.arraycopy(x, 0, dest, 0, x.length);
            for (int i = 0; size != 0 && i < dest.length / size; ++i) {
                for (int j = 0; j < size; ++j) {
                    int offset = size - j - 1;
                    dest[i * size + j] = x[i * size + offset];
                }
            }
        }
        return dest;
    }

    public static byte[] applyAlgorithm(byte[] x, int[] algorithm, boolean reverse) {
        int alg = algorithm == null || algorithm.length == 0 ? 0 : algorithm[0];
        switch (alg) {
            case 0: {
                return Bytes.copy(x);
            }
            case 1: {
                return Bytes.rotatePerAlgorithm(x, algorithm, reverse);
            }
            case 2: {
                if (algorithm.length > 1) {
                    int size = algorithm[1];
                    return Bytes.transpose(x, size);
                }
                return Bytes.transpose(x);
            }
            case 3: {
                return Bytes.reverse(x);
            }
        }
        return Bytes.copy(x);
    }

    private static byte[] rotatePerAlgorithm(byte[] x, int[] algorithm, boolean reverse) {
        byte[] returnBytes = null;
        if (algorithm.length > 1) {
            int amount = algorithm[1] * (reverse ? -1 : 1);
            if (algorithm.length > 2) {
                int size = algorithm[2];
                returnBytes = Bytes.rotate(x, amount, size);
            } else {
                returnBytes = Bytes.rotate(x, amount);
            }
        } else {
            returnBytes = Bytes.copy(x);
        }
        return returnBytes;
    }

    public static byte[] applyAlgorithms(byte[] x, int[][] algorithms, boolean reverse) {
        byte[] b = x;
        if (algorithms != null) {
            for (int i = 0; i < algorithms.length; ++i) {
                int index = reverse ? algorithms.length - 1 - i : i;
                b = Bytes.applyAlgorithm(b, algorithms[index], reverse);
            }
        }
        return b;
    }

    public static int[][] createAlgorithms(int maxSize) {
        return Bytes.createAlgorithms(maxSize, 5);
    }

    public static int[][] createAlgorithms(int maxSize, int maxAlgorithms) {
        maxAlgorithms = Math.max(1, maxAlgorithms);
        Random r = new Random();
        int numAlgorithms = 1 + (int)(r.nextDouble() * (double)maxAlgorithms);
        int[][] algorithms = new int[numAlgorithms][];
        block4: for (int i = 0; i < numAlgorithms; ++i) {
            int alg = (int)(r.nextDouble() * 4.0);
            switch (alg) {
                case 1: {
                    int size;
                    int amount = (int)((r.nextDouble() - 0.5) * (double)maxSize);
                    if (r.nextDouble() > 0.5) {
                        size = (int)((r.nextDouble() - 0.5) * (double)maxSize);
                        algorithms[i] = new int[]{alg, amount, size};
                        continue block4;
                    }
                    algorithms[i] = new int[]{alg, amount};
                    continue block4;
                }
                case 2: {
                    int size;
                    if (r.nextDouble() > 0.5) {
                        size = (int)((r.nextDouble() - 0.5) * (double)maxSize);
                        algorithms[i] = new int[]{alg, size};
                        continue block4;
                    }
                    algorithms[i] = new int[]{alg};
                    continue block4;
                }
                default: {
                    algorithms[i] = new int[]{alg};
                }
            }
        }
        return algorithms;
    }

    public static byte[] indicesToValues(byte[] ary) {
        byte[] result = null;
        if (ary != null) {
            int ndxLimit = ary.length;
            result = new byte[ary.length];
            for (int i = 0; i < ary.length; ++i) {
                if (ary[i] < 0 || ary[i] >= ndxLimit) {
                    String msg = "bad value: ary[" + i + "]=" + ary[i] + " is < 0 or >= " + ndxLimit;
                    throw new IllegalArgumentException(msg);
                }
                result[ary[i]] = (byte)i;
            }
        }
        return result;
    }

    public static String toString(byte[] ary) {
        StringBuffer buf = new StringBuffer("{ ");
        for (int i = 0; i < ary.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(ary[i]);
        }
        buf.append(" }");
        return buf.toString();
    }

    private static int modulus(int x, int y) {
        int mod = y == 0 ? 0 : x % y;
        return mod * y < 0 ? mod + y : mod;
    }
}

