/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.pool;

import com.wm.util.pool.PooledObject;
import com.wm.util.pool.PooledThread;
import com.wm.util.pool.ThreadPool;
import java.util.Vector;

public class TaskQueue
extends ThreadPool {
    Vector queue = new Vector();
    Runner run = new Runner();
    boolean running = false;

    public TaskQueue(String name, int concurrent) {
        super(concurrent, concurrent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.addElement(task);
            if (!this.running) {
                this.running = true;
                new Thread((Runnable)this.run, "Task Queue Dispatcher").start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTasks(Runnable[] tasks) {
        Vector vector = this.queue;
        synchronized (vector) {
            for (int i = 0; i < tasks.length; ++i) {
                this.queue.addElement(tasks[i]);
            }
            if (!this.running) {
                this.running = true;
                new Thread((Runnable)this.run, "Task Queue Dispatcher").start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAll() {
        Runner runner = this.run;
        synchronized (runner) {
            try {
                this.run.wait();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(PooledObject obj) {
        super.release(obj);
        if (this.used() == 0) {
            Runner runner = this.run;
            synchronized (runner) {
                this.run.notify();
            }
        }
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Runnable task;
                Vector vector = TaskQueue.this.queue;
                synchronized (vector) {
                    if (TaskQueue.this.queue.size() == 0) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Vector e = TaskQueue.this.queue;
                synchronized (e) {
                    if (TaskQueue.this.queue.size() == 0) {
                        TaskQueue.this.running = false;
                        break;
                    }
                    task = (Runnable)TaskQueue.this.queue.elementAt(0);
                    TaskQueue.this.queue.removeElementAt(0);
                }
                PooledThread pt = (PooledThread)TaskQueue.this.allocate();
                pt.runTarget(task);
                Thread.currentThread();
                Thread.yield();
            }
        }
    }
}

