/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.pool;

import com.wm.util.BasisRuntimeException;
import com.wm.util.pool.ObjectPool;
import com.wm.util.pool.PooledObject;

public class PooledThread
extends PooledObject
implements Runnable {
    protected Thread thread;
    protected boolean done;
    protected String tname;
    Runnable target = null;

    public String toString() {
        return "PooledThread[" + this.tname + "," + this.done + "," + this.thread.getThreadGroup() + "]";
    }

    public PooledThread(ObjectPool pool, String tname) {
        super(pool);
        this.tname = tname;
        this.done = false;
        this.thread = this.newThread(this);
        this.thread.setPriority(5);
        this.thread.setName(tname);
        this.thread.start();
    }

    public void setPriority(int priority) {
        if (priority >= 1 && priority <= 10) {
            this.thread.setPriority(priority);
        }
    }

    public Thread newThread(Runnable target) {
        return new Thread(target, this.tname);
    }

    public void poolInit() {
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poolFree() {
        PooledThread pooledThread = this;
        synchronized (pooledThread) {
            this.done = true;
            this.thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTarget(Runnable target) {
        if (target == null) {
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"target:null"});
        }
        PooledThread pooledThread = this;
        synchronized (pooledThread) {
            this.target = target;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.done && !this.thread.isInterrupted()) {
            PooledThread pooledThread = this;
            synchronized (pooledThread) {
                block21: {
                    Object var4_6;
                    try {
                        block20: {
                            try {
                                while (this.target == null) {
                                    this.wait();
                                }
                                this.target.run();
                                if (Thread.interrupted()) {
                                    // empty if block
                                }
                                if (!this.thread.isInterrupted()) break block20;
                                this.done = true;
                            }
                            catch (InterruptedException e) {
                                var4_6 = null;
                                this.target = null;
                                this.thread.setPriority(5);
                                this.thread.setName(this.tname);
                                if (this.done) {
                                    this.done = true;
                                    this.poolRelease();
                                    break block21;
                                } else {
                                    this.poolReturn();
                                }
                                break block21;
                            }
                            catch (RuntimeException r) {
                                r.printStackTrace();
                                var4_6 = null;
                                this.target = null;
                                this.thread.setPriority(5);
                                this.thread.setName(this.tname);
                                if (this.done) {
                                    this.done = true;
                                    this.poolRelease();
                                    break block21;
                                } else {
                                    this.poolReturn();
                                }
                                break block21;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                var4_6 = null;
                                this.target = null;
                                this.thread.setPriority(5);
                                this.thread.setName(this.tname);
                                if (this.done) {
                                    this.done = true;
                                    this.poolRelease();
                                    break block21;
                                } else {
                                    this.poolReturn();
                                }
                                break block21;
                            }
                        }
                        var4_6 = null;
                        this.target = null;
                    }
                    catch (Throwable throwable) {
                        var4_6 = null;
                        this.target = null;
                        this.thread.setPriority(5);
                        this.thread.setName(this.tname);
                        if (this.done) {
                            this.done = true;
                            this.poolRelease();
                            throw throwable;
                        }
                        this.poolReturn();
                        throw throwable;
                    }
                    this.thread.setPriority(5);
                    this.thread.setName(this.tname);
                    if (this.done) {
                        this.done = true;
                        this.poolRelease();
                    } else {
                        this.poolReturn();
                    }
                }
            }
        }
        this.thread = null;
    }
}

