/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.pool;

import com.wm.util.pool.ObjectPool;

public abstract class PooledObject {
    volatile ObjectPool oPool;
    volatile boolean oUsed;

    public PooledObject(ObjectPool pool) {
        this.oPool = pool;
        this.oUsed = false;
    }

    public abstract void poolInit();

    public abstract void poolFree();

    public void poolReturn() {
        if (this.oUsed) {
            this.oPool.release(this);
        }
    }

    public void poolReturn(boolean reAdd) {
        if (reAdd) {
            this.poolReturn();
        } else {
            this.poolRelease();
        }
    }

    public void poolRelease() {
        if (this.oUsed) {
            this.poolFree();
            this.oPool.release();
            this.oPool = null;
            this.oUsed = false;
        }
    }

    protected void finalize() throws Throwable {
        this.poolRelease();
        super.finalize();
    }
}

