/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.pool;

import com.wm.util.BasisRuntimeException;
import com.wm.util.pool.PooledObject;

public abstract class ObjectPool {
    public long miss = 0L;
    public long draw = 0L;
    public long create = 0L;
    public long drop = 0L;
    private int minPool = 10;
    private int maxPool = 100;
    private int inUse = 0;
    private String pname;
    private PooledObject[] pool;
    private int poolIdx;
    protected Object poolSync;
    private Object idleSync;

    public String toString() {
        return "{pool min=" + this.minPool + " max=" + this.maxPool + " size=" + this.count() + " inUse=" + this.used() + " miss=" + this.miss + " draw=" + this.draw + " drop=" + this.drop + " create=" + this.create + "}";
    }

    public ObjectPool(int minPool, int maxPool) {
        this(minPool, maxPool, "Object Pool", false);
    }

    public ObjectPool(int minPool, int maxPool, String pname) {
        this(minPool, maxPool, pname, false);
    }

    public ObjectPool(int minPool, int maxPool, String pname, boolean delayFill) {
        this.setBounds(minPool, maxPool);
        this.pname = pname;
        this.pool = new PooledObject[minPool];
        this.poolSync = new Object();
        this.idleSync = new Object();
        if (!delayFill) {
            this.initPool();
        }
    }

    public void setBounds(int minPool, int maxPool) {
        if (minPool < 0 || maxPool < 0 || minPool > maxPool && maxPool > 0) {
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"min-max:" + minPool + ":" + maxPool});
        }
        this.minPool = minPool;
        this.maxPool = maxPool;
    }

    public int getMaxSize() {
        return this.maxPool;
    }

    public int getMinSize() {
        return this.minPool;
    }

    public void initPool() {
        for (int i = 0; i < this.minPool; ++i) {
            this.addObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        this.waitIdle();
        Object object = this.poolSync;
        synchronized (object) {
            while (!this.empty()) {
                this.pop().poolFree();
            }
        }
    }

    public long getDraws() {
        return this.draw;
    }

    public long getMisses() {
        return this.miss;
    }

    public final int used() {
        return this.inUse;
    }

    public final int count() {
        return this.pool.length;
    }

    public final int available() {
        return this.count() - this.used();
    }

    public final int allocatable() {
        int ret = this.getMaxSize() - this.used();
        return ret < 0 ? 0 : ret;
    }

    private boolean fillPool() {
        int avail = this.poolIdx;
        int size = avail + this.used();
        if (avail == 0 && (size < this.maxPool || this.maxPool == 0) || size < this.minPool) {
            int add;
            int inc = this.minPool == 0 ? 1 : this.minPool;
            int n = add = this.maxPool == 0 ? inc : Math.min(this.maxPool - size, inc);
            if (add == 0) {
                return false;
            }
            for (int i = 0; i < add; ++i) {
                this.addObject();
            }
            return true;
        }
        return false;
    }

    public String getPoolName() {
        return this.pname;
    }

    public abstract PooledObject createObject();

    public PooledObject allocate() {
        return this.allocate(true, 0L);
    }

    public PooledObject allocate(long time) {
        return this.allocate(true, time);
    }

    public PooledObject allocate(boolean blocking) {
        return this.allocate(blocking, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject allocate(boolean blocking, long time) {
        PooledObject o;
        long waitTime = time;
        long start = System.currentTimeMillis();
        Object object = this.poolSync;
        synchronized (object) {
            ++this.draw;
            while (this.empty()) {
                if (this.fillPool()) continue;
                if (!blocking) {
                    return null;
                }
                ++this.miss;
                if (time < 0L) {
                    return null;
                }
                if (time > 0L) {
                    try {
                        this.poolSync.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if ((waitTime = time - (System.currentTimeMillis() - start)) > 0L) continue;
                    return null;
                }
                try {
                    this.poolSync.wait();
                }
                catch (InterruptedException e) {}
            }
            ++this.inUse;
            o = this.pop();
        }
        o.poolInit();
        o.oUsed = true;
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIdle() {
        Object object = this.idleSync;
        synchronized (object) {
            while (this.used() > 0) {
                try {
                    this.idleSync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.poolSync;
        synchronized (object) {
            ++this.drop;
            if (this.poolIdx < this.minPool) {
                this.fillPool();
            }
            --this.inUse;
            Object object2 = this.idleSync;
            synchronized (object2) {
                if (this.used() == 0) {
                    this.idleSync.notify();
                }
            }
            this.poolSync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(PooledObject o) {
        if (!o.oUsed) {
            throw new BasisRuntimeException("BAC.0001.0048");
        }
        o.oUsed = false;
        Object object = this.poolSync;
        synchronized (object) {
            this.push(o);
            --this.inUse;
            Object object2 = this.idleSync;
            synchronized (object2) {
                if (this.used() == 0) {
                    this.idleSync.notify();
                }
            }
            this.poolSync.notify();
        }
    }

    protected void finalize() {
        this.releaseAll();
    }

    private final void push(PooledObject o) {
        if (this.poolIdx >= this.pool.length) {
            int newlen;
            int inc = this.minPool == 0 ? 1 : this.minPool;
            int n = newlen = this.maxPool == 0 ? this.pool.length + inc : Math.min(this.pool.length + inc, this.maxPool);
            if (newlen != this.pool.length) {
                PooledObject[] newpool = new PooledObject[newlen];
                System.arraycopy(this.pool, 0, newpool, 0, this.pool.length);
                this.pool = newpool;
            }
        }
        if (this.poolIdx >= this.pool.length) {
            this.poolIdx = this.pool.length;
            o.poolRelease();
            o = null;
            return;
        }
        this.pool[this.poolIdx++] = o;
    }

    protected PooledObject pop() {
        return this.pool[--this.poolIdx];
    }

    private final void addObject() {
        this.push(this.createObject());
        ++this.create;
    }

    protected boolean empty() {
        return this.poolIdx == 0;
    }
}

