/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.pool;

import com.wm.util.pool.JDBCConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class JDBCConnectionPoolMgr {
    public static JDBCConnectionPoolMgr _connPoolMgr = null;
    public static Object _syncObj = new Object();
    private Hashtable _connPools = new Hashtable();

    private JDBCConnectionPoolMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDBCConnectionPoolMgr create() {
        Object object = _syncObj;
        synchronized (object) {
            if (_connPoolMgr == null) {
                _connPoolMgr = new JDBCConnectionPoolMgr();
            }
        }
        return _connPoolMgr;
    }

    public synchronized int createConnectionPool(String jdbcDriver, String dbURL, String userid, String pswd, int minconns, int maxconns, int expiretime) throws SQLException {
        JDBCConnectionPool pool = this.findConnPool(jdbcDriver, dbURL, userid, pswd);
        if (pool == null) {
            pool = this.addConnPool(jdbcDriver, dbURL, userid, pswd, minconns, maxconns, expiretime);
        } else {
            pool.setMaxConnections(maxconns);
            pool.setMinConnections(minconns);
            pool.setExpireTime(expiretime);
        }
        return pool.getHandle();
    }

    public Connection getConnection(int handle) throws SQLException {
        JDBCConnectionPool pool = (JDBCConnectionPool)this._connPools.get(new Integer(handle));
        if (pool == null) {
            throw new SQLException("Invalid Connection pool handle");
        }
        return pool.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDBCConnectionPool findConnPool(String jdbcDriver, String dbURL, String userid, String password) {
        JDBCConnectionPool pool = null;
        Hashtable hashtable = this._connPools;
        synchronized (hashtable) {
            Enumeration enumvar = this._connPools.elements();
            while (!(!enumvar.hasMoreElements() || jdbcDriver.equals((pool = (JDBCConnectionPool)enumvar.nextElement()).getJDBCDriver()) && dbURL != null && dbURL.equals(pool.getDBUrl()) && userid != null && userid.equals(pool.getUsername()) && password != null && password.equals(pool.getPassword()))) {
                pool = null;
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDBCConnectionPool addConnPool(String jdbcDriver, String dbURL, String userid, String password, int minconns, int maxconns, int expiretime) throws SQLException {
        JDBCConnectionPool pool = new JDBCConnectionPool(jdbcDriver, dbURL, userid, password, minconns, maxconns, expiretime);
        Hashtable hashtable = this._connPools;
        synchronized (hashtable) {
            this._connPools.put(new Integer(pool.getHandle()), pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllConnPool() throws SQLException {
        boolean rc = false;
        Hashtable hashtable = this._connPools;
        synchronized (hashtable) {
            if (this._connPools.size() == 0) {
                return true;
            }
            Enumeration connpools = this._connPools.elements();
            while (connpools.hasMoreElements()) {
                JDBCConnectionPool pool = (JDBCConnectionPool)connpools.nextElement();
                pool.close();
                if (pool.size() != 0) continue;
                this._connPools.remove(new Integer(pool.getHandle()));
                rc = true;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnPool(int handle) throws SQLException {
        boolean rc = false;
        JDBCConnectionPool pool = (JDBCConnectionPool)this._connPools.get(new Integer(handle));
        if (pool == null) {
            throw new SQLException("Invalid connection pool handle");
        }
        Hashtable hashtable = this._connPools;
        synchronized (hashtable) {
            pool.close();
            if (pool.size() == 0) {
                this._connPools.remove(new Integer(pool.getHandle()));
                rc = true;
            }
        }
        return rc;
    }

    public void releaseConnection(int handle, Connection conn) throws SQLException {
        JDBCConnectionPool pool = (JDBCConnectionPool)this._connPools.get(new Integer(handle));
        if (pool == null) {
            throw new SQLException("Invalid connection pool handle");
        }
        pool.releaseConnection(conn, false);
    }

    public void removeConnection(int handle, Connection conn) throws SQLException {
        JDBCConnectionPool pool = (JDBCConnectionPool)this._connPools.get(new Integer(handle));
        if (pool == null) {
            throw new SQLException("Invalid connection pool handle");
        }
        pool.releaseConnection(conn, true);
    }
}

