/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.pool;

import com.merant.SlExtensionInterface;
import com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection;
import com.wm.util.synch.LatchedSemaphore;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class JDBCConnectionPool {
    private static final String MERANT_OEM = "webMethods";
    private final int AVAIL = 1;
    private final int INUSE = 2;
    private int _maxConns = 1;
    private int _minConns = 0;
    private int _expireTime = 0;
    private int _availConns = 0;
    private String _jdbcDriver = null;
    private String _dbURL = null;
    private String _userid = null;
    private String _pswd = null;
    private Vector _connections = new Vector();
    private LatchedSemaphore _latch = new LatchedSemaphore(true);
    private ConnectionTimeoutMgr _timeoutMgr = null;
    private int _poolHandle = 0;
    private static int _handles = 0;

    public JDBCConnectionPool(String jdbcDriver, String dbURL, String userid, String password, int minconns, int maxconns, int expiretime) throws SQLException {
        this.setMaxConnections(maxconns);
        this._userid = userid;
        this._pswd = password;
        this._jdbcDriver = jdbcDriver;
        this._dbURL = dbURL;
        this.setMinConnections(minconns);
        this._expireTime = expiretime;
        this._poolHandle = this.getNextHandle();
        try {
            Class.forName(this._jdbcDriver);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        if (this._minConns > 0) {
            for (int i = 0; i < this._minConns; ++i) {
                this._connections.addElement(new ConnectionEntry());
            }
            this._availConns = this._minConns;
        }
        this.initTimeoutMgr();
    }

    public String getUsername() {
        return this._userid;
    }

    public String getPassword() {
        return this._pswd;
    }

    public int getMaxConnections() {
        return this._maxConns;
    }

    public void setMaxConnections(int m) {
        if (m > this._maxConns) {
            this._maxConns = m;
        }
    }

    public void setMinConnections(int m) {
        if (m > this._minConns) {
            this._minConns = m;
        }
    }

    public int getMinConnections() {
        return this._minConns;
    }

    public int getExpireTime() {
        return this._expireTime;
    }

    public String getJDBCDriver() {
        return this._jdbcDriver;
    }

    public String getDBUrl() {
        return this._dbURL;
    }

    public int size() {
        return this._connections.size();
    }

    public int getHandle() {
        return this._poolHandle;
    }

    private synchronized int getNextHandle() {
        return ++_handles;
    }

    public void setExpireTime(int t) {
        if (t > this._expireTime) {
            this._expireTime = t;
            this._timeoutMgr.setIntervalTime();
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        Connection conn = null;
        while ((conn = this.getAvailConnection()) == null) {
            try {
                this._latch.semWait();
            }
            catch (InterruptedException e) {
                throw new SQLException("Interrupted while waiting for next available connection");
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection conn, boolean close) {
        Vector vector = this._connections;
        synchronized (vector) {
            for (int i = 0; i < this._connections.size(); ++i) {
                ConnectionEntry entry = (ConnectionEntry)this._connections.elementAt(i);
                if (entry.getConnection() != conn) continue;
                entry.setAvail();
                if (close) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this._connections.removeElement(entry);
                } else {
                    ++this._availConns;
                }
                this._latch.semPost();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getAvailConnection() throws SQLException {
        ConnectionEntry entry = null;
        this.checkTimeoutMgr();
        Vector vector = this._connections;
        synchronized (vector) {
            if (this._availConns == 0 && this._connections.size() >= this._maxConns) {
                this._latch.semReset();
                return null;
            }
            if (this._availConns == 0) {
                entry = new ConnectionEntry();
                entry.setInUse();
                this._connections.addElement(entry);
                return entry.getConnection();
            }
            for (int i = 0; i < this._connections.size(); ++i) {
                entry = (ConnectionEntry)this._connections.elementAt(i);
                if (!entry.isAvail()) continue;
                entry.setInUse();
                if (this._availConns > 0) {
                    --this._availConns;
                }
                return entry.getConnection();
            }
        }
        this._latch.semReset();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Vector vector = this._connections;
        synchronized (vector) {
            for (int i = 0; i < this._connections.size(); ++i) {
                ConnectionEntry entry = (ConnectionEntry)this._connections.elementAt(i);
                if (!entry.isAvail()) continue;
                if (entry.getConnection() != null) {
                    try {
                        entry.getConnection().close();
                    }
                    catch (SQLException sqlex) {
                        // empty catch block
                    }
                }
                this._connections.removeElement(entry);
                if (this._availConns > 0) {
                    --this._availConns;
                }
                --i;
            }
            if (this._connections.size() == 0) {
                this._timeoutMgr.shutdown();
            } else {
                this._minConns = 0;
            }
        }
    }

    private void checkTimeoutMgr() {
        if (this._timeoutMgr != null && this._timeoutMgr.isAlive()) {
            return;
        }
        this.initTimeoutMgr();
    }

    private void initTimeoutMgr() {
        this._timeoutMgr = new ConnectionTimeoutMgr();
        this._timeoutMgr.setDaemon(true);
        this._timeoutMgr.start();
    }

    class ConnectionTimeoutMgr
    extends Thread {
        private int _interval = 0;
        private boolean _state = true;

        public ConnectionTimeoutMgr() {
            this.setIntervalTime();
        }

        public void shutdown() {
            this._state = false;
        }

        public void setIntervalTime() {
            this._interval = JDBCConnectionPool.this._expireTime + JDBCConnectionPool.this._expireTime / 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this._state) {
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait(this._interval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                object = JDBCConnectionPool.this._connections;
                synchronized (object) {
                    if (JDBCConnectionPool.this._connections.size() > JDBCConnectionPool.this._minConns) {
                        for (int i = 0; i < JDBCConnectionPool.this._connections.size(); ++i) {
                            ConnectionEntry entry = (ConnectionEntry)JDBCConnectionPool.this._connections.elementAt(i);
                            if (!entry.isExpired()) continue;
                            JDBCConnectionPool.this._connections.removeElementAt(i);
                            --i;
                            if (JDBCConnectionPool.this._availConns > 0) {
                                JDBCConnectionPool.this._availConns--;
                            }
                            try {
                                entry.getConnection().close();
                                continue;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }

    class ConnectionEntry {
        private int _state = 1;
        private long _lastUsed = 0L;
        private Connection _connection = null;

        public ConnectionEntry() throws SQLException {
            this._connection = DriverManager.getConnection(JDBCConnectionPool.this._dbURL, JDBCConnectionPool.this._userid, JDBCConnectionPool.this._pswd);
            try {
                if (this._connection instanceof SlExtensionInterface) {
                    ((SlExtensionInterface)this._connection).setOemId(JDBCConnectionPool.MERANT_OEM);
                }
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            try {
                if (this._connection instanceof ExtEmbeddedConnection) {
                    ((ExtEmbeddedConnection)this._connection).unlock(JDBCConnectionPool.MERANT_OEM);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        public Connection getConnection() {
            return this._connection;
        }

        public boolean isAvail() {
            return this._state == 1;
        }

        public void setInUse() {
            this._state = 2;
        }

        public void setAvail() {
            this._state = 1;
            this._lastUsed = System.currentTimeMillis();
        }

        public boolean isExpired() {
            long _dur = System.currentTimeMillis() - this._lastUsed;
            return this.isAvail() && _dur >= (long)JDBCConnectionPool.this._expireTime;
        }
    }
}

