/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.io;

import com.wm.util.io.Console;
import com.wm.util.security.WmSecureString;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class POSIXConsole
extends Console {
    private boolean _hasStty;
    private FileInputStream _in = new FileInputStream(FileDescriptor.in);
    private PrintWriter _out = new PrintWriter(System.out);
    private Character _mask;

    public POSIXConsole(Character inMask) {
        this._mask = inMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WmSecureString readLine(String prompt, String intro) throws IOException {
        WmSecureString wmSecureString;
        String origSettings = null;
        try {
            try {
                this._hasStty = false;
                origSettings = this.stty("-g");
                if (origSettings.length() == 0) throw new IOException("Invalid stty settings: " + origSettings);
                if (origSettings.indexOf("=") == -1 && origSettings.indexOf(":") == -1) {
                    throw new IOException("Invalid stty settings: " + origSettings);
                }
                if (prompt != null && prompt.length() > 0) {
                    this._out.write(prompt);
                    this._out.flush();
                }
                this.stty("-icanon min 1");
                this.stty("-echo");
                this._hasStty = true;
                wmSecureString = this.getLine(this._mask);
                Object var8_6 = null;
                if (origSettings == null) return wmSecureString;
            }
            catch (IOException ioe) {
                Console c = new Console();
                WmSecureString wmSecureString2 = c.readLine(prompt, intro);
                Object var8_7 = null;
                if (origSettings == null) return wmSecureString2;
                try {
                    this.stty(origSettings);
                    return wmSecureString2;
                }
                catch (IOException ie) {
                    // empty catch block
                }
                return wmSecureString2;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (origSettings == null) throw throwable;
            try {}
            catch (IOException ie) {
                throw throwable;
            }
            this.stty(origSettings);
            throw throwable;
        }
        try {}
        catch (IOException ie) {
            // empty catch block
            return wmSecureString;
        }
        this.stty(origSettings);
        return wmSecureString;
    }

    protected WmSecureString getLine(Character mask) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = this._in.read()) != -1) {
            if (c == 10 || c == 13) {
                this._out.write(System.getProperty("line.separator"));
                this._out.flush();
                return new WmSecureString(buf.toString());
            }
            if (c == 127) {
                if (buf.length() <= 0) continue;
                buf.deleteCharAt(buf.length() - 1);
                String erase = "\b \b";
                if (mask != null && mask.equals(NO_ECHO)) continue;
                this._out.write(erase);
                this._out.flush();
                continue;
            }
            buf.append((char)c);
            this.putChar(c, mask);
            this._out.flush();
        }
        return null;
    }

    private void readStream(InputStream is, ByteArrayOutputStream boas) throws IOException {
        int c;
        while ((c = is.read()) != -1) {
            boas.write(c);
        }
    }

    private String stty(String args) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        String[] cmd = new String[]{"sh", "-c", "stty " + args + " < /dev/tty"};
        Process p = Runtime.getRuntime().exec(cmd);
        try {
            this.readStream(p.getInputStream(), boas);
            this.readStream(p.getErrorStream(), boas);
            p.waitFor();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return boas.toString().trim();
    }

    private void putChar(int c, Character mask) throws IOException {
        if (!this._hasStty || mask == null) {
            this._out.write(c);
        } else if (mask.charValue() != '\u0000') {
            this._out.write(mask.charValue());
        }
    }

    public static void main(String[] args) {
        try {
            POSIXConsole c = new POSIXConsole(Console.NO_ECHO);
            WmSecureString pw = c.readLine("password: ", "looking for a password");
            System.out.println("pw: '" + pw + "'");
        }
        catch (Throwable t) {
            System.out.println("caught this: " + t.getClass().getName() + "), msg(" + t.getMessage() + ")");
            t.printStackTrace(System.out);
        }
    }
}

