/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.io;

import com.wm.util.io.POSIXConsole;
import com.wm.util.security.WmSecureString;
import java.io.IOException;

public class Console {
    public static final Character NO_ECHO = new Character('\u0000');

    public static Console get(Character inMask) {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows") ? new Console() : new POSIXConsole(inMask);
    }

    public WmSecureString readLine(String prompt, String intro) throws IOException {
        StringBuffer buf = new StringBuffer();
        if (intro != null && intro.length() > 0) {
            System.out.println(intro);
            System.out.flush();
        }
        ConsoleMaskingThread masker = new ConsoleMaskingThread(prompt);
        masker.start();
        while (true) {
            int c = System.in.read();
            if (masker != null) {
                masker.end();
                masker = null;
            }
            if (c == -1 || c == 10 || c == 13) break;
            if (c == 127) {
                if (buf.length() <= 0) continue;
                buf.deleteCharAt(buf.length() - 1);
                continue;
            }
            buf.append((char)c);
        }
        return new WmSecureString(buf.toString());
    }

    public static void main(String[] args) {
        String intro = "\nTesting console password prompt\n\n";
        String prompt = "password: ";
        try {
            Console c = new Console();
            WmSecureString pw = c.readLine("password: ", "\nTesting console password prompt\n\n");
            System.out.println("pw: '" + pw + "'");
        }
        catch (Throwable t) {
            System.out.println("caught this: " + t.getClass().getName() + "), msg(" + t.getMessage() + ")");
            t.printStackTrace(System.out);
        }
    }

    private static class ConsoleMaskingThread
    extends Thread {
        private volatile boolean stop = false;
        private String prompt = null;

        public ConsoleMaskingThread(String prompt) {
            this.prompt = prompt;
            this.stop = false;
        }

        public void end() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int savedPrio = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            System.out.print(this.prompt);
            try {
                String MASK = "\b ";
                while (!this.stop) {
                    System.out.print("\b ");
                    try {
                        ConsoleMaskingThread.sleep(1L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                Object var5_4 = null;
                Thread.currentThread().setPriority(savedPrio);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Thread.currentThread().setPriority(savedPrio);
                throw throwable;
            }
        }
    }
}

