/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.i18n;

import com.wm.util.i18n.ResourceBundleWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceFormatter {
    protected ResourceBundle bundle;
    private ResourceBundleWriter writer = null;
    private boolean strict;

    public ResourceFormatter(String bundleName) {
        Locale locale = Locale.getDefault();
        this.bundle = ResourceBundle.getBundle(bundleName, locale);
        this.writer = new ResourceBundleWriter(this.bundle);
        this.strict = false;
    }

    public String getValue(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.strict) {
                throw e;
            }
            return null;
        }
    }

    public String getString(String key) {
        return this.getString(key, new Object[0]);
    }

    public String getString(String key, Object[] args) {
        String msg = this.getValue(key);
        if (msg == null) {
            if (this.writer != null) {
                this.writer.addKey(key);
                this.writer.update();
            }
            msg = key;
        }
        return MessageFormat.format(msg, args);
    }

    public ResourceBundleWriter getWriter() {
        return this.writer;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

