/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.i18n;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ResourceBundleWriter {
    protected ResourceBundle bundle;
    protected Vector addedKeys;
    protected File sourceFile = null;
    protected boolean writable = true;
    private boolean sorted;
    private Set contents = null;

    public ResourceBundleWriter(ResourceBundle bundle) {
        this.bundle = bundle;
        this.sorted = true;
        this.addedKeys = new Vector();
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void addKey(String key) {
        this.addedKeys.add(key);
    }

    public void update() {
        if (this.contents == null) {
            this.readContents();
        }
        for (String key : this.addedKeys) {
            this.contents.add(new String[]{key, key});
        }
        this.addedKeys.clear();
        this.writeCode();
    }

    protected File findFile(String fname, String dir) {
        File f = new File(dir, fname);
        if (f.exists()) {
            return f;
        }
        File[] files = new File(dir).listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isDirectory()) {
                f = this.findFile(fname, files[i].getAbsolutePath());
                if (f == null) continue;
                return f;
            }
            if (!files[i].isFile() || !files[i].getAbsolutePath().endsWith(fname)) continue;
            return files[i];
        }
        return null;
    }

    protected static void pad(StringBuffer buf, int length) {
        int nSpaces = length - buf.length();
        while (nSpaces-- > 0) {
            buf.append(" ");
        }
    }

    protected void writeCode() {
        if (this.writable) {
            String bundClsName = this.bundle.getClass().getName();
            int locPos = bundClsName.indexOf("_en_US");
            if (locPos != -1) {
                bundClsName = bundClsName.substring(0, locPos);
            }
            int dotPos = bundClsName.lastIndexOf(46);
            String bundName = bundClsName.substring(dotPos + 1);
            String bundPkg = bundClsName.substring(0, dotPos);
            String bundFileName = bundClsName.replace('.', File.separatorChar) + ".java";
            Vector<String> code = new Vector<String>();
            code.add("// This file was generated/updated by ResourceBundleWriter " + new Date() + ".");
            code.add("// It is safe to edit this file directly.");
            code.add("");
            code.add("package " + bundPkg + ";");
            code.add("");
            code.add("");
            code.add("public class " + bundName + " extends java.util.ListResourceBundle");
            code.add("{");
            code.add("    /**");
            code.add("      * Returns the contents of the bundle.");
            code.add("      */");
            code.add("    public Object[][] getContents() ");
            code.add("    {");
            code.add("        return CONTENTS;");
            code.add("    }");
            code.add("");
            code.add("    private final static String[][] CONTENTS = {");
            int lastEntry = this.contents.size() - 1;
            Iterator cit = this.contents.iterator();
            int i = 0;
            while (cit.hasNext()) {
                String[] pair = (String[])cit.next();
                int WIDTH = 40;
                StringBuffer lhs = new StringBuffer("\"" + ResourceBundleWriter.escape(pair[0]) + "\",");
                StringBuffer rhs = new StringBuffer("\"" + ResourceBundleWriter.escape(pair[1]) + "\"");
                ResourceBundleWriter.pad(lhs, 40);
                ResourceBundleWriter.pad(rhs, 40);
                code.add("        { " + lhs + " " + rhs + " }" + (i == lastEntry ? "" : ","));
                ++i;
            }
            code.add("    };");
            code.add("");
            code.add("}");
            if (this.sourceFile == null) {
                String[] dirs = new String[]{".." + File.separator + ".."};
                for (int di = 0; this.sourceFile == null && di < dirs.length; ++di) {
                    this.sourceFile = this.findFile(File.separator + bundFileName, dirs[di]);
                }
                if (this.sourceFile == null) {
                    this.writable = false;
                }
            }
            if (this.sourceFile != null) {
                this.writeCode(code);
            }
        }
    }

    public static String escape(String s) {
        StringBuffer buf = new StringBuffer(s);
        block4: for (int i = 0; i < buf.length(); ++i) {
            switch (buf.charAt(i)) {
                case '\"': {
                    buf.insert(i, '\\');
                    ++i;
                    continue block4;
                }
                case '\n': {
                    buf.setCharAt(i, 'n');
                    buf.insert(i, '\\');
                    ++i;
                }
            }
        }
        return buf.toString();
    }

    protected void writeCode(Vector srcCode) {
        String eoline = System.getProperty("line.separator");
        boolean written = false;
        for (int i = 0; !written && i < 2; ++i) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(this.sourceFile));
                for (String code : srcCode) {
                    pw.println(code);
                }
                pw.close();
                written = true;
                continue;
            }
            catch (FileNotFoundException fnfe) {
                if (fnfe.getMessage().indexOf("(Permission denied)") <= 0) continue;
                this.makeWritable(this.sourceFile);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!written) {
            this.writable = false;
        }
    }

    protected void readContents() {
        if (this.sorted) {
            this.contents = new TreeSet(new Comparator(){

                public int compare(Object a, Object b) {
                    String[] aa = (String[])a;
                    String[] bb = (String[])b;
                    int c = aa[0].compareTo(bb[0]);
                    if (c == 0) {
                        c = aa[1].compareTo(bb[1]);
                    }
                    return c;
                }

                public boolean equals(Object a, Object b) {
                    String[] aa = (String[])a;
                    String[] bb = (String[])b;
                    return aa[0].equals(bb[0]) && aa[1].equals(bb[1]);
                }
            });
        }
        try {
            Class<?> cls = this.bundle.getClass();
            Method cont = cls.getMethod("getContents", null);
            Object[][] contList = (Object[][])cont.invoke((Object)this.bundle, (Object[])null);
            for (int i = 0; i < contList.length; ++i) {
                String key = (String)contList[i][0];
                String str = (String)contList[i][1];
                this.contents.add(new String[]{key, str});
            }
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace(System.out);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace(System.out);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace(System.out);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace(System.out);
        }
    }

    public void makeWritable(File srcFile) {
    }
}

