/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.event;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.util.coder.IDataCodable;
import com.wm.util.event.Event;

public abstract class EventSubscriber
implements IDataCodable {
    private static final int NOID = -1;
    private int gID = -1;
    private boolean gEnabled;
    private boolean gPersist = true;

    public EventSubscriber() {
        this.gEnabled = true;
    }

    public EventSubscriber(boolean enabled) {
        this.gEnabled = enabled;
    }

    public abstract boolean processEvent(Event var1);

    public void setID(int id) {
        this.gID = id;
    }

    public int getID() {
        return this.gID;
    }

    public boolean isEnabled() {
        return this.gEnabled;
    }

    public void enable(boolean e) {
        this.gEnabled = e;
    }

    public void setPersist(boolean persist) {
        this.gPersist = persist;
    }

    public boolean getPersist() {
        return this.gPersist;
    }

    public void setIData(IData idata) {
        IDataCursor idhc = idata.getCursor();
        this.gID = idhc.first("gID") ? (Integer)idhc.getValue() : 0;
        this.gEnabled = idhc.first("Enabled") ? ((String)idhc.getValue()).equals("true") : false;
        idhc.destroy();
    }

    public IData getIData() {
        IData idata = IDataFactory.create();
        IDataCursor idc = idata.getCursor();
        idc.insertAfter("gID", new Integer(this.gID));
        if (this.isEnabled()) {
            idc.insertAfter("Enabled", "true");
        } else {
            idc.insertAfter("Enabled", "false");
        }
        idc.destroy();
        return idata;
    }
}

