/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.event;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.util.coder.IDataCodable;
import com.wm.util.event.Event;
import com.wm.util.event.EventSubscriber;
import java.util.Enumeration;
import java.util.Vector;

public abstract class EventQueue
implements IDataCodable {
    Vector subscribers = new Vector();
    int numSubscribers = 0;

    public abstract void sendEvent(Event var1);

    public void subscribe(EventSubscriber subscriber) {
        if (!this.subscribers.contains(subscriber)) {
            this.subscribers.addElement(subscriber);
            ++this.numSubscribers;
        }
    }

    public void unsubscribe(int subID) {
        EventSubscriber es = this.getByID(subID);
        if (es != null) {
            this.unsubscribe(es);
        }
    }

    public void unsubscribe(EventSubscriber subscriber) {
        if (this.subscribers.contains(subscriber)) {
            this.subscribers.removeElement(subscriber);
            --this.numSubscribers;
            if (this.numSubscribers < 0) {
                this.numSubscribers = 0;
            }
        }
    }

    public void enableSubscriber(int subID, boolean enable) {
        EventSubscriber es = this.getByID(subID);
        if (es != null) {
            es.enable(enable);
        }
    }

    public EventSubscriber getByID(int subID) {
        Enumeration e = this.getSubscribers();
        while (e.hasMoreElements()) {
            EventSubscriber es = (EventSubscriber)e.nextElement();
            if (es.getID() != subID) continue;
            return es;
        }
        return null;
    }

    public Enumeration getSubscribers() {
        return this.subscribers.elements();
    }

    public int getSubscriberCount() {
        return this.numSubscribers;
    }

    public void setIData(IData idata) {
        IDataCursor idhc = idata.getCursor();
        this.subscribers = idhc.first("subscribers") ? (Vector)idhc.getValue() : null;
        this.numSubscribers = idhc.first("numSubscribers") ? (Integer)idhc.getValue() : 0;
        idhc.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IData getIData() {
        IData idata = IDataFactory.create();
        IDataCursor idc = idata.getCursor();
        Vector<EventSubscriber> temp = new Vector<EventSubscriber>(this.subscribers.size());
        Vector vector = this.subscribers;
        synchronized (vector) {
            Enumeration e = this.subscribers.elements();
            while (e.hasMoreElements()) {
                EventSubscriber es = (EventSubscriber)e.nextElement();
                if (!es.getPersist()) {
                    --this.numSubscribers;
                    continue;
                }
                temp.addElement(es);
            }
        }
        idc.insertAfter("subscribers", temp);
        idc.insertAfter("numSubscribers", new Integer(this.numSubscribers));
        idc.destroy();
        return idata;
    }
}

