/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.data;

import com.wm.data.DataCursorEmulator;
import com.wm.data.DataDeadlockException;
import com.wm.data.DataException;
import com.wm.data.DataInterruptedException;
import com.wm.data.DataNoActiveTxnException;
import com.wm.data.IData;
import com.wm.data.IDataAdmin;
import com.wm.data.IDataCursor;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.txn.ITransaction;
import com.wm.txn.ITransactionResource;
import com.wm.txn.TransactionException;
import com.wm.util.BasisRuntimeException;
import com.wm.util.StopWatch;
import com.wm.util.codec.BinaryCodec;
import com.wm.util.codec.SimpleReferenceManager;
import com.wm.util.data.CoderWrapper;
import com.wm.util.data.ITxnDataCursor;
import com.wm.util.sync.LatchedSemaphore;
import com.wm.util.sync.WmMutex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;

public class TxnData {
    static final int NODEBUG = 0;
    static final int DEBUG1 = 1;
    static final int DEBUG2 = 2;
    static final int DEBUG3 = 4;
    static final int DEBUG4 = 8;
    static final int DEBUG5 = 16;
    static final int DEBUG6 = 32;
    static final int DEBUG7 = 64;
    static final int DEBUG8 = 128;
    static final int DEBUG9 = 256;
    static final int DEBUG10 = 512;
    static final int DEBUG11 = 1024;
    static final int DEBUG12 = 2048;
    static final int DEBUG13 = 4096;
    static final int DEBUG14 = 8192;
    static final int DEBUGALL = 8191;
    static int debug = 0;
    static final int DELETEREF = 1;
    static final int DESTROYED = 2;
    static final int INSERTED = 4;
    static final int UPDATED = 8;
    static final int DELETED = 16;
    static final int UNLOCKED = 32;
    static final int PENDING_INSERT = 64;
    static final int PENDING_INSERTDATA = 128;
    static final int PENDING_DELETE = 256;
    static final int PENDING_UPDATE = 512;
    static final int PENDING_READLOCK = 1024;
    static final int NOPENDING = 1984;
    static final int NOCHANGE = 2048;
    static final byte INSERTAFTER = 1;
    static final byte INSERTBEFORE = 2;
    static final byte PERSISTENT = 1;
    static final byte VOLATILE = 2;
    static final short BEFORE_IMAGE = 1;
    static final short AFTER_IMAGE = 2;
    static final short NULLVALUE = 4;
    static final short SOFTREF = 16;
    static final short KEYCHANGED = 32;
    static final short VALUECHANGED = 64;
    static final short BACKINGSTORE = 128;
    static final short PERSISTNODE = 256;
    static final long tm_deadlock = 250L;
    static final int INIT_CACHE_THRESHOLD = 500;
    private static final String COREBUNDLE = "com.wm.resources.CoreExcpMsgs";
    private Object _commitLock = new Object();
    Object _sync = new Object();
    static int _id = 0;
    private byte _storeType = (byte)2;
    private IData _store;
    private Hashtable _idataRefs = new Hashtable();
    private Vector _activeTxns = new Vector();
    static DeadlockManager _deadlockMgr;
    int _maxLUWDuration = -1;
    TData _theData;
    private boolean _forceRefCacheRefresh = true;
    private int _hash_min = 10000;

    public static TxnData create() {
        return new TxnData();
    }

    public static TxnData create(IData data) {
        return new TxnData(data);
    }

    private TxnData() {
        this(null);
    }

    private TxnData(IData data) {
        this._store = data;
        if (this._store != null) {
            this._storeType = 1;
        }
        if (_deadlockMgr == null) {
            _deadlockMgr = new DeadlockManager();
            _deadlockMgr.setDaemon(true);
            _deadlockMgr.setName("TxnData-Deadlock-Manager");
            _deadlockMgr.start();
        }
        _deadlockMgr.register(this);
    }

    int getHashMin() {
        return this._hash_min;
    }

    public void setMaxLUWDuration(int max) {
        this._maxLUWDuration = max;
    }

    boolean isMaxLUWEnabled() {
        return this._maxLUWDuration != -1;
    }

    int getMaxLUWDuration() {
        return this._maxLUWDuration;
    }

    public void enableEncodeCache() {
        this._forceRefCacheRefresh = true;
    }

    public void disableEncodeCache() {
        this._forceRefCacheRefresh = false;
    }

    public boolean isEncodeEnabled() {
        return this._forceRefCacheRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTxnId() {
        Object object = this._sync;
        synchronized (object) {
            return _id++;
        }
    }

    void dumpActiveTxns() {
        for (int i = 0; i < this._activeTxns.size(); ++i) {
            Txn t = (Txn)this._activeTxns.elementAt(i);
            this.log("Active Txn=" + t.toString() + " node cnt=" + t.getOwnedNodesSize());
            t.dumpOwnedNodes();
        }
    }

    boolean DebugOn(int s) {
        boolean rc = false;
        if ((debug & s) != 0) {
            rc = true;
        }
        return rc;
    }

    boolean isBackingStoreType(Object o) {
        boolean rc = false;
        if (this._store != null && o != null && this._store.getClass() == o.getClass()) {
            rc = true;
        }
        return rc;
    }

    public IData getData() {
        boolean refresh = false;
        if (this._store != null) {
            refresh = true;
        }
        if (this._theData == null) {
            this._theData = new TData(this, null, null, this._store, refresh);
        }
        return this._theData;
    }

    synchronized void addIDataRef(TData data) {
        TData d = null;
        IData k = data._backingStore;
        if (k != null) {
            d = (TData)this._idataRefs.get(k);
            if (d != null) {
                d.incrUsage();
            } else {
                this._idataRefs.put(k, data);
            }
        }
    }

    synchronized void removeIDataRef(TData data) {
        IData k = data._backingStore;
        if (k != null) {
            this._idataRefs.remove(k);
        }
    }

    synchronized TData findIDataRef(IData data) {
        TData td = null;
        if (data != null) {
            td = (TData)this._idataRefs.get(data);
        }
        return td;
    }

    void log(String msg) {
        System.out.println(Thread.currentThread().getName() + ": " + msg);
    }

    public void close() {
        _deadlockMgr.unregister(this);
        if (this._idataRefs != null) {
            this._idataRefs.clear();
        }
        if (this._activeTxns != null) {
            for (int i = 0; i < this._activeTxns.size(); ++i) {
                ITransaction t = (ITransaction)this._activeTxns.elementAt(i);
                try {
                    t.abortTXN();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._activeTxns.removeAllElements();
        }
        this._theData = null;
    }

    void addActiveTrans(ITransaction txn) {
        this._activeTxns.addElement(txn);
    }

    void removeActiveTrans(ITransaction txn) {
        this._activeTxns.removeElement(txn);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    class DeadlockManager
    extends Thread {
        boolean _done = false;
        long _interval = 30000L;
        Vector _txndata = new Vector();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Txn txn1 = null;
            Txn txn2 = null;
            boolean skip = false;
            boolean foundOwningTxn = false;
            Object delay = new Object();
            TxnData data = null;
            long limitdur = -1L;
            while (!this._done) {
                try {
                    Object object = delay;
                    synchronized (object) {
                        delay.wait(this._interval);
                    }
                    for (int k = 0; k < this._txndata.size(); ++k) {
                        data = (TxnData)this._txndata.elementAt(k);
                        if (data.isMaxLUWEnabled()) {
                            limitdur = data.getMaxLUWDuration();
                            if (limitdur > this._interval) {
                                this._interval = limitdur;
                            }
                        } else {
                            limitdur = -1L;
                        }
                        Object object2 = data._commitLock;
                        synchronized (object2) {
                            int i;
                            if (TxnData.this.DebugOn(1024)) {
                                TxnData.this.log("DeadlockManager: starting.....");
                            }
                            skip = false;
                            foundOwningTxn = false;
                            Node node = null;
                            int size = data._activeTxns.size();
                            boolean checkDeadlock = false;
                            for (i = 0; i < size; ++i) {
                                txn1 = (Txn)data._activeTxns.elementAt(i);
                                if (txn1.isActive() || limitdur <= 0L || txn1.getWaitDuration() < limitdur) continue;
                                checkDeadlock = true;
                                break;
                            }
                            if (checkDeadlock) {
                                for (i = 0; i < size; ++i) {
                                    txn1 = (Txn)data._activeTxns.elementAt(i);
                                    if (!txn1.isDead() && txn1.isActive() && data.isMaxLUWEnabled()) {
                                        boolean foundone = false;
                                        long maxdur = txn1.getLUWtime();
                                        if (limitdur > 0L && maxdur > limitdur) {
                                            for (int j = 0; j < size; ++j) {
                                                txn2 = (Txn)data._activeTxns.elementAt(j);
                                                node = txn2.getWaitingForNode();
                                                if (txn1 == txn2 || txn2.isDead() || txn2.isActive() || !txn1.owns(node) || txn1._criticalSection) continue;
                                                txn1.setDeadlock();
                                                txn1.abortTXN(true);
                                                foundone = true;
                                                break;
                                            }
                                        }
                                        if (foundone) continue;
                                    }
                                    if (!txn1.isDead() && !txn1.isActive()) {
                                        node = txn1.getWaitingForNode();
                                        for (int j = 0; j < size; ++j) {
                                            txn2 = (Txn)data._activeTxns.elementAt(j);
                                            if (txn1 != txn2 && !txn2.isDead() && !txn2.isActive() && txn2.owns(node) && txn1.owns(txn2.getWaitingForNode())) {
                                                String rootkey;
                                                long dur2;
                                                long dur1 = txn1.getLUWtime();
                                                if (dur1 > (dur2 = txn2.getLUWtime())) {
                                                    if (TxnData.this.DebugOn(1024)) {
                                                        rootkey = null;
                                                        if (node instanceof Element) {
                                                            rootkey = ((Element)node).getRootKey();
                                                        }
                                                        if (node instanceof Root) {
                                                            rootkey = ((Root)node).getRootKey();
                                                        }
                                                        TxnData.this.log("DeadlockManager: root=" + rootkey + ", node=" + node.getKey() + ", txn " + txn1);
                                                    }
                                                    if (!txn1._criticalSection) {
                                                        txn1.setDeadlock();
                                                        txn1.abortTXN(true);
                                                    }
                                                } else {
                                                    if (TxnData.this.DebugOn(1024)) {
                                                        rootkey = null;
                                                        if (node instanceof Element) {
                                                            rootkey = ((Element)node).getRootKey();
                                                        }
                                                        if (node instanceof Root) {
                                                            rootkey = ((Root)node).getRootKey();
                                                        }
                                                        TxnData.this.log("DeadlockManager: root=" + rootkey + ", node=" + node.getKey() + ", txn " + txn2);
                                                    }
                                                    if (!txn2._criticalSection) {
                                                        txn2.setDeadlock();
                                                        txn2.abortTXN(true);
                                                    }
                                                }
                                                skip = true;
                                                break;
                                            }
                                            if (txn1 == txn2 || !txn2.owns(node)) continue;
                                            foundOwningTxn = true;
                                        }
                                        if (!foundOwningTxn && !skip && node.getTransaction() != null) {
                                            node.luwUnlock(node.getTransaction());
                                            skip = true;
                                            ((Root)node)._txnLock.semPost();
                                        }
                                    }
                                    if (skip) break;
                                }
                            }
                            continue;
                        }
                    }
                    if (!TxnData.this.DebugOn(1024)) continue;
                    TxnData.this.log("DeadlockManager: going back to sleep.....");
                }
                catch (InterruptedException e) {
                    if (TxnData.this.DebugOn(1024)) {
                        TxnData.this.log("DeadlockManager: interrupted shutdown=" + this._done);
                    }
                    this._done = true;
                    break;
                }
                catch (Exception e) {
                    if (!TxnData.this.DebugOn(1024)) continue;
                    TxnData.this.log("DeadlockManager: continuing after exception:" + e.getClass().getName() + ":" + e.getMessage());
                }
            }
        }

        public void register(TxnData data) {
            this._txndata.addElement(data);
        }

        public void unregister(TxnData data) {
            this._txndata.removeElement(data);
        }

        public void shutdown() {
            this._done = true;
        }
    }

    final class TxnDataIndex {
        private TreeMap map = new TreeMap();
        private static final boolean debug = false;

        public TxnDataIndex(Node first) {
            if (first != null) {
                this.insertNew(first);
                for (Node e = first.getNext(); e != null; e = e.getNext()) {
                    this.insertAfter(e.getPrev(), e);
                }
            }
        }

        public Node first(String key) {
            LinkedList l = (LinkedList)this.map.get(key);
            if (l != null) {
                return (Node)l.getFirst();
            }
            return null;
        }

        public Node last(String key) {
            LinkedList l = (LinkedList)this.map.get(key);
            if (l != null) {
                return (Node)l.getLast();
            }
            return null;
        }

        public Node seek(Node current, boolean snext) {
            int idx;
            LinkedList l = (LinkedList)this.map.get(current.getKey());
            if (l != null && (idx = l.indexOf(current)) > -1) {
                idx = snext ? ++idx : --idx;
                if (idx > -1 && idx < l.size()) {
                    return (Element)l.get(idx);
                }
            }
            return null;
        }

        public void delete(Node e) {
            this.delete(e, null);
        }

        public void delete(Node e, String key) {
            LinkedList l;
            if (key == null) {
                key = e.getKey();
            }
            if ((l = (LinkedList)this.map.get(key)) != null) {
                l.remove(e);
                if (l.size() == 0) {
                    this.map.remove(key);
                }
            }
        }

        public void insertAfter(Node prev, Node e) {
            if (e.keyMatch(prev)) {
                LinkedList l = (LinkedList)this.map.get(prev.getKey());
                if (l != null) {
                    int n = l.indexOf(prev);
                    if (n > -1) {
                        l.add(n + 1, e);
                    } else {
                        l.addFirst(e);
                    }
                } else {
                    this.insertNew(e);
                }
            } else {
                this.insert(e);
            }
        }

        private void insertNew(Node e) {
            LinkedList<Node> l = new LinkedList<Node>();
            l.addFirst(e);
            this.map.put(e.getKey(), l);
        }

        public void addAsFirst(Node e) {
            LinkedList l = (LinkedList)this.map.get(e.getKey());
            if (l != null) {
                l.addFirst(e);
            } else {
                this.insertNew(e);
            }
        }

        public void addAsLast(Node e) {
            LinkedList<Node> l = (LinkedList<Node>)this.map.get(e.getKey());
            if (l != null) {
                l.addLast(e);
            } else {
                l = new LinkedList<Node>();
                l.addLast(e);
                this.map.put(e.getKey(), l);
            }
        }

        public void updateKey(Node e, String oldKey) {
            if (!e.keyMatch(oldKey)) {
                this.delete(e, oldKey);
                this.insert(e);
            }
        }

        private void insert(Node e) {
            LinkedList l = (LinkedList)this.map.get(e.getKey());
            if (l != null) {
                if (l.size() > 0) {
                    boolean found = false;
                    for (Node k = e.getPrev(); k != null; k = k.getPrev()) {
                        if (!k.keyMatch(e)) continue;
                        int idx = l.indexOf(k);
                        if (idx <= -1) break;
                        l.add(idx + 1, e);
                        found = true;
                        break;
                    }
                    if (!found) {
                        l.addFirst(e);
                    }
                } else {
                    l.addFirst(e);
                }
            } else {
                this.insertNew(e);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName());
            sb.append(": ");
            Iterator i = this.map.values().iterator();
            while (i.hasNext()) {
                sb.append("[");
                LinkedList l = (LinkedList)i.next();
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    sb.append("<");
                    sb.append(i2.next());
                    sb.append("<");
                }
                sb.append("] ");
            }
            return sb.toString();
        }
    }

    class ValueRef {
        ValueData _node;

        ValueRef(ValueData node) {
            this._node = node;
            this._node.incrUsage();
        }

        ValueData getNode() {
            return this._node;
        }
    }

    class Txn
    implements ITransaction {
        int txnID;
        boolean aborted;
        Vector tc;
        Vector _dirty = new Vector();
        Vector _inserts = new Vector();
        Vector _updates = new Vector();
        Vector _deletes = new Vector();
        Vector _deleteRefs = new Vector();
        Hashtable _ownedEntries = new Hashtable();
        Node _waitForNode;
        StopWatch _stopWatch = new StopWatch();
        StopWatch _waitWatch = new StopWatch();
        boolean _killed = false;
        boolean _started = false;
        boolean _criticalSection = false;
        private Thread _owningThread = null;

        Txn() {
            this.txnID = TxnData.this.getTxnId();
            this.aborted = false;
            this.tc = new Vector(3);
            this._waitForNode = null;
            this._started = true;
            this._owningThread = Thread.currentThread();
        }

        void dumpOwnedNodes() {
            String k = null;
            String rk = null;
            Enumeration enumvar = this._ownedEntries.elements();
            while (enumvar.hasMoreElements()) {
                Node n = (Node)enumvar.nextElement();
                if (n instanceof Root) {
                    rk = ((Root)n).getRootKey();
                }
                if (n instanceof Element) {
                    rk = ((Element)n).getRoot().getRootKey();
                    k = ((Element)n).getKey();
                }
                TxnData.this.log("     owned node: key=" + rk + ":" + k);
            }
        }

        int getOwnedNodesSize() {
            return this._ownedEntries.size();
        }

        public synchronized String toString() {
            return "txn{id=" + this.txnID + (this.aborted ? " aborted" : " ok") + " started=" + this._started + " lifetime=" + this._stopWatch.getDuration() + " deadlock=" + this._killed + "}";
        }

        synchronized void addToDirty(Node node) throws TransactionException {
            if ((node._state & 1) != 0 && !this._deleteRefs.contains(node)) {
                this._deleteRefs.addElement(node);
            }
            if ((node._state & 0xC0) != 0) {
                if (!this._inserts.contains(node)) {
                    this._inserts.addElement(node);
                }
                return;
            }
            if ((node._state & 0x100) != 0 && (node._state & 1) == 0) {
                if (!this._deletes.contains(node)) {
                    this._deletes.addElement(node);
                }
                return;
            }
            if ((node._state & 0x200) != 0) {
                if (!this._updates.contains(node)) {
                    this._updates.addElement(node);
                }
                return;
            }
            if ((node._state & 0x400) != 0) {
                if (!this._updates.contains(node)) {
                    this._updates.addElement(node);
                }
                return;
            }
            if ((node._state & 1) != 0) {
                return;
            }
            throw new TransactionException("BAC.0001.0038", TxnData.COREBUNDLE, new String[]{"" + node.getStatusDisplay(), node.getKey()}, "RuntimeException: internal error - unexpected dirty node; status={2}, key={3}");
        }

        public boolean commitTXN() throws TransactionException {
            return this.commitTXN(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean commitTXN(boolean freshkill) throws TransactionException {
            ITransaction txn = null;
            Node node = null;
            Root root = null;
            IDataSharedCursor storeCursor = null;
            IData storeIData = null;
            Enumeration dirtyNodes = null;
            if (this._killed && !freshkill) {
                throw new TransactionException("BAC.0004.0008", TxnData.COREBUNDLE);
            }
            if (!this._started) {
                throw new TransactionException("BAC.0001.0039", TxnData.COREBUNDLE);
            }
            Object object = TxnData.this._commitLock;
            synchronized (object) {
                block62: {
                    try {
                        try {
                            this._criticalSection = true;
                            this.mergeDirty();
                            dirtyNodes = this._dirty.elements();
                            while (dirtyNodes.hasMoreElements()) {
                                node = (Node)dirtyNodes.nextElement();
                                if (!this.aborted) {
                                    if (txn == null) {
                                        if (root == null) {
                                            root = node.getRoot();
                                        }
                                        TData parent = root._parent;
                                        while (storeIData == null && ((storeIData = parent._backingStore) != null || (parent = parent._parent) != null)) {
                                        }
                                        if (storeIData == null) {
                                            if (TxnData.this.DebugOn(128)) {
                                                TxnData.this.log("commitTXN: root key=" + root._parent._key + ", usage=" + root._parent.getUsage() + ", store=" + storeIData);
                                            }
                                            if (root._parent.isNotDeleted() && root._parent._td._storeType == 1) {
                                                throw new TransactionException("BAC.0001.0042", TxnData.COREBUNDLE);
                                            }
                                        } else {
                                            storeCursor = storeIData.getSharedCursor();
                                            if (storeCursor.isTXNSupported()) {
                                                txn = storeCursor.startTXN();
                                            }
                                            storeCursor.destroy();
                                            storeCursor = null;
                                            storeIData = null;
                                        }
                                    }
                                    if (TxnData.this.DebugOn(64) && node instanceof Root) {
                                        Object x = null;
                                        String k = "<NULL>";
                                        IDataSharedCursor c = node._savedCursor;
                                        try {
                                            x = c.getValue();
                                        }
                                        catch (Exception e) {
                                            x = e;
                                        }
                                        String y = x == null ? "NULL VALUE" : x.getClass().getName();
                                        try {
                                            k = c.getKey();
                                        }
                                        catch (Exception e) {
                                            k = "<BAD CURSOR>";
                                        }
                                        TxnData.this.log("commitTXN: before commit fsdata key=" + k + ", value=" + y);
                                        if (node instanceof Element) {
                                            x = ((Element)node).getValueForCommit(true);
                                            y = x == null ? "NULL VALUE" : x.getClass().getName();
                                            TxnData.this.log("commitTXN: before commit [" + node.getStatusDisplay() + "] txdata root=" + node.getRoot().getRootKey() + " key=" + node.getKey() + ", value=" + y);
                                        } else {
                                            TxnData.this.log("commitTXN: before commit [ROOT" + node.getStatusDisplay() + "] txdata root=" + node.getRoot().getRootKey() + " key=" + node.getKey() + ", value=" + y);
                                        }
                                    }
                                    if (node.getRoot()._parent._stale) continue;
                                    if (node.getRoot()._parent._td._storeType == 1 && node.nodeIsPersisted()) {
                                        node.backingCommit(this, txn);
                                        continue;
                                    }
                                    node.nobackingCommit(this);
                                    continue;
                                }
                                node.rollback(this);
                            }
                            if (txn != null) {
                                txn.commitTXN();
                                if (TxnData.this.DebugOn(64)) {
                                    int dsize = this._dirty.size();
                                    for (int j = 0; j < dsize; ++j) {
                                        Object x = null;
                                        String k = "<NULL>";
                                        node = (Node)this._dirty.elementAt(j);
                                        IDataSharedCursor c = node._savedCursor;
                                        try {
                                            x = c.getValue();
                                        }
                                        catch (Exception e) {
                                            x = e;
                                        }
                                        String y = x == null ? "NULL VALUE" : x.getClass().getName();
                                        try {
                                            k = c.getKey();
                                        }
                                        catch (Exception e) {
                                            k = "<BAD CURSOR>";
                                        }
                                        TxnData.this.log("commitTXN: after commit fsdata key=" + k + ", value=" + y);
                                        if (node instanceof Element) {
                                            x = ((Element)node).getValueForCommit(true);
                                            y = x == null ? "NULL VALUE" : x.getClass().getName();
                                            TxnData.this.log("commitTXN: after commit txdata root=" + node.getRoot().getRootKey() + " key=" + node.getKey() + ", value=" + y);
                                            continue;
                                        }
                                        TxnData.this.log("commitTXN: ROOT after commit txdata root=" + node.getRoot().getRootKey() + " key=" + node.getKey() + ", value=" + y);
                                    }
                                }
                                txn = null;
                            }
                            if (!this.aborted) {
                                dirtyNodes = this._dirty.elements();
                                while (dirtyNodes.hasMoreElements()) {
                                    node = (Node)dirtyNodes.nextElement();
                                    node.commit(this);
                                }
                            }
                            this.processCursors(this.aborted);
                        }
                        catch (Throwable e) {
                            int i;
                            String func = "commitTXN()";
                            if (this.aborted) {
                                func = "abortTXN()";
                            }
                            if (TxnData.this.DebugOn(128)) {
                                TxnData.this.log("Exception: key=" + root.getRootKey() + " storeIData=" + storeIData);
                            }
                            for (i = 0; i < this._dirty.size(); ++i) {
                                try {
                                    node = (Node)this._dirty.elementAt(i);
                                    node.rollback(this);
                                    continue;
                                }
                                catch (Throwable ee) {
                                    // empty catch block
                                }
                            }
                            this._dirty.removeAllElements();
                            for (i = 0; i < this._inserts.size(); ++i) {
                                try {
                                    node = (Node)this._inserts.elementAt(i);
                                    node.rollback(this);
                                    continue;
                                }
                                catch (Throwable ee) {
                                    // empty catch block
                                }
                            }
                            this._inserts.removeAllElements();
                            for (i = 0; i < this._updates.size(); ++i) {
                                try {
                                    node = (Node)this._updates.elementAt(i);
                                    node.rollback(this);
                                    continue;
                                }
                                catch (Throwable ee) {
                                    // empty catch block
                                }
                            }
                            this._updates.removeAllElements();
                            for (i = 0; i < this._deletes.size(); ++i) {
                                try {
                                    node = (Node)this._deletes.elementAt(i);
                                    node.rollback(this);
                                    continue;
                                }
                                catch (Throwable ee) {
                                    // empty catch block
                                }
                            }
                            this._deletes.removeAllElements();
                            for (i = 0; i < this._deleteRefs.size(); ++i) {
                                try {
                                    node = (Node)this._deleteRefs.elementAt(i);
                                    node.rollback(this);
                                    continue;
                                }
                                catch (Throwable ee) {
                                    // empty catch block
                                }
                            }
                            this._deleteRefs.removeAllElements();
                            if (txn != null) {
                                try {
                                    txn.abortTXN();
                                }
                                catch (Throwable ee) {
                                    // empty catch block
                                }
                                txn = null;
                            }
                            try {
                                this.processCursors(true);
                                throw new TransactionException(e);
                            }
                            catch (Exception ee) {
                                // empty catch block
                            }
                            throw new TransactionException(e);
                        }
                        Object var17_34 = null;
                        if (txn == null) break block62;
                    }
                    catch (Throwable throwable) {
                        Object var17_35 = null;
                        if (txn != null) {
                            try {
                                txn.abortTXN();
                            }
                            catch (Throwable ee) {
                                this._criticalSection = false;
                                throw new TransactionException(ee);
                            }
                            txn = null;
                        }
                        this._waitForNode = null;
                        this._stopWatch.reset();
                        this._waitWatch.reset();
                        this._dirty.clear();
                        this._started = false;
                        TxnData.this.removeActiveTrans(this);
                        this._owningThread = null;
                        this.unlockOwnedEntries();
                        this._criticalSection = false;
                        throw throwable;
                    }
                    try {}
                    catch (Throwable ee) {
                        this._criticalSection = false;
                        throw new TransactionException(ee);
                    }
                    txn.abortTXN();
                    txn = null;
                }
                this._waitForNode = null;
                this._stopWatch.reset();
                this._waitWatch.reset();
                this._dirty.clear();
                this._started = false;
                TxnData.this.removeActiveTrans(this);
                this._owningThread = null;
                this.unlockOwnedEntries();
                this._criticalSection = false;
            }
            if (this.aborted) return false;
            return true;
        }

        void unlockOwnedEntries() {
            Enumeration enumvar = this._ownedEntries.elements();
            while (enumvar.hasMoreElements()) {
                Root r = (Root)enumvar.nextElement();
                r.luwUnlock(this);
                r._txnLock.semPost();
            }
            this._ownedEntries.clear();
        }

        void processCursors(boolean aborted) throws TransactionException, DataException {
            int sz = this.tc.size();
            for (int i = 0; i < sz; ++i) {
                ITransactionResource r = (ITransactionResource)this.tc.elementAt(i);
                if (r instanceof Cursor && !((Cursor)r).isDestroyed()) {
                    ((Cursor)r).home();
                }
                if (!aborted) {
                    r.txnCommitted();
                    continue;
                }
                r.txnAborted();
            }
            this.tc.removeAllElements();
        }

        private void mergeDirty() {
            int i;
            this._dirty.removeAllElements();
            for (i = 0; i < this._inserts.size(); ++i) {
                this._dirty.addElement(this._inserts.elementAt(i));
            }
            this._inserts.removeAllElements();
            for (i = 0; i < this._updates.size(); ++i) {
                this._dirty.addElement(this._updates.elementAt(i));
            }
            this._updates.removeAllElements();
            for (i = 0; i < this._deletes.size(); ++i) {
                this._dirty.addElement(this._deletes.elementAt(i));
            }
            this._deletes.removeAllElements();
            for (i = 0; i < this._deleteRefs.size(); ++i) {
                this._dirty.addElement(this._deleteRefs.elementAt(i));
            }
            this._deleteRefs.removeAllElements();
        }

        private boolean compareString(String k1, String k2) {
            boolean rc = false;
            if (k1 != null && k2 != null && k1.equals(k2)) {
                rc = true;
            }
            if (k1 == null && k2 == null) {
                rc = true;
            }
            return rc;
        }

        public void abortTXN() throws TransactionException {
            this.abortTXN(false);
        }

        public void abortTXN(boolean freshkill) throws TransactionException {
            if (this._killed && !freshkill) {
                throw new TransactionException("BAC.0004.0008", TxnData.COREBUNDLE);
            }
            if (!this._started) {
                return;
            }
            this.aborted = true;
            this.commitTXN(freshkill);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void joinTXN(ITransactionResource cur) throws TransactionException {
            if (!this._started) {
                throw new TransactionException("BAC.0003.0028");
            }
            Txn txn = this;
            synchronized (txn) {
                this.tc.addElement(cur);
                cur.txnJoin(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addOwnedEntry(Node node) {
            Txn txn = this;
            synchronized (txn) {
                if (this._ownedEntries.get(node) == null) {
                    this._ownedEntries.put(node, node);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeOwnedEntry(Node node) {
            Txn txn = this;
            synchronized (txn) {
                this._ownedEntries.remove(node);
            }
        }

        Node getWaitingForNode() {
            return this._waitForNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setWaitingForNode(Node node) {
            Txn txn = this;
            synchronized (txn) {
                this._waitForNode = node;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDeadlock() {
            Txn txn = this;
            synchronized (txn) {
                this._killed = true;
            }
        }

        long getLUWtime() {
            return this._stopWatch.getDuration();
        }

        long getWaitDuration() {
            return this._waitWatch.getDuration();
        }

        long getLUWWaitTime() {
            return this._waitWatch.getDuration();
        }

        void stopWatch() {
            this._stopWatch.stop();
            this._waitWatch.start();
        }

        void startWatch() {
            this._stopWatch.start();
            this._waitWatch.clear();
        }

        boolean isDead() {
            return this._killed;
        }

        boolean isActive() {
            return this._waitForNode == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean owns(Node node) {
            Txn txn = this;
            synchronized (txn) {
                if (node == null) {
                    return false;
                }
                return this._ownedEntries.get(node) != null;
            }
        }

        protected void finalize() throws IOException {
            Node node = null;
            if (this._started) {
                if (TxnData.this.DebugOn(4096)) {
                    TxnData.this.log("finalize: for txn=" + this.toString());
                }
                try {
                    int i;
                    for (i = 0; i < this._dirty.size(); ++i) {
                        try {
                            node = (Node)this._dirty.elementAt(i);
                            node.rollback(this);
                            continue;
                        }
                        catch (Throwable ee) {
                            // empty catch block
                        }
                    }
                    this._dirty.removeAllElements();
                    for (i = 0; i < this._inserts.size(); ++i) {
                        try {
                            node = (Node)this._inserts.elementAt(i);
                            node.rollback(this);
                            continue;
                        }
                        catch (Throwable ee) {
                            // empty catch block
                        }
                    }
                    this._inserts.removeAllElements();
                    for (i = 0; i < this._updates.size(); ++i) {
                        try {
                            node = (Node)this._updates.elementAt(i);
                            node.rollback(this);
                            continue;
                        }
                        catch (Throwable ee) {
                            // empty catch block
                        }
                    }
                    this._updates.removeAllElements();
                    for (i = 0; i < this._deletes.size(); ++i) {
                        try {
                            node = (Node)this._deletes.elementAt(i);
                            node.rollback(this);
                            continue;
                        }
                        catch (Throwable ee) {
                            // empty catch block
                        }
                    }
                    this._deletes.removeAllElements();
                    for (i = 0; i < this._deleteRefs.size(); ++i) {
                        try {
                            node = (Node)this._deleteRefs.elementAt(i);
                            node.rollback(this);
                            continue;
                        }
                        catch (Throwable ee) {
                            // empty catch block
                        }
                    }
                    this._deleteRefs.removeAllElements();
                    this.processCursors(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Enumeration enumvar = this._ownedEntries.elements();
            while (enumvar.hasMoreElements()) {
                String k = null;
                String rk = null;
                Node n = (Node)enumvar.nextElement();
                if (n instanceof Root) {
                    rk = ((Root)n).getRootKey();
                }
                if (n instanceof Element) {
                    rk = ((Element)n).getRoot().getRootKey();
                    k = ((Element)n).getKey();
                }
                TxnData.this.log("     finalized forced unlock of owned node: key=" + rk + ":" + k);
                n.luwUnlock(this);
                if (!(n instanceof Root)) continue;
                ((Root)n)._txnLock.semPost();
            }
        }
    }

    final class Cursor
    implements ITxnDataCursor,
    IDataSharedCursor,
    ITransactionResource {
        private static final byte ACTIVE = 1;
        private static final byte DESTROYED = 2;
        Node _now;
        Root _root;
        Txn _txn;
        byte _state = 1;
        boolean _stale = false;

        Cursor(Root root, Node now) {
            this.init(root, now);
        }

        void init(Root root, Node now) {
            this._root = root;
            this._setCursor(now);
        }

        void makeStale() {
            this._stale = true;
        }

        void clearTransaction() {
            this._txn = null;
        }

        ITransaction getTransaction() {
            return this._txn;
        }

        void setTransaction(ITransaction txn) {
            this._txn = (Txn)txn;
        }

        public void setErrorMode(int m) {
        }

        public DataException getLastError() {
            return null;
        }

        public boolean hasMoreErrors() {
            return false;
        }

        public void home() throws DataException {
            this._setCursor(null);
        }

        public String getKey() throws DataException {
            String key = null;
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    throw new DataException("BAC.0004.0012");
                }
                this._now.luwLock(this._txn, 1024);
                key = this._now.getKey();
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return key;
        }

        public Object getValue() throws DataException {
            return this.getValue(false, true);
        }

        Object getValue(boolean readonly, boolean unwrap) throws DataException {
            Object o = null;
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    throw new DataException("BAC.0004.0013");
                }
                this._now.luwLock(this._txn, 1024);
                o = ((Element)this._now).getValue(readonly);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this.checkValueRefOut(o, readonly, unwrap);
        }

        public Object getValueReference() throws DataException {
            Object o;
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    throw new DataException("BAC.0004.0014");
                }
                this._now.luwLock(this._txn, 1024);
                o = ((Element)this._now).getValue(true);
                if (!(o instanceof ValueRef)) {
                    o = new ValueRef(((Element)this._now).getCacheRef());
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return o;
        }

        public void setKey(String key) throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (!this._root.isIndexed() && this._root.useIndex()) {
                    this._root.createIndex();
                }
                if (this._now != null) {
                    this._now.luwLock(this._txn, 512);
                    String oldkey = this._now.getKey();
                    this._now.setKey(key);
                    if (this._root.isIndexed()) {
                        this._root.updateKey(this._now, oldkey);
                    }
                } else {
                    throw new DataException("BAC.0004.0015");
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
        }

        public void setValue(Object value) throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    throw new DataException("BAC.0004.0015");
                }
                this._now.luwLock(this._txn, 512);
                this._now.setValue(this.checkValueRefIn(value));
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
        }

        public boolean delete() throws DataException {
            boolean more = false;
            try {
                this.checkCursorState();
                if (this._now == null) {
                    throw new DataException("BAC.0004.0015");
                }
                this._root.luwLock(this._txn, 1024);
                this._now.waitLastCursor();
                Node node = this._now.getPrev();
                if (node != null) {
                    node.luwLock(this._txn, 1024);
                }
                if ((node = this._now.getNext()) != null) {
                    node.luwLock(this._txn, 1024);
                }
                Node tmp = this._now;
                this._setCursor(this._now.getNext());
                more = false;
                while (this._now != null && (this._now._state & 0x101) != 0) {
                    this._setCursor(this._now.getNext());
                }
                if (this._now != null) {
                    more = true;
                } else {
                    this._setCursor(tmp.getPrev());
                    while (this._now != null && (this._now._state & 0x101) != 0) {
                        this._setCursor(this._now.getPrev());
                    }
                }
                Object o = ((Element)tmp).getValueForCommit(true);
                if (o instanceof ValueRef || o instanceof TData || tmp.isPending() && (tmp._state & 0x400) == 0) {
                    tmp._state |= 1;
                    tmp.luwLock(this._txn, 2048);
                } else {
                    tmp.luwLock(this._txn, 256);
                }
                if (o instanceof TData) {
                    this._root.checkTDataDelete((Element)tmp, true);
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return more;
        }

        public void insertBeforeVolatile(String key, Object value) throws DataException {
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getPrev();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                Object o = this.checkValueRefIn(value);
                this._insertBefore(key, o, 64, false);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
        }

        public void insertBefore(String key, Object value) throws DataException {
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getPrev();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                Object o = this.checkValueRefIn(value);
                this._insertBefore(key, o, 64, true);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
        }

        private void _insertBefore(String key, Object value, int status, boolean persist) throws DataException {
            Element node = new Element(this._root, null, null, null, true, persist);
            ((Node)node).setKey(key);
            ((Node)node).setValue(this.checkValueRefIn(value));
            if (this._now != null) {
                this._now.insertBefore(this._root, node);
                this._setCursor(node);
            } else {
                this._setCursor(node);
                this._now.addToFront(this._root);
            }
            this._now.luwLock(this._txn, status);
        }

        public void insertAfterVolatile(String key, Object value) throws DataException {
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getNext();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                Object o = this.checkValueRefIn(value);
                this._insertAfter(key, o, 64, false);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
        }

        public void insertAfter(String key, Object value) throws DataException {
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getNext();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                Object o = this.checkValueRefIn(value);
                this._insertAfter(key, o, 64, true);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
        }

        private void _insertAfter(String key, Object value, int status, boolean persist) throws DataException {
            Element node = new Element(this._root, null, null, null, true, persist);
            ((Node)node).setKey(key);
            ((Node)node).setValue(this.checkValueRefIn(value));
            if (this._now != null) {
                this._now.insertAfter(this._root, node);
                this._setCursor(node);
            } else {
                this._setCursor(node);
                this._now.addToEnd(this._root);
            }
            this._now.luwLock(this._txn, status);
        }

        public IData insertDataBeforeVolatile(String key) throws DataException {
            TData nd = null;
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getPrev();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                nd = new TData(this._root._parent._td, this._root._parent, key);
                this._root._parent._td.addIDataRef(nd);
                this._insertBefore(key, nd, 128, false);
                nd.setElement((Element)this._now);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return nd;
        }

        public IData insertDataBefore(String key) throws DataException {
            TData nd = null;
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getPrev();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                nd = new TData(this._root._parent._td, this._root._parent, key);
                this._root._parent._td.addIDataRef(nd);
                this._insertBefore(key, nd, 128, true);
                nd.setElement((Element)this._now);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return nd;
        }

        public IData insertDataAfterVolatile(String key) throws DataException {
            TData nd = null;
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getNext();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                nd = new TData(this._root._parent._td, this._root._parent, key);
                this._root._parent._td.addIDataRef(nd);
                this._insertAfter(key, nd, 128, false);
                nd.setElement((Element)this._now);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return nd;
        }

        public IData insertDataAfter(String key) throws DataException {
            TData nd = null;
            try {
                this.checkCursorState();
                this.checkKey(key);
                this._root.luwLock(this._txn, 1024);
                if (this._now != null) {
                    Node node = this._now.getNext();
                    if (node != null) {
                        node.luwLock(this._txn, 1024);
                    }
                    this._now.luwLock(this._txn, 1024);
                }
                nd = new TData(this._root._parent._td, this._root._parent, key);
                this._root._parent._td.addIDataRef(nd);
                this._insertAfter(key, nd, 128, true);
                nd.setElement((Element)this._now);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return nd;
        }

        public boolean next() throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    this._setCursor(this._root.getFirst());
                } else {
                    this._setCursor(this._now.getNext());
                    if (this._now == null) {
                        this.checkTransactionState(true);
                        return false;
                    }
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    this._setCursor(this._now.getNext());
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        public boolean next(String key) throws DataException {
            Object tmp = null;
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    if (!this._next(this._root.getFirst(), key)) {
                        this.checkTransactionState(true);
                        return false;
                    }
                } else if (!this._next(this._now.getNext(), key)) {
                    this.checkTransactionState(true);
                    return false;
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    if (this._next(this._now.getNext(), key)) continue;
                    this.checkTransactionState(true);
                    return false;
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        private boolean _next(Node walk, String key) throws DataException {
            if (this._root._index == null && this._root.useIndex()) {
                this._root.createIndex();
            }
            if (this._root._index != null && walk != null && walk.keyMatch(walk.getKey(), key)) {
                Node n = this._root._index.seek(walk, true);
                if (n != null) {
                    this._setCursor(n);
                    return true;
                }
                return false;
            }
            while (walk != null) {
                String s = walk.getKey();
                if ((key == null || s == null) && key != s) {
                    return false;
                }
                if ((s == key || s.equals(key)) && walk.canAccess(this._root, this._txn)) {
                    this._setCursor(walk);
                    return true;
                }
                walk = walk.getNext();
            }
            return false;
        }

        public boolean previous() throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    this._setCursor(this._root.getLast());
                } else {
                    this._setCursor(this._now.getPrev());
                    if (this._now == null) {
                        this.checkTransactionState(true);
                        return false;
                    }
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    this._setCursor(this._now.getPrev());
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        public boolean previous(String key) throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    if (!this._previous(this._root.getLast(), key)) {
                        this.checkTransactionState(true);
                        return false;
                    }
                } else if (!this._previous(this._now.getPrev(), key)) {
                    this.checkTransactionState(true);
                    return false;
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    if (this._previous(this._now.getPrev(), key)) continue;
                    this.checkTransactionState(true);
                    return false;
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        private boolean _previous(Node walk, String key) throws DataException {
            if (!this._root.isIndexed() && this._root.useIndex()) {
                this._root.createIndex();
            }
            if (this._root.isIndexed() && walk != null && walk.keyMatch(walk.getKey(), key)) {
                Node n = this._root.getIndex().seek(walk, false);
                if (n != null) {
                    this._setCursor(n);
                    return true;
                }
                return false;
            }
            while (walk != null) {
                if ((key == null || walk.getKey() == null) && key != walk.getKey()) {
                    return false;
                }
                if (walk.getKey() == key || walk.getKey().equals(key) && walk.canAccess(this._root, this._txn)) {
                    this._setCursor(walk);
                    return true;
                }
                walk = walk.getPrev();
            }
            return false;
        }

        public boolean first() throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                this._setCursor(this._root.getFirst());
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    this._setCursor(this._now.getNext());
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        public boolean first(String key) throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (!this._root.isIndexed() && this._root.useIndex()) {
                    this._root.createIndex();
                }
                if (this._root.isIndexed()) {
                    Node el = this._root.indexFirst(key);
                    if (el != null) {
                        this._setCursor(el);
                        return true;
                    }
                    return false;
                }
                if (!this._next(this._root.getFirst(), key)) {
                    this.checkTransactionState(true);
                    return false;
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    if (this._next(this._root.getFirst(), key)) continue;
                    this.checkTransactionState(true);
                    return false;
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        public boolean last() throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                this._setCursor(this._root.getLast());
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    this._setCursor(this._now.getPrev());
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        public boolean last(String key) throws DataException {
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (!this._root.isIndexed() && this._root.useIndex()) {
                    this._root.createIndex();
                }
                if (this._root.isIndexed()) {
                    Node el = this._root.indexLast(key);
                    if (el != null) {
                        this._setCursor(el);
                        return true;
                    }
                    return false;
                }
                if (!this._previous(this._root.getLast(), key)) {
                    this.checkTransactionState(true);
                    return false;
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    if (this._previous(this._root.getLast(), key)) continue;
                    this.checkTransactionState(true);
                    return false;
                }
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return this._now != null;
        }

        public void destroy() {
            if (this._state != 2) {
                this._setCursor(null);
                this._state = (byte)2;
                this._root._parent.removeCursor(this);
            }
        }

        public boolean hasMoreData() throws DataException {
            boolean rc = false;
            Node save = null;
            try {
                this.checkCursorState();
                this._root.luwLock(this._txn, 1024);
                if (this._now == null) {
                    this._setCursor(this._root.getFirst());
                } else {
                    save = this._now;
                    this._setCursor(this._now.getNext());
                }
                while (this._now != null && !this._now.canAccess(this._root, this._txn)) {
                    this._setCursor(this._now.getNext());
                }
                rc = this._now != null;
                this._setCursor(save);
                this.checkTransactionState(true);
            }
            catch (DataException e) {
                this.checkTransactionState(false);
                throw e;
            }
            catch (Exception e) {
                this.checkTransactionState(false);
                throw new DataException(e);
            }
            return rc;
        }

        public IDataSharedCursor getCursorClone() {
            if (this.isDestroyed()) {
                return null;
            }
            Cursor cur = new Cursor(this._root, this._now);
            try {
                if (this._txn != null) {
                    this._txn.joinTXN(cur);
                }
            }
            catch (TransactionException e) {
                throw new BasisRuntimeException(e);
            }
            return cur;
        }

        public String toString() {
            if (this._now == null) {
                return "Cursor:" + this.hashCode() + ":" + "null ";
            }
            return "Cursor:" + this.hashCode() + ":" + this._now.getKey() + " ";
        }

        void checkKey(String key) throws DataException {
            if (key == null || key != null && key.length() == 0) {
                throw new DataException("BAC.0001.0060");
            }
        }

        void checkCursorState() throws DataException {
            if (this.isDestroyed()) {
                if (TxnData.this.DebugOn(1)) {
                    TxnData.this.log("checkCursorState: cursor has been destroyed");
                }
                throw new DataException("BAC.0004.0016");
            }
            if (this._now != null && (this._now._state & 2) != 0) {
                if (TxnData.this.DebugOn(1)) {
                    TxnData.this.log("checkCursorState: internal error, destroyed node not unlinked");
                }
                throw new DataException("BAC.0004.0017");
            }
            if (this.isStale()) {
                throw new DataException("BAC.0004.0021");
            }
            if (this._txn == null) {
                throw new DataNoActiveTxnException("BAC.0004.0018");
            }
        }

        void checkTransactionState(boolean commit) throws DataException {
        }

        boolean isDestroyed() {
            return this._state == 2;
        }

        boolean isStale() {
            return this._stale;
        }

        public void txnJoin(ITransaction t) throws TransactionException {
            if (this.isDestroyed()) {
                if (TxnData.this.DebugOn(8)) {
                    TxnData.this.log("txnJoin: exception; cursor has been destroyed");
                }
                throw new TransactionException("BAC.0003.0026");
            }
            if (this._txn != null) {
                if (TxnData.this.DebugOn(8)) {
                    TxnData.this.log("txnJoin: exception; already in a transaction");
                }
                throw new TransactionException("BAC.0003.0027");
            }
            this._txn = (Txn)t;
        }

        public void txnAborted() throws TransactionException {
            this.txnCommitted();
        }

        public void txnCommitted() throws TransactionException {
            this._txn = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITransaction startTXN() throws TransactionException {
            Txn txn = null;
            Cursor cursor = this;
            synchronized (cursor) {
                if (this.isDestroyed()) {
                    throw new TransactionException("BAC.0003.0026");
                }
                txn = new Txn();
                txn.joinTXN(this);
            }
            TxnData.this.addActiveTrans(txn);
            return txn;
        }

        public boolean isTXNSupported() {
            return true;
        }

        private Object checkValueRefIn(Object obj) throws DataException {
            if (obj instanceof TData) {
                TData d = (TData)obj;
                TData p = d._parent;
                if (p == null) {
                    throw new DataException("BAC.0004.0019");
                }
            } else if (obj instanceof ValueRef) {
                Element e;
                ValueData vd = ((ValueRef)obj).getNode();
                if (vd != null && (e = vd._parent._ele) != null && (e._state & 0x101) != 0) {
                    throw new DataException("BAC.0004.0020");
                }
            } else if (this.isMutable(obj) && !(obj instanceof CoderWrapper)) {
                obj = new CoderWrapper(this.encode(obj));
            }
            return obj;
        }

        private Object checkValueRefOut(Object obj, boolean readonly, boolean unwrap) throws DataException {
            Object o = obj;
            if (obj instanceof ValueRef) {
                o = ((ValueRef)o).getNode().getValue(readonly);
            } else if (obj instanceof CoderWrapper && unwrap) {
                o = this.decode(((CoderWrapper)obj).getObject());
            }
            return o;
        }

        private Object encode(Object obj) throws DataException {
            byte[] b = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new BinaryCodec().encode(obj, baos, new SimpleReferenceManager());
                b = baos.toByteArray();
                baos.close();
            }
            catch (Exception e) {
                throw new DataException(e);
            }
            return b;
        }

        private Object decode(Object obj) throws DataException {
            Object o = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])obj);
                o = new BinaryCodec().decode(bais, new SimpleReferenceManager());
                bais.close();
            }
            catch (Exception e) {
                throw new DataException(e);
            }
            return o;
        }

        private boolean isMutable(Object obj) {
            return obj != null && !(obj instanceof Number) && !(obj instanceof String) && !(obj instanceof TxnData) && !(obj instanceof TData) && !(obj instanceof ValueRef);
        }

        private void _setCursor(Node node) {
            if (node == this._now) {
                return;
            }
            if (node != null) {
                node.startCursor();
            }
            if (this._now != null) {
                this._now.endCursor();
            }
            this._now = node;
        }
    }

    class Element
    extends Node {
        KVNode _kvnode;

        Element(Root root, String key, Object object, IDataSharedCursor cursor, boolean cacheValue, boolean persist) throws DataException {
            this._savedCursor = cursor;
            root._parent.checkIDataState();
            if (root._parent._td._storeType == 1 && persist) {
                this._kvnode = new KVNode(key, object, root, this, cacheValue);
                this._kvnode._flags = (short)(this._kvnode._flags | 0x100);
            } else {
                this._kvnode = new KVNode(key, object, root);
            }
            if (object instanceof TData) {
                ((TData)object).setElement(this);
            }
        }

        boolean nodeIsPersisted() {
            return (this._kvnode._flags & 0x100) != 0;
        }

        void luwLock(ITransaction txn, int status) throws DataException {
            if (((Txn)txn).isDead()) {
                throw new DataDeadlockException("BAC.0004.0008");
            }
            if (this._txn != null && this._txn != txn) {
                throw new DataDeadlockException("BAC.0004.0008");
            }
            ((Txn)txn).setWaitingForNode(null);
            this.setStatus(status);
            try {
                ((Txn)txn).addToDirty(this);
            }
            catch (TransactionException e) {
                throw new DataException(e);
            }
            this._txn = txn;
            if (TxnData.this.DebugOn(2)) {
                String k = null;
                k = this.getKey();
                TxnData.this.log("luwLock: key=" + k + "(" + this.hashCode() + ") lock granted to transaction " + this._txn);
            }
        }

        boolean isIndexed() {
            return false;
        }

        boolean useIndex() {
            return false;
        }

        String getKey() {
            return this._kvnode.getKey();
        }

        String getRootKey() {
            return this._kvnode._root.getRootKey();
        }

        Root getRoot() {
            return this._kvnode._root;
        }

        Object getValue(boolean readonly) throws DataException {
            return this._kvnode.getValue(readonly);
        }

        Object getValueForCommit(boolean readonly) throws DataException {
            return this._kvnode.getValueForCommit(readonly);
        }

        Object getValueReference() throws DataException {
            return this._kvnode.getValueReference();
        }

        ValueData getCacheRef() {
            return this._kvnode.getCacheRef();
        }

        void setKey(String key) {
            this._kvnode.setKey(key);
        }

        void setValue(Object value) throws DataException {
            this._kvnode.setValue(value);
        }

        void commit() throws DataException {
            super.commit();
            this._kvnode.commit();
        }

        void commit(ITransaction txn) throws DataException {
            if (this.getTransaction() != txn) {
                return;
            }
            if ((this._state & 0x111) != 0 || !this.isPending()) {
                this.luwUnlock(txn);
                this.delete(this.getRoot());
                this.destroy();
            } else if ((this._state & 1) == 0) {
                this.commit();
                this.luwUnlock(txn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void backingCommit(ITransaction txn, ITransaction backingTxn) throws TransactionException {
            block85: {
                IDataSharedCursor cursor = this._savedCursor;
                boolean lastdelref = false;
                Object o = null;
                ValueData vd = null;
                ValueData b4image = null;
                IDataSharedCursor saveCursor = null;
                IDataSharedCursor holdCursor = null;
                IDataSharedCursor refcursor = null;
                try {
                    if (TxnData.this.DebugOn(128)) {
                        TxnData.this.log("Entry: single node commit key " + this.getKey());
                    }
                    if (this.getTransaction() != txn) {
                        if (TxnData.this.DebugOn(128)) {
                            TxnData.this.log("Skipping Node : key=" + this.getKey());
                        }
                        return;
                    }
                    if ((this._state & 1) != 0 && (this.processed() || !this.isPending())) {
                        if ((this._state & 0x12) == 0) {
                            vd = this.getCacheRef();
                            saveCursor = this._savedCursor;
                            if (saveCursor.isTXNSupported()) {
                                backingTxn.joinTXN(saveCursor);
                            }
                            if ((o = vd.getValue(true)) instanceof TData && !((TData)o)._stale) {
                                ((TData)o).getRoot().checkTDataDelete(this, false);
                                if (TxnData.this.DebugOn(128)) {
                                    TxnData.this.log("CheckTData : key=" + this.getKey() + ", usage=" + ((TData)o).getUsage() + ", hash=" + o.hashCode());
                                }
                            }
                            saveCursor.delete();
                            saveCursor.destroy();
                            saveCursor = null;
                            this._state |= 0x10;
                            if (TxnData.this.DebugOn(128)) {
                                TxnData.this.log("DELETEREF : key=" + this.getKey());
                            }
                        }
                        return;
                    }
                    if ((this._state & 0x80) != 0) {
                        int lastops;
                        String insdata = null;
                        IData data = null;
                        try {
                            saveCursor = this.findPrevCursor(this);
                            if (saveCursor == null) {
                                lastops = 2;
                                saveCursor = this.getRoot()._savedCursor.getCursorClone();
                                saveCursor.home();
                            } else {
                                lastops = 1;
                            }
                            holdCursor = saveCursor.getCursorClone();
                            if (saveCursor.isTXNSupported()) {
                                backingTxn.joinTXN(saveCursor);
                            }
                            if (lastops == 1) {
                                data = saveCursor.insertDataAfter(this.getKey());
                                insdata = "after";
                            } else {
                                data = saveCursor.insertDataBefore(this.getKey());
                                insdata = "before";
                            }
                            holdCursor.next();
                            this.saveCursor(holdCursor);
                            saveCursor.destroy();
                            saveCursor = null;
                            o = this.getValueForCommit(true);
                            ((TData)o)._backingStore = data;
                            ((TData)o).getRoot().saveCursor(data.getSharedCursor());
                            this.getRoot()._parent._td.addIDataRef((TData)o);
                            this._state |= 4;
                        }
                        finally {
                            if (saveCursor != null) {
                                saveCursor.destroy();
                                saveCursor = null;
                            }
                            if (holdCursor != null && holdCursor != this._savedCursor) {
                                holdCursor.destroy();
                                holdCursor = null;
                            }
                        }
                        if (TxnData.this.DebugOn(128)) {
                            TxnData.this.log("INSERTDATA " + insdata + " PASS 1: lastops=" + lastops + ", key=" + this.getKey() + ", storeref=" + data);
                        }
                        break block85;
                    }
                    if ((this._state & 0x40) != 0) {
                        int lastops;
                        o = this.getValueForCommit(true);
                        String ins = null;
                        try {
                            saveCursor = this.findPrevCursor(this);
                            if (saveCursor == null) {
                                lastops = 2;
                                saveCursor = this.getRoot()._savedCursor.getCursorClone();
                                saveCursor.home();
                            } else {
                                lastops = 1;
                            }
                            holdCursor = saveCursor.getCursorClone();
                            if (saveCursor.isTXNSupported()) {
                                backingTxn.joinTXN(saveCursor);
                            }
                            if (o instanceof ValueRef) {
                                Object obj = ((ValueRef)o).getNode()._value;
                                if (lastops == 1) {
                                    saveCursor.insertAfter(this.getKey(), obj);
                                    ins = "after";
                                } else {
                                    saveCursor.insertBefore(this.getKey(), obj);
                                    ins = "before";
                                }
                                holdCursor.next();
                                this.saveCursor(holdCursor);
                                saveCursor.destroy();
                                saveCursor = null;
                                this._state |= 4;
                                if (TxnData.this.DebugOn(128)) {
                                    TxnData.this.log("INSERT " + ins + " PASS 1: lastops=" + lastops + ", key=" + this.getKey() + ", valueref=" + o);
                                }
                            } else if (o instanceof TData) {
                                TData savetd = (TData)o;
                                if (!savetd._stale) {
                                    o = ((TData)o)._backingStore;
                                    if (lastops == 1) {
                                        saveCursor.insertAfter(this.getKey(), o);
                                        ins = "after";
                                    } else {
                                        saveCursor.insertBefore(this.getKey(), o);
                                        ins = "before";
                                    }
                                    this.getRoot()._parent._td.addIDataRef(savetd);
                                    this._state |= 4;
                                    holdCursor.next();
                                    this.saveCursor(holdCursor);
                                    saveCursor.destroy();
                                    saveCursor = null;
                                    if (TxnData.this.DebugOn(128)) {
                                        TxnData.this.log("INSERT " + ins + " PASS 1: lastops=" + lastops + ", key=" + this.getKey() + ", IData value=" + o);
                                    }
                                }
                            } else {
                                if (lastops == 1) {
                                    saveCursor.insertAfter(this.getKey(), o);
                                    ins = "after";
                                } else {
                                    saveCursor.insertBefore(this.getKey(), o);
                                    ins = "before";
                                }
                                this._state |= 4;
                                holdCursor.next();
                                this.saveCursor(holdCursor);
                                saveCursor.destroy();
                                saveCursor = null;
                            }
                        }
                        finally {
                            if (saveCursor != null) {
                                saveCursor.destroy();
                                saveCursor = null;
                            }
                            if (holdCursor != null && holdCursor != this._savedCursor) {
                                holdCursor.destroy();
                                holdCursor = null;
                            }
                        }
                        if (TxnData.this.DebugOn(128)) {
                            TxnData.this.log("INSERT " + ins + " PASS 1: lastops=" + lastops + ", key=" + this.getKey() + ", value=" + o);
                        }
                        break block85;
                    }
                    if ((this._state & 0x200) != 0) {
                        try {
                            if ((this._state & 8) == 0) {
                                vd = this.getCacheRef();
                                b4image = this._kvnode._value;
                                saveCursor = this._savedCursor.getCursorClone();
                                if (saveCursor.isTXNSupported()) {
                                    backingTxn.joinTXN(saveCursor);
                                }
                                if (b4image != null && b4image != vd && (o = b4image.getValue(true)) instanceof TData && !((TData)o)._stale) {
                                    ((TData)o).decrUsage();
                                    ((TData)o).removeElement(this);
                                }
                                if ((o = vd.getValue(true)) instanceof ValueRef) {
                                    if ((this._kvnode._flags & 0x40) != 0) {
                                        ValueData refnode = ((ValueRef)o).getNode();
                                        if ((refnode._parent._flags & 0x40) != 0) {
                                            refcursor = refnode._parent._ele._savedCursor.getCursorClone();
                                            if (refcursor.isTXNSupported()) {
                                                backingTxn.joinTXN(refcursor);
                                            }
                                            if (refcursor != null) {
                                                o = refcursor.getValueReference();
                                                refcursor.destroy();
                                                refcursor = null;
                                            }
                                        } else {
                                            o = refnode._value;
                                        }
                                        saveCursor.setValue(o);
                                        this._state |= 8;
                                        if (TxnData.this.DebugOn(128)) {
                                            TxnData.this.log("SETVALUE PASS 2: key=" + this.getKey() + ", value=" + o);
                                        }
                                    }
                                } else if (o instanceof TData) {
                                    TData savetd = (TData)o;
                                    if (!savetd._stale && (this._kvnode._flags & 0x40) != 0) {
                                        o = ((TData)o)._backingStore;
                                        if (TxnData.this.DebugOn(128)) {
                                            TxnData.this.log("SETVALUE : key=" + this.getKey() + ", value" + o);
                                        }
                                        this._kvnode._root._parent._td.addIDataRef(savetd);
                                        saveCursor.setValue(o);
                                        this._state |= 8;
                                    }
                                }
                                if ((this._state & 8) == 0) {
                                    if ((this._kvnode._flags & 0x20) != 0) {
                                        if (TxnData.this.DebugOn(128)) {
                                            TxnData.this.log("SETKEY : key=" + this.getKey());
                                        }
                                        saveCursor.setKey(this.getKey());
                                        this._state |= 8;
                                    }
                                    if ((this._kvnode._flags & 0x40) != 0) {
                                        if (TxnData.this.DebugOn(128)) {
                                            TxnData.this.log("SETVALUE : key=" + this.getKey() + ", value" + o);
                                        }
                                        saveCursor.setValue(o);
                                        this._state |= 8;
                                    }
                                }
                                saveCursor.destroy();
                                saveCursor = null;
                            }
                            break block85;
                        }
                        finally {
                            if (saveCursor != null) {
                                saveCursor.destroy();
                                saveCursor = null;
                            }
                            if (refcursor != null) {
                                refcursor.destroy();
                                refcursor = null;
                            }
                        }
                    }
                    if ((this._state & 0x100) != 0) {
                        if ((this._state & 0x10) == 0) {
                            vd = this.getCacheRef();
                            saveCursor = this._savedCursor;
                            if (saveCursor.isTXNSupported()) {
                                backingTxn.joinTXN(saveCursor);
                            }
                            saveCursor.delete();
                            saveCursor.home();
                            saveCursor = null;
                            this._state |= 0x10;
                            if (TxnData.this.DebugOn(128)) {
                                TxnData.this.log("DELETE : key=" + this.getKey() + ", root key=" + this.getRootKey());
                            }
                        }
                    } else if ((this._state & 0x400) != 0) {
                        this._state |= 0x20;
                    } else if (TxnData.this.DebugOn(128)) {
                        o = this.getValue(true);
                        if (o instanceof TData && !((TData)o)._stale) {
                            o = ((TData)o)._backingStore;
                        }
                        TxnData.this.log("Default : [" + this.getStatusDisplay() + "]: key=" + this.getKey() + ", value=" + o);
                    }
                }
                catch (Exception e) {
                    if (TxnData.this.DebugOn(128)) {
                        Object oo = null;
                        try {
                            oo = this.getValue(true);
                            if (oo instanceof TData && !((TData)oo)._stale) {
                                oo = ((TData)oo)._backingStore;
                            }
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        TxnData.this.log("Exception on key=" + this.getKey() + " store " + oo);
                    }
                    throw new TransactionException(e);
                }
            }
        }

        void nobackingCommit(ITransaction txn) throws TransactionException {
            try {
                if (TxnData.this.DebugOn(128)) {
                    TxnData.this.log("Entry: single node commit key " + this.getKey());
                }
                if (this.getTransaction() != txn) {
                    if (TxnData.this.DebugOn(128)) {
                        TxnData.this.log("Skipping Node : key=" + this.getKey());
                    }
                    return;
                }
                if ((this._state & 1) != 0 && (this.processed() || !this.isPending())) {
                    if ((this._state & 0x12) == 0) {
                        this._state |= 0x10;
                        if (TxnData.this.DebugOn(128)) {
                            TxnData.this.log("DELETEREF : key=" + this.getKey());
                        }
                    }
                    return;
                }
                if ((this._state & 0x80) != 0) {
                    this._state |= 4;
                } else if ((this._state & 0x40) != 0) {
                    this._state |= 4;
                } else if ((this._state & 0x200) != 0) {
                    if ((this._state & 8) == 0) {
                        this._state |= 8;
                    }
                } else if ((this._state & 0x100) != 0) {
                    if ((this._state & 0x10) == 0) {
                        this._state |= 0x10;
                    }
                } else if ((this._state & 0x400) != 0) {
                    this._state |= 0x20;
                }
            }
            catch (Exception e) {
                throw new TransactionException(e);
            }
        }

        private IDataSharedCursor findPrevCursor(Node node) throws DataException {
            IDataSharedCursor cursor = null;
            Node n = node;
            while (cursor == null && (n = n.getPrev()) != null) {
                cursor = n._savedCursor;
            }
            if (cursor != null) {
                cursor = cursor.getCursorClone();
            }
            return cursor;
        }

        void rollback() {
            super.rollback();
            this._kvnode.rollback();
        }

        void rollback(ITransaction txn) throws DataException {
            if (this.getTransaction() != txn) {
                return;
            }
            if ((this._state & 0xC0) != 0) {
                this.getRoot().checkTDataDelete(this, false);
                this.delete(this.getRoot());
                this.destroy();
            } else {
                this.rollback();
            }
            this.luwUnlock(txn);
        }

        void destroy() {
            super.destroy();
            this._kvnode.destroy();
            this._state |= 2;
        }
    }

    class Root
    extends Node {
        LatchedSemaphore _txnLock;
        WmMutex _txnMutex;
        Node _first;
        Node _last;
        String _key;
        int _size;
        TData _parent;

        Root(String key, TData parent) throws DataException {
            this._txnLock = new LatchedSemaphore(true);
            this._txnMutex = new WmMutex();
            this._size = 0;
            this._key = key;
            this._parent = parent;
            IData data = this._parent._backingStore;
            if (data != null) {
                this._savedCursor = data.getSharedCursor();
            }
        }

        void luwLock(ITransaction txn, int status) throws DataException {
            String rk;
            this._txnMutex.lock();
            while (true) {
                if (((Txn)txn).isDead()) {
                    this._txnMutex.unlock();
                    throw new DataDeadlockException("BAC.0004.0008");
                }
                if (this._txn == null || this._txn == txn) break;
                try {
                    ((Txn)txn).setWaitingForNode(this);
                    if (TxnData.this.DebugOn(2)) {
                        rk = null;
                        rk = this.getRootKey();
                        TxnData.this.log("luwLock: Root key=" + rk + " transaction " + txn + " waiting on transaction " + this._txn);
                        TxnData.this.log("  ----->    waiting on transaction " + this._txn);
                        TxnData.this.dumpActiveTxns();
                    }
                    ((Txn)txn).stopWatch();
                    this._txnMutex.unlock();
                    this._txnLock.semWaitReset();
                    this._txnMutex.lock();
                    if (((Txn)txn).isDead()) {
                        if (TxnData.this.DebugOn(2)) {
                            rk = null;
                            rk = this.getRootKey();
                            TxnData.this.log("luwLock: deadlock on key=" + rk + "(" + this.hashCode() + ") killed txn=" + txn + ", owning txn=" + this._txn);
                        }
                        this._txnLock.semPost();
                        if (this._txnMutex.isAcquired()) {
                            this._txnMutex.unlock();
                        }
                        throw new DataDeadlockException("BAC.0004.0008");
                    }
                    ((Txn)txn).startWatch();
                }
                catch (InterruptedException e) {
                    if (((Txn)txn).isDead()) {
                        if (TxnData.this.DebugOn(2)) {
                            String rk2 = null;
                            rk2 = this.getRootKey();
                            TxnData.this.log("luwLock: deadlock on key=" + rk2 + "(" + this.hashCode() + ") killed txn=" + txn + ", owning txn=" + this._txn);
                        }
                        this._txnLock.semPost();
                        if (this._txnMutex.isAcquired()) {
                            this._txnMutex.unlock();
                        }
                        throw new DataDeadlockException("BAC.0004.0008");
                    }
                    this._txnLock.semPost();
                    if (this._txnMutex.isAcquired()) {
                        this._txnMutex.unlock();
                    }
                    throw new DataInterruptedException("BAC.0004.0007");
                }
            }
            ((Txn)txn).setWaitingForNode(null);
            ((Txn)txn).addOwnedEntry(this);
            this.setStatus(status);
            try {
                ((Txn)txn).addToDirty(this);
            }
            catch (TransactionException e) {
                throw new DataException(e);
            }
            this._txn = txn;
            if (this._txnMutex.isAcquired()) {
                this._txnMutex.unlock();
            }
            if (TxnData.this.DebugOn(2)) {
                rk = null;
                rk = this.getRootKey();
                TxnData.this.log("luwLock: key=" + rk + "(" + this.hashCode() + ") lock granted to transaction " + this._txn);
            }
        }

        boolean useIndex() {
            return this._size > this._parent._td.getHashMin();
        }

        boolean isIndexed() {
            return this._index != null;
        }

        TxnDataIndex getIndex() {
            return this._index;
        }

        void createIndex() {
            if (this._index == null) {
                this._index = new TxnDataIndex(this._first);
            }
        }

        void updateKey(Node ele, String oldkey) {
            this._index.updateKey(ele, oldkey);
        }

        Node indexFirst(String key) {
            return this._index.first(key);
        }

        Node indexLast(String key) {
            return this._index.last(key);
        }

        void setFirst(Node node) {
            this._first = node;
        }

        Node getFirst() {
            return this._first;
        }

        void setLast(Node node) {
            this._last = node;
        }

        Node getLast() {
            return this._last;
        }

        synchronized int getSize() {
            return this._size;
        }

        synchronized void incr() {
            ++this._size;
        }

        synchronized void decr() {
            if (this._size > 0) {
                --this._size;
            }
        }

        String getRootKey() {
            return this._key;
        }

        Root getRoot() {
            return this;
        }

        void destroy() {
            super.destroy();
            this._state |= 2;
        }

        private void buildCache() throws DataException {
            int numEntries = 0;
            Object value = null;
            IData store = this._parent._backingStore;
            if (store == null) {
                return;
            }
            this.releaseCache();
            IDataSharedCursor cursor = store.getSharedCursor();
            try {
                if (TxnData.this.DebugOn(4)) {
                    TxnData.this.log("buildCache: creating cache for root key=" + this._key);
                }
                while (cursor.next()) {
                    String key = cursor.getKey();
                    value = null;
                    boolean cacheValue = false;
                    if (++numEntries <= 500) {
                        value = cursor.getValue();
                        cacheValue = true;
                    }
                    if (TxnData.this.DebugOn(4)) {
                        TxnData.this.log("buildCache: create cache node " + numEntries + ", threshold=" + 500 + " for key=" + key + ", value=" + value);
                    }
                    Node ele = this.createElement(key, value, cursor.getCursorClone(), cacheValue, true);
                    ele.addToEnd(this);
                }
            }
            catch (DataException e) {
                cursor.destroy();
                this.releaseCache();
                throw e;
            }
            cursor.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkCache() throws DataException {
            boolean rc = true;
            if (TxnData.this.DebugOn(4)) {
                TxnData.this.log("checkCache: checking cache for root key=" + this._key);
            }
            Root root = this;
            synchronized (root) {
                Object o;
                if (this._parent.getUsage() > 0) {
                    return false;
                }
                for (Node node = this.getFirst(); node != null && (!((o = ((Element)node).getValue(true)) instanceof TData) || ((TData)o)._stale || (rc = ((TData)o).getRoot().checkCache())); node = node.getNext()) {
                }
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseCache() throws DataException {
            if (TxnData.this.DebugOn(4)) {
                TxnData.this.log("releaseCache: releasing cache for root key=" + this._key);
            }
            Root root = this;
            synchronized (root) {
                for (Node node = this.getFirst(); node != null; node = node.getNext()) {
                    String key = ((Element)node).getKey();
                    Object o = ((Element)node).getValue(true);
                    if (o instanceof TData && !((TData)o)._stale) {
                        ((TData)o).getRoot().releaseCache();
                    }
                    if (TxnData.this.DebugOn(4)) {
                        TxnData.this.log("releaseCache: releasing cache node for key=" + key + ", value=" + o);
                    }
                    node.delete(this);
                    node.destroy();
                }
            }
        }

        Node createElement(String key, Object object, IDataSharedCursor cursor, boolean cacheValue, boolean persist) throws DataException {
            Object o = object;
            Element ele = null;
            boolean newTData = false;
            if (object != null && (this._parent._td.isBackingStoreType(object) || this._parent._td._storeType == 2 && object instanceof IData)) {
                TData td = this._parent._td.findIDataRef((IData)object);
                if (td != null) {
                    o = td;
                } else {
                    o = new TData(this._parent._td, this._parent, key, (IData)object, true);
                    newTData = true;
                    this._parent._td.addIDataRef((TData)o);
                }
            }
            ele = new Element(this, key, o, cursor, cacheValue, persist);
            if (o instanceof TData && !((TData)o)._stale) {
                ((TData)o).setElement(ele);
            }
            return ele;
        }

        void checkTDataDelete(Element node, boolean luwlock) throws DataException {
            Object o = null;
            Vector<Object> tdatas = new Vector<Object>();
            if (node == null) {
                return;
            }
            ValueData vd = node._kvnode._value;
            if (vd != null && (o = vd.getValue(true)) instanceof TData && !((TData)o)._stale) {
                tdatas.addElement(o);
                this.getAllTDatas((TData)o, tdatas, luwlock, node.getTransaction());
            }
            if ((vd = node._kvnode._newvalue) != null && (o = vd.getValue(true)) instanceof TData && !((TData)o)._stale) {
                tdatas.addElement(o);
                this.getAllTDatas((TData)o, tdatas, luwlock, node.getTransaction());
            }
            for (int i = tdatas.size(); i >= 1; --i) {
                TData t = (TData)tdatas.elementAt(i - 1);
                if (t._stale || luwlock) continue;
                t.decrUsage(true);
                t.removeElement(node);
            }
        }

        private void getAllTDatas(TData data, Vector list, boolean luwlock, ITransaction txn) throws DataException {
            Object o = null;
            for (Element node = (Element)data.getRoot().getFirst(); node != null; node = (Element)node.getNext()) {
                if (luwlock) {
                    node.luwLock(txn, 1024);
                }
                if ((o = node.getValue(true)) instanceof TData && !((TData)o)._stale) {
                    list.addElement(o);
                    this.getAllTDatas((TData)o, list, luwlock, txn);
                }
                o = null;
            }
        }

        void backingCommit(ITransaction txn, ITransaction backingTxn) {
        }

        void nobackingCommit(ITransaction txn) {
        }

        void commit(ITransaction txn) {
            this.setStatus(1984);
        }

        void rollback(ITransaction txn) {
            this.setStatus(1984);
        }
    }

    abstract class Node {
        TxnDataIndex _index = null;
        Node _next;
        Node _prev;
        ITransaction _txn;
        int _state = 0;
        Object cLock = new Object();
        short _cursors = 0;
        IDataSharedCursor _savedCursor;

        Node() {
        }

        boolean nodeIsPersisted() {
            return true;
        }

        void saveCursor(IDataSharedCursor cursor) {
            this._savedCursor = cursor;
        }

        void releaseCursor() {
            if (this._savedCursor != null) {
                this._savedCursor.destroy();
                this._savedCursor = null;
            }
        }

        final boolean isPending() {
            return (this._state & 0x7C0) != 0;
        }

        final boolean processed() {
            return (this._state & 0x3C) != 0;
        }

        final boolean canAccess(Root root, ITransaction txn) throws DataException {
            if ((this._state & 2) != 0) {
                return false;
            }
            if ((this._state & 0x101) != 0) {
                return false;
            }
            if ((this._state & 0x7C0) == 0) {
                return true;
            }
            if ((this._state & 0xC0) != 0 && txn == this._txn) {
                return true;
            }
            if ((this._state & 0x200) != 0) {
                return true;
            }
            return (this._state & 0x400) != 0;
        }

        void setStatus(int status) {
            if (status == 2048) {
                return;
            }
            if (status == 1984) {
                this._state &= ~status;
                return;
            }
            if (status == 256) {
                this._state &= 0xFFFFF83F;
                this._state |= status;
                return;
            }
            if ((this._state & 0x1C0) != 0) {
                return;
            }
            if ((this._state & 0x200) != 0) {
                return;
            }
            this._state &= 0xFFFFF83F;
            this._state |= status;
        }

        String getStatusDisplay() {
            String s = "";
            s = (this._state & 0x7C0) != 0 ? "NO" : ((this._state & 0x40) != 0 ? "INSERT" : ((this._state & 0x80) != 0 ? "INSERTDATA" : ((this._state & 0x100) != 0 ? "DELETE" : ((this._state & 0x200) != 0 ? "UPDATE" : "UNKNOWN STATUS"))));
            if ((this._state & 1) != 0) {
                s = s + "-refdelete";
            }
            s = (this._state & 4) != 0 ? s + "(INSERTED)" : ((this._state & 8) != 0 ? s + "(UPDATED)" : ((this._state & 0x10) != 0 ? s + "(DELETED)" : s + "(PENDING)"));
            return s;
        }

        void setFirst(Node node) {
        }

        Node getFirst() {
            return null;
        }

        void setLast(Node node) {
        }

        Node getLast() {
            return null;
        }

        int getSize() {
            return -1;
        }

        void incr() {
        }

        void decr() {
        }

        String getKey() {
            return null;
        }

        void setKey(String key) {
        }

        void commit() throws DataException {
            this.clearPendingState();
        }

        abstract void commit(ITransaction var1) throws DataException;

        abstract void rollback(ITransaction var1) throws DataException;

        abstract void backingCommit(ITransaction var1, ITransaction var2) throws TransactionException;

        abstract void nobackingCommit(ITransaction var1) throws TransactionException;

        abstract Root getRoot();

        abstract boolean isIndexed();

        abstract boolean useIndex();

        private void clearPendingState() {
            this._state &= 0xFFFFF802;
        }

        void rollback() {
            this.clearPendingState();
        }

        void setValue(Object value) throws DataException {
        }

        void destroy() {
            this.releaseCursor();
            if (this._txn != null) {
                this.luwUnlock(this._txn);
            }
        }

        void setNext(Node node) {
            this._next = node;
        }

        Node getNext() {
            return this._next;
        }

        void setPrev(Node node) {
            this._prev = node;
        }

        Node getPrev() {
            return this._prev;
        }

        ITransaction getTransaction() {
            return this._txn;
        }

        abstract void luwLock(ITransaction var1, int var2) throws DataException;

        void luwUnlock(ITransaction txn) {
            if (txn == this._txn) {
                if (TxnData.this.DebugOn(2)) {
                    String k = null;
                    String rk = null;
                    if (this instanceof Root) {
                        rk = ((Root)this).getRootKey();
                    }
                    if (this instanceof Element) {
                        rk = ((Element)this).getRoot().getRootKey();
                        k = ((Element)this).getKey();
                    }
                    TxnData.this.log("luwUnlock: key=" + rk + ":" + k + "(" + this.hashCode() + ") releasing lock for transaction " + this._txn);
                }
                this._txn = null;
            } else if (TxnData.this.DebugOn(2)) {
                String k = null;
                String rk = null;
                if (this instanceof Root) {
                    rk = ((Root)this).getRootKey();
                }
                if (this instanceof Element) {
                    rk = ((Element)this).getRoot().getRootKey();
                    k = ((Element)this).getKey();
                }
                TxnData.this.log("luwUnlock: key=" + rk + ":" + k + "(" + this.hashCode() + ") transaction " + txn + " does not own lock, owned by transaction " + this._txn);
            }
        }

        boolean delete(Root root) {
            root.decr();
            if (this._prev == null) {
                root.setFirst(this._next);
            } else {
                this._prev.setNext(this._next);
            }
            if (this._next == null) {
                root.setLast(this._prev);
            } else {
                this._next.setPrev(this._prev);
            }
            if (root.isIndexed()) {
                root.getIndex().delete(this);
            }
            this._prev = null;
            return true;
        }

        void insertBefore(Root root, Node node) {
            this.insert(root, node, this._prev);
        }

        void insertAfter(Root root, Node node) {
            this.insert(root, node, this);
        }

        private void insert(Root root, Node data, Node afterThis) {
            if (afterThis == null) {
                data.setNext(root.getFirst());
                data.setPrev(null);
                root.setFirst(data);
            } else {
                data.setNext(afterThis.getNext());
                data.setPrev(afterThis);
                afterThis.setNext(data);
            }
            if (data.getNext() != null) {
                data.getNext().setPrev(data);
            } else {
                root.setLast(data);
            }
            if (root.isIndexed()) {
                root.getIndex().insertAfter(afterThis, data);
            }
            root.incr();
        }

        void addToEnd(Root root) {
            if (root.getSize() == 0) {
                root.setFirst(this);
                root.setLast(this);
                this._next = null;
                this._prev = null;
                root._index = null;
            } else {
                this._prev = root.getLast();
                this._next = null;
                root.getLast().setNext(this);
                root.setLast(this);
                if (root.isIndexed()) {
                    root.getIndex().addAsLast(this);
                }
            }
            root.incr();
        }

        void addToFront(Root root) {
            if (root.getSize() == 0) {
                root.setFirst(this);
                root.setLast(this);
                this._next = null;
                this._prev = null;
                root._index = null;
            } else {
                this._prev = null;
                this._next = root.getFirst();
                root.getFirst().setPrev(this);
                root.setFirst(this);
                if (root.isIndexed()) {
                    root.getIndex().addAsFirst(this);
                }
            }
            root.incr();
        }

        public boolean keyMatch(String k1) {
            return this.keyMatch(this.getKey(), k1);
        }

        public boolean keyMatch(Node e) {
            return this.keyMatch(this.getKey(), e.getKey());
        }

        private boolean keyMatch(String k1, String k2) {
            if (k1 == k2) {
                return true;
            }
            if (k1 == null || k2 == null) {
                return false;
            }
            return k1.equals(k2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startCursor() {
            Object object = this.cLock;
            synchronized (object) {
                this._cursors = (short)(this._cursors + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endCursor() {
            Object object = this.cLock;
            synchronized (object) {
                if (this._cursors == 0) {
                    throw new BasisRuntimeException("BAC.0001.0035", new String[]{this.toString()});
                }
                this._cursors = (short)(this._cursors - 1);
                if (this._cursors == 1) {
                    this.cLock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitLastCursor() throws DataException {
            int retry = 0;
            do {
                Object object = this.cLock;
                synchronized (object) {
                    if (this._cursors > 1) {
                        try {
                            this.cLock.wait(250L);
                        }
                        catch (Exception e) {
                            throw new DataException(e);
                        }
                    }
                }
            } while (++retry < 3);
            if (this._cursors > 1) {
                if (TxnData.this.DebugOn(4096)) {
                    TxnData.this.log("waitLastCursor: Root key=" + this.getRoot().getRootKey() + " entry key=" + this.getKey() + " txn=" + this._txn);
                }
                throw new DataDeadlockException("BAC.0004.0011");
            }
        }
    }

    class BackingValueData
    extends ValueData {
        BackingValueData(Object value, KVNode parent, boolean softref, short type, boolean cacheValue) throws DataException {
            super(value, parent, type);
            this._flags = softref ? (short)(this._flags | 0x10) : (short)(this._flags & 0xFFFFFFEF);
            this.setValue(value, cacheValue);
        }

        void setValue(Object value) throws DataException {
            this.setValue(value, true);
        }

        void setValue(Object value, boolean cacheValue) throws DataException {
            this._flags = (short)(this._flags & 0xFFFFFFFB);
            if (value == null && cacheValue) {
                this._flags = (short)(this._flags | 4);
            }
            this._value = (this._flags & 0x10) != 0 ? new SoftReference<Object>(value) : value;
        }

        void destroy() {
            super.destroy();
            if (this.getUsage() == 0) {
                this._flags = (short)(this._flags & 0xFFFFFFEF);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getValue(boolean readonly) throws DataException {
            Object o = null;
            IDataSharedCursor cursor = null;
            if ((this._flags & 0x10) != 0) {
                BackingValueData backingValueData = this;
                synchronized (backingValueData) {
                    o = ((SoftReference)this._value).get();
                    if (o == null && (this._flags & 4) == 0) {
                        if (TxnData.this.DebugOn(256)) {
                            TxnData.this.log("BackingValueData.getValue() SoftRefence is null for node key=" + this._parent.getKey() + " root key=" + this._parent._root.getRootKey());
                        }
                        if (TxnData.this.DebugOn(512)) {
                            Node n = this._parent._root.getFirst();
                            int cnt = 0;
                            while (n != null) {
                                TxnData.this.log("   [" + cnt + "]   node key=" + n.getKey() + " [" + n.getStatusDisplay() + "]");
                                n = n.getNext();
                                ++cnt;
                            }
                        }
                        cursor = this._parent._ele._savedCursor.getCursorClone();
                        o = cursor.getValue();
                        cursor.destroy();
                        String key = null;
                        key = (this._parent._ele._kvnode._flags & 0x20) != 0 ? this._parent._ele._kvnode._key : this._parent._ele.getKey();
                        if (!key.equals(this._parent._ele._savedCursor.getKey())) {
                            if (TxnData.this.DebugOn(256)) {
                                TxnData.this.log("BackingValueData.getValue() keys do not match cache=" + this._parent._ele.getKey() + " store=" + this._parent._ele._savedCursor.getKey());
                            }
                            if ((this._flags & 4) == 0) {
                                throw new DataException("BAC.0004.0010");
                            }
                            return null;
                        }
                        if (o != null && (this._parent._root._parent._td.isBackingStoreType(o) || this._parent._root._parent._td._storeType == 2 && o instanceof IData)) {
                            TData td = this._parent._root._parent._td.findIDataRef((IData)o);
                            if (td != null) {
                                o = td;
                                if (TxnData.this.DebugOn(2048)) {
                                    TxnData.this.log("BackingValueData.getValue() reusing TData for root key " + this._parent._root.getRootKey());
                                }
                            } else {
                                if (TxnData.this.DebugOn(256)) {
                                    TxnData.this.log("BackingValueData.getValue() creating new TData for root key " + this._parent._root.getRootKey());
                                }
                                o = new TData(this._parent._root._parent._td, this._parent._root._parent, this._parent._ele._savedCursor.getKey(), (IData)o, true);
                                ((TData)o).setElement(this._parent._ele);
                                this._parent._root._parent._td.addIDataRef((TData)o);
                            }
                        }
                        this._value = new SoftReference<Object>(o);
                        if (TxnData.this.DebugOn(256)) {
                            TxnData.this.log("BackingValueData.getValue() refreshed SoftReference for key " + this._parent._ele._savedCursor.getKey());
                        }
                    }
                }
            } else {
                o = this._value;
            }
            if (o instanceof ValueRef) {
                o = ((ValueRef)o).getNode().getValue(readonly);
            }
            if (o == null && (this._flags & 4) == 0) {
                throw new DataException("BAC.0004.0009");
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getValueReference() throws DataException {
            Object o = null;
            IDataSharedCursor cursor = null;
            BackingValueData backingValueData = this;
            synchronized (backingValueData) {
                if (this._parent != null) {
                    Element thisNode = this._parent._ele;
                    if (TxnData.this.DebugOn(256)) {
                        TxnData.this.log("getValueRef: element key=" + thisNode.getKey());
                    }
                    if ((thisNode._state & 0x10) != 0) {
                        return null;
                    }
                    if (TxnData.this.DebugOn(256)) {
                        TxnData.this.log("getValueRef: positioned node key=" + thisNode.getKey() + " cursor key=" + this._parent._ele._savedCursor.getKey());
                    }
                    cursor = this._parent._ele._savedCursor.getCursorClone();
                    if (thisNode.getKey().equals(cursor.getKey())) {
                        if ((this._flags & 0x10) != 0 && ((SoftReference)this._value).get() == null) {
                            this._value = new SoftReference<Object>(cursor.getValue());
                        }
                        o = cursor.getValueReference();
                    } else if (TxnData.this.DebugOn(256)) {
                        TxnData.this.log("BackingValueData.getValue() keys do not match cache=" + thisNode.getKey() + " store=" + this._parent._ele._savedCursor.getKey());
                    }
                } else if (TxnData.this.DebugOn(256)) {
                    TxnData.this.log("getValueRef: can not key value ref because parent is null");
                }
            }
            cursor.destroy();
            return o;
        }
    }

    class ValueData {
        Object _value;
        KVNode _parent;
        short _usage;
        short _flags = 0;

        ValueData(Object value, KVNode parent, short type) {
            this._value = value;
            this._parent = parent;
            this._usage = 1;
            this._flags = (short)(this._flags | type);
            this._flags = (short)(this._flags & 0xFFFFFFFB);
            if (this._value == null) {
                this._flags = (short)(this._flags | 4);
            }
        }

        void setValue(Object value) throws DataException {
            Object o;
            this._value = o = value;
        }

        synchronized void incrUsage() {
            this._usage = (short)(this._usage + 1);
        }

        synchronized int decrUsage() {
            if (this._usage > 0) {
                this._usage = (short)(this._usage - 1);
            }
            return this._usage;
        }

        synchronized int getUsage() {
            return this._usage;
        }

        void destroy() {
            int cnt = this.decrUsage();
            if (cnt == 0) {
                this._value = null;
                this._parent = null;
                this._usage = 0;
                this._flags = 0;
            }
        }

        Object getValue(boolean readonly) throws DataException {
            Object o = this._value;
            if (this._value == null && (this._flags & 4) == 0) {
                throw new DataException("BAC.0004.0009");
            }
            if (o instanceof ValueRef) {
                o = ((ValueRef)o).getNode().getValue(readonly);
            }
            return o;
        }
    }

    class KVNode {
        short _flags = 0;
        String _key;
        String _newkey;
        ValueData _value;
        ValueData _newvalue;
        Root _root;
        Element _ele;

        KVNode(String key, Object object, Root root, Element ele, boolean cacheValue) throws DataException {
            this._key = key;
            this._root = root;
            this._ele = ele;
            this._value = new BackingValueData(object, this, true, 1, cacheValue);
            this._flags = (short)(this._flags | 0x80);
        }

        KVNode(String key, Object object, Root root) throws DataException {
            this._key = key;
            this._root = root;
            if (object != null) {
                this._value = new ValueData(object, this, 1);
                this._value.setValue(object);
            }
        }

        ValueData getCacheRef() {
            if ((this._flags & 0x40) != 0) {
                return this._newvalue;
            }
            return this._value;
        }

        void setKey(String key) {
            this._flags = (short)(this._flags | 0x20);
            this._newkey = key;
        }

        void setValue(Object value) throws DataException {
            this._flags = (short)(this._flags | 0x40);
            if (this._newvalue != null) {
                this._newvalue.destroy();
                this._newvalue = null;
            }
            if ((this._flags & 0x80) != 0) {
                this._newvalue = new BackingValueData(value, this, false, 2, true);
            } else {
                this._newvalue = new ValueData(value, this, 2);
                this._newvalue.setValue(value);
            }
        }

        void rollback() {
            if (this._newvalue != null) {
                this._newvalue.destroy();
            }
            this._newkey = null;
            this._newvalue = null;
            this._flags = (short)(this._flags & 0xFFFFFFDF);
            this._flags = (short)(this._flags & 0xFFFFFFBF);
        }

        void commit() throws DataException {
            if ((this._flags & 0x20) != 0) {
                this._key = this._newkey;
                this._newkey = null;
                this._flags = (short)(this._flags & 0xFFFFFFDF);
            }
            if ((this._flags & 0x40) != 0) {
                if (this._newvalue != null) {
                    if (this._value != null) {
                        this._value.destroy();
                    }
                    this._value = this._newvalue;
                    if ((this._flags & 0x80) != 0) {
                        Object o = this._newvalue.getValue(true);
                        ((BackingValueData)this._value)._flags = (short)(((BackingValueData)this._value)._flags | 0x10);
                        this._value.setValue(o);
                    }
                }
                this._newvalue = null;
                this._flags = (short)(this._flags & 0xFFFFFFBF);
            }
        }

        String getKey() {
            if ((this._flags & 0x20) != 0) {
                return this._newkey;
            }
            return this._key;
        }

        Object getValueForCommit(boolean readonly) throws DataException {
            Object o = null;
            if ((this._flags & 0x40) != 0) {
                if (this._newvalue != null) {
                    o = this._newvalue.getValue(readonly);
                }
            } else if (this._value != null) {
                o = this._value.getValue(readonly);
            }
            return o;
        }

        Object getValue(boolean readonly) throws DataException {
            Object o = null;
            if ((this._flags & 0x40) != 0) {
                if (this._newvalue != null) {
                    o = this._newvalue.getValue(readonly);
                }
            } else if (this._value != null) {
                o = this._value.getValue(readonly);
            }
            return o;
        }

        Object getValueReference() throws DataException {
            Object o = null;
            if ((this._flags & 0x40) != 0) {
                if (this._newvalue != null) {
                    o = this._newvalue._value;
                }
            } else if (this._value != null) {
                o = this._value._value;
            }
            return o;
        }

        void destroy() {
            if (this._value != null) {
                this._value.destroy();
            }
            this._value = null;
            this._key = null;
            if (this._newvalue != null) {
                this._newvalue.destroy();
            }
            this._newvalue = null;
            this._newkey = null;
        }
    }

    class TData
    implements IData,
    IDataAdmin {
        Root _root;
        Vector _elements = new Vector();
        IData _backingStore;
        TxnData _td;
        TData _parent;
        int _usage = 0;
        String _key;
        boolean _refreshCache = false;
        transient boolean recursed = false;
        Vector _cursors = new Vector();
        boolean _stale = false;

        public int size() throws DataException {
            return this._root._size;
        }

        private TData(TxnData td, TData parent, String key, IData data, boolean refresh) {
            this._key = key;
            this._td = td;
            this._parent = parent;
            this._backingStore = data;
            this._refreshCache = refresh;
            this.incrUsage();
            try {
                this._root = new Root(this._key, this);
            }
            catch (DataException e) {
                this._root = null;
                throw new BasisRuntimeException(e);
            }
        }

        private TData(TxnData td, TData parent, String key) {
            this(td, parent, key, null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addCursor(Cursor cursor) {
            Vector vector = this._cursors;
            synchronized (vector) {
                this._cursors.addElement(cursor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCursor(Cursor cursor) {
            Vector vector = this._cursors;
            synchronized (vector) {
                this._cursors.removeElement(cursor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void killAllCursors() {
            Vector vector = this._cursors;
            synchronized (vector) {
                int size = this._cursors.size();
                for (int i = 0; i < size; ++i) {
                    Cursor c = (Cursor)this._cursors.elementAt(i);
                    c.makeStale();
                }
                this._cursors.removeAllElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setElement(Element element) {
            Vector vector = this._elements;
            synchronized (vector) {
                if (!this._elements.contains(element)) {
                    this._elements.addElement(element);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isNotDeleted() {
            boolean rc = false;
            Vector vector = this._elements;
            synchronized (vector) {
                for (int i = 0; i < this._elements.size(); ++i) {
                    Element ele = (Element)this._elements.elementAt(i);
                    if ((ele._state & 0x10) != 0 || (ele._state & 0x101) != 0) continue;
                    rc = true;
                    break;
                }
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeElement(Element node) {
            Vector vector = this._elements;
            synchronized (vector) {
                if (this._elements.contains(node)) {
                    this._elements.removeElement(node);
                }
            }
        }

        Root getRoot() {
            this.checkIDataState();
            return this._root;
        }

        synchronized void incrUsage() {
            this.checkIDataState();
            ++this._usage;
            if (TxnData.this.DebugOn(2048)) {
                int hash = -1;
                if (this._backingStore != null) {
                    hash = this._backingStore.hashCode();
                }
                String pkey = null;
                if (this._parent != null) {
                    pkey = this._parent._key;
                }
                TxnData.this.log("incrUsage: count after=" + this._usage + ", TData key=" + this._key + ", TData hash=" + this.hashCode() + ", parent key=" + pkey + ", store hash=" + hash);
            }
        }

        void decrUsage() throws DataException {
            this.decrUsage(false);
        }

        synchronized void decrUsage(boolean force) throws DataException {
            this.checkIDataState();
            if (TxnData.this.DebugOn(2048)) {
                int hash = -1;
                if (this._backingStore != null) {
                    hash = this._backingStore.hashCode();
                }
                String pkey = null;
                if (this._parent != null) {
                    pkey = this._parent._key;
                }
                TxnData.this.log("decrUsage: count before=" + this._usage + ", TData key=" + this._key + ", TData hash=" + this.hashCode() + ", parent key=" + pkey + ", store hash=" + hash);
            }
            if (this._usage > 0) {
                --this._usage;
            }
            if (this._usage == 0 || force) {
                if (this._root.checkCache()) {
                    this._root.releaseCache();
                    this._td.removeIDataRef(this);
                    this.killAllCursors();
                    this._backingStore = null;
                    this._refreshCache = true;
                    this._stale = true;
                }
                this._usage = 0;
            }
        }

        int getUsage() {
            return this._usage;
        }

        public IDataCursor getCursor() {
            return DataCursorEmulator.create(this.getSharedCursor());
        }

        void checkIDataState() {
            if (this._stale) {
                throw new BasisRuntimeException("BAC.0004.0022");
            }
        }

        public IDataSharedCursor getSharedCursor() {
            return this.getSharedCursor(null);
        }

        public IDataIndexCursor getIndexCursor() {
            throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataIndexCursor"});
        }

        public IDataTreeCursor getTreeCursor() {
            throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataTreeCursor"});
        }

        public IDataHashCursor getHashCursor() {
            throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataHashCursor"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cursor getSharedCursor(Node node) {
            Cursor ret = null;
            this.checkIDataState();
            TData tData = this;
            synchronized (tData) {
                try {
                    if (this._root == null) {
                        this._root = new Root(this._key, this);
                    }
                    if (this._refreshCache && this._backingStore != null) {
                        this._root.buildCache();
                        this._refreshCache = false;
                    }
                }
                catch (Exception e) {
                    if (TxnData.this.DebugOn(16)) {
                        TxnData.this.log("unable to create shared cursor " + e.getClass().getName() + ":" + e.getMessage());
                    }
                    throw new BasisRuntimeException("BAC.0001.0034", e);
                }
                ret = new Cursor(this._root, node);
            }
            this.addCursor(ret);
            return ret;
        }

        public synchronized String toString() {
            if (this.recursed) {
                return " {*TData " + this.hashCode() + " recursed*} ";
            }
            this.recursed = true;
            StringBuffer sb = new StringBuffer();
            sb.append("{TData:");
            for (Node de = this._root.getFirst(); de != null; de = de.getNext()) {
                sb.append(de.getKey());
                sb.append("=");
                try {
                    sb.append(((Element)de).getValue(true));
                }
                catch (DataException e) {
                    sb.append("[null]");
                }
                if (de == null) break;
                sb.append(",");
            }
            sb.append("}");
            this.recursed = false;
            return sb.toString();
        }

        protected void finalize() throws IOException {
            if (!this._stale) {
                TxnData.this.removeIDataRef(this);
                this._stale = true;
            }
        }
    }
}

