/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.data;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.util.data.IntHashtable;
import java.lang.reflect.Array;

public class Objects {
    public static boolean compare(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            int l1 = Array.getLength(o1);
            if (l1 != Array.getLength(o2)) {
                return false;
            }
            for (int i = 0; i < l1; ++i) {
                if (Objects.compare(Array.get(o1, i), Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean dataCompare(IData d1, IData d2) {
        return Objects._dataCompare(d1, d2, new IntHashtable(11));
    }

    private static boolean _dataCompare(IData d1, IData d2, IntHashtable h) {
        if (d1 == null || d2 == null) {
            return d1 == d2;
        }
        if (h.get(d1.hashCode()) == d2) {
            return true;
        }
        h.put(d1.hashCode(), d2);
        IDataCursor c1 = d1.getCursor();
        IDataCursor c2 = d2.getCursor();
        boolean ret = true;
        while (ret && c1.next()) {
            if (!c2.next()) {
                ret = false;
                break;
            }
            if (!Objects.compare(c1.getKey(), c2.getKey())) {
                ret = false;
                break;
            }
            Object v1 = c1.getValue();
            Object v2 = c2.getValue();
            if (v1 instanceof IData) {
                if (v2 instanceof IData) {
                    ret = Objects._dataCompare((IData)v1, (IData)v2, h);
                    continue;
                }
                ret = false;
                continue;
            }
            if (v2 instanceof IData) {
                ret = false;
                continue;
            }
            ret = Objects.compare(v1, v2);
        }
        if (ret && c2.next()) {
            ret = false;
        }
        c1.destroy();
        c2.destroy();
        return ret;
    }

    public static boolean compare(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

