/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.data;

import com.wm.data.DataException;
import com.wm.data.DataSharedCursorEmulator;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.util.BasisRuntimeException;
import java.io.Serializable;

public abstract class MemSchemaData
implements IData,
Serializable {
    private Object[][] data;
    private int nextID;

    protected MemSchemaData(Object[][] data) {
        if (data == null) {
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"data:null"});
        }
        this.nextID = 0;
        this.data = data;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length != 2) {
                throw new BasisRuntimeException("BAC.0009.0031", new String[]{"rows<2"});
            }
            if (data[i][0] != null) continue;
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"keys:null"});
        }
    }

    public final int nextID() {
        return this.nextID++;
    }

    public final Object get(int index) {
        return this.data[index][1];
    }

    public final void set(int index, Object val) {
        this.data[index][1] = val;
    }

    protected final Object get(String key) {
        int index = MemSchemaData.indexOf(this.data, key);
        if (index > -1) {
            return this.data[index][1];
        }
        return null;
    }

    protected final void set(String key, Object val) {
        int index = MemSchemaData.indexOf(this.data, key);
        if (index > -1) {
            this.data[index][1] = val;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(">>>MemSchemaData:");
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.data[i][0]);
            sb.append("=");
            sb.append(this.data[i][1]);
        }
        sb.append("<<<");
        return sb.toString();
    }

    private static final int indexOf(Object[][] data, String key) {
        for (int i = 0; i < data.length; ++i) {
            if (((String)data[i][0]).intern() != key.intern()) continue;
            return i;
        }
        return -1;
    }

    public final IDataCursor getCursor() {
        return new DCursor();
    }

    public final IDataSharedCursor getSharedCursor() {
        return DataSharedCursorEmulator.create(this.getCursor());
    }

    public IDataIndexCursor getIndexCursor() {
        throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataIndexCursor"});
    }

    public IDataTreeCursor getTreeCursor() {
        throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataTreeCursor"});
    }

    public IDataHashCursor getHashCursor() {
        throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataHashCursor"});
    }

    public static Object[][] merge(Object[][] d1, Object[][] d2) {
        int i;
        int d1l = d1.length;
        int d2l = d2.length;
        int tl = d1l + d2l;
        Object[][] d3 = new Object[tl][2];
        for (i = 0; i < d1l; ++i) {
            d3[i][0] = d1[i][0];
            d3[i][1] = d1[i][1];
        }
        for (i = 0; i < d2l; ++i) {
            d3[i + d1l][0] = d2[i][0];
            d3[i + d1l][1] = d2[i][1];
        }
        return d3;
    }

    protected static int getLastIndex() {
        return -1;
    }

    protected static Object[][] createData(int size) {
        return new Object[size][2];
    }

    final class DCursor
    implements IDataCursor {
        int index = -1;

        DCursor() {
        }

        private boolean keyMatch(String key) {
            return this.keyScan(key, 0, 1);
        }

        private boolean keyScan(String key, int incr) {
            return this.keyScan(key, this.index, incr);
        }

        private boolean keyScan(String key, int start, int incr) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0009.0031", new String[]{"key:null"});
            }
            if (this.getKey().equals(key)) {
                return true;
            }
            if (start < 0) {
                start = Math.min(start, MemSchemaData.this.data.length);
            }
            for (int i = start; i < MemSchemaData.this.data.length && i >= 0; i += incr) {
                if (!MemSchemaData.this.data[i][0].equals(key)) continue;
                this.index = i;
                return true;
            }
            return false;
        }

        private boolean positioned() {
            return this.index >= 0 && this.index < MemSchemaData.this.data.length;
        }

        public void setErrorMode(int m) {
        }

        public DataException getLastError() {
            return null;
        }

        public boolean hasMoreErrors() {
            return false;
        }

        public void home() {
            this.index = -1;
        }

        public String getKey() {
            return this.positioned() ? MemSchemaData.this.data[this.index][0].toString() : null;
        }

        public Object getValue() {
            return this.positioned() ? MemSchemaData.this.data[this.index][1] : null;
        }

        public void setKey(String key) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0009.0031", new String[]{"nullKey"});
            }
            ((MemSchemaData)MemSchemaData.this).data[this.index][0] = key;
        }

        public void setValue(Object value) {
            ((MemSchemaData)MemSchemaData.this).data[this.index][1] = value;
        }

        public boolean delete() {
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"delete"});
        }

        public void insertBefore(String key, Object value) {
            this.previous();
            if (this.keyMatch(key)) {
                this.setValue(value);
            }
        }

        public void insertAfter(String key, Object value) {
            this.next();
            if (this.keyMatch(key)) {
                this.setValue(value);
            }
        }

        public IData insertDataBefore(String key) {
            this.previous();
            if (this.keyMatch(key)) {
                return (IData)this.getValue();
            }
            return null;
        }

        public IData insertDataAfter(String key) {
            this.next();
            if (this.keyMatch(key)) {
                return (IData)this.getValue();
            }
            return null;
        }

        public boolean next() {
            if (this.hasMoreData()) {
                ++this.index;
                return true;
            }
            return false;
        }

        public boolean next(String key) {
            return this.keyScan(key, this.index, 1);
        }

        public boolean previous() {
            if (this.index > 0) {
                --this.index;
                return true;
            }
            return false;
        }

        public boolean previous(String key) {
            return this.keyScan(key, this.index, -1);
        }

        public boolean first() {
            if (MemSchemaData.this.data.length > 0) {
                this.index = 0;
            }
            return this.index >= 0;
        }

        public boolean first(String key) {
            return this.keyScan(key, 0, 1);
        }

        public boolean last() {
            this.index = MemSchemaData.this.data.length - 1;
            return this.index >= 0;
        }

        public boolean last(String key) {
            return this.keyScan(key, MemSchemaData.this.data.length - 1, -1);
        }

        public boolean hasMoreData() {
            return this.index < MemSchemaData.this.data.length - 1;
        }

        public void destroy() {
        }

        public IDataCursor getCursorClone() {
            DCursor c = new DCursor();
            c.index = this.index;
            return c;
        }
    }
}

