/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.data;

import com.wm.data.DataException;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataHashCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.data.IDataTreeCursor;
import com.wm.txn.ITransaction;
import com.wm.txn.TransactionException;
import com.wm.util.BasisRuntimeException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public abstract class MemData
implements IData,
Serializable {
    static final long serialVersionUID = -1671214344935862567L;
    private MemDataIndex index = null;
    private Element first;
    private Element last;
    private int size;
    protected int hash_min = 10000;
    private transient boolean recursed = false;
    private static final boolean debug = false;

    public abstract MemData newInstance();

    public IDataCursor getCursor() {
        return new Cursor(null);
    }

    public IDataSharedCursor getSharedCursor() {
        return new SharedCursor((Cursor)this.getCursor());
    }

    public IDataIndexCursor getIndexCursor() {
        throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataIndexCursor"});
    }

    public IDataTreeCursor getTreeCursor() {
        throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataTreeCursor"});
    }

    public IDataHashCursor getHashCursor() {
        throw new BasisRuntimeException("BAC.0001.0033", new String[]{"IDataHashCursor"});
    }

    private boolean useIndex() {
        return this.size > this.hash_min;
    }

    private boolean isIndexed() {
        return this.index != null;
    }

    private int getHashValue(String key) {
        if (key != null) {
            return key.hashCode() * 1918469687;
        }
        return 1;
    }

    public synchronized String toString() {
        if (this.recursed) {
            return " {*MemData " + this.hashCode() + " recursed*} ";
        }
        this.recursed = true;
        Element de = this.first;
        StringBuffer sb = new StringBuffer();
        sb.append("{MemData:");
        while (de != null) {
            sb.append(de.key);
            sb.append("=");
            sb.append(de.value);
            de = de.next;
            if (de == null) break;
            sb.append(",");
        }
        sb.append("}");
        this.recursed = false;
        return sb.toString();
    }

    final class MemDataIndex {
        private TreeMap map = new TreeMap();
        private static final boolean debug = false;

        public MemDataIndex(Element first) {
            if (first != null) {
                this.insertNew(first);
                Element e = first.next;
                while (e != null) {
                    this.insertAfter(e.prev, e);
                    e = e.next;
                }
            }
        }

        public Element first(String key) {
            LinkedList l = (LinkedList)this.map.get(key);
            if (l != null) {
                return (Element)l.getFirst();
            }
            return null;
        }

        public Element last(String key) {
            LinkedList l = (LinkedList)this.map.get(key);
            if (l != null) {
                return (Element)l.getLast();
            }
            return null;
        }

        public Element seek(Element current, boolean snext) {
            int idx;
            LinkedList l = (LinkedList)this.map.get(current.key);
            if (l != null && (idx = l.indexOf(current)) > -1) {
                idx = snext ? ++idx : --idx;
                if (idx > -1 && idx < l.size()) {
                    return (Element)l.get(idx);
                }
            }
            return null;
        }

        public void delete(Element e) {
            this.delete(e, null);
        }

        public void delete(Element e, String key) {
            LinkedList l;
            if (key == null) {
                key = e.key;
            }
            if ((l = (LinkedList)this.map.get(key)) != null) {
                l.remove(e);
                if (l.size() == 0) {
                    this.map.remove(key);
                }
            }
        }

        public void insertAfter(Element prev, Element e) {
            if (e.keyMatch(prev)) {
                LinkedList l = (LinkedList)this.map.get(prev.key);
                if (l != null) {
                    int n = l.indexOf(prev);
                    if (n > -1) {
                        l.add(n + 1, e);
                    } else {
                        l.addFirst(e);
                    }
                } else {
                    this.insertNew(e);
                }
            } else {
                this.insert(e);
            }
        }

        private void insertNew(Element e) {
            LinkedList<Element> l = new LinkedList<Element>();
            l.addFirst(e);
            this.map.put(e.key, l);
        }

        public void addAsFirst(Element e) {
            LinkedList l = (LinkedList)this.map.get(e.key);
            if (l != null) {
                l.addFirst(e);
            } else {
                this.insertNew(e);
            }
        }

        public void addAsLast(Element e) {
            LinkedList<Element> l = (LinkedList<Element>)this.map.get(e.key);
            if (l != null) {
                l.addLast(e);
            } else {
                l = new LinkedList<Element>();
                l.addLast(e);
                this.map.put(e.key, l);
            }
        }

        public void updateKey(Element e, String oldKey) {
            if (!e.keyMatch(oldKey)) {
                this.delete(e, oldKey);
                this.insert(e);
            }
        }

        private void insert(Element e) {
            LinkedList l = (LinkedList)this.map.get(e.key);
            if (l != null) {
                if (l.size() > 0) {
                    Element k = e.prev;
                    boolean found = false;
                    while (k != null) {
                        if (k.keyMatch(e)) {
                            int idx = l.indexOf(k);
                            if (idx <= -1) break;
                            l.add(idx + 1, e);
                            found = true;
                            break;
                        }
                        k = k.prev;
                    }
                    if (!found) {
                        l.addFirst(e);
                    }
                } else {
                    l.addFirst(e);
                }
            } else {
                this.insertNew(e);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName());
            sb.append(": ");
            Iterator i = this.map.values().iterator();
            while (i.hasNext()) {
                sb.append("[");
                LinkedList l = (LinkedList)i.next();
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    sb.append("<");
                    sb.append(i2.next());
                    sb.append("<");
                }
                sb.append("] ");
            }
            return sb.toString();
        }
    }

    final class SharedCursor
    implements IDataSharedCursor {
        private Cursor dc;

        SharedCursor(Cursor dc) {
            this.dc = dc;
        }

        public void home() throws DataException {
            this.dc.home();
            this.errorCheck();
        }

        public String getKey() throws DataException {
            if (this.dc.getElement() == null) {
                throw new DataException("BAC.0004.0012");
            }
            return this.errorCheck(this.dc.getKey());
        }

        public Object getValue() throws DataException {
            if (this.dc.getElement() == null) {
                throw new DataException("BAC.0004.0013");
            }
            return this.errorCheck(this.dc.getValue());
        }

        public Object getValueReference() throws DataException {
            if (this.dc.getElement() == null) {
                throw new DataException("BAC.0004.0014");
            }
            return this.errorCheck(this.dc.getValue());
        }

        public void setKey(String key) throws DataException {
            if (this.dc.getElement() == null) {
                throw new DataException("BAC.0004.0015");
            }
            this.dc.setKey(key);
            this.errorCheck();
        }

        public void setValue(Object value) throws DataException {
            if (this.dc.getElement() == null) {
                throw new DataException("BAC.0004.0015");
            }
            this.dc.setValue(value);
            this.errorCheck();
        }

        public boolean delete() throws DataException {
            if (this.dc.getElement() == null) {
                throw new DataException("BAC.0004.0015");
            }
            return this.errorCheck(this.dc.delete());
        }

        public void insertBefore(String key, Object value) throws DataException {
            this.dc.insertBefore(key, value);
            this.errorCheck();
        }

        public void insertAfter(String key, Object value) throws DataException {
            this.dc.insertAfter(key, value);
            this.errorCheck();
        }

        public IData insertDataBefore(String key) throws DataException {
            return this.errorCheck(this.dc.insertDataBefore(key));
        }

        public IData insertDataAfter(String key) throws DataException {
            return this.errorCheck(this.dc.insertDataAfter(key));
        }

        public boolean next() throws DataException {
            return this.errorCheck(this.dc.next());
        }

        public boolean previous() throws DataException {
            return this.errorCheck(this.dc.previous());
        }

        public boolean first() throws DataException {
            return this.errorCheck(this.dc.first());
        }

        public boolean last() throws DataException {
            return this.errorCheck(this.dc.last());
        }

        public boolean hasMoreData() throws DataException {
            return this.errorCheck(this.dc.hasMoreData());
        }

        public void destroy() {
            if (this.dc != null) {
                this.dc.destroy();
            }
            this.dc = null;
        }

        public IDataSharedCursor getCursorClone() throws DataException {
            return this.errorCheck(new SharedCursor((Cursor)this.dc.getCursorClone()));
        }

        public boolean first(String key) throws DataException {
            return this.errorCheck(this.dc.first(key));
        }

        public boolean last(String key) throws DataException {
            return this.errorCheck(this.dc.last(key));
        }

        public boolean next(String key) throws DataException {
            return this.errorCheck(this.dc.next(key));
        }

        public boolean previous(String key) throws DataException {
            return this.errorCheck(this.dc.previous(key));
        }

        public boolean isTXNSupported() {
            return false;
        }

        public ITransaction startTXN() throws TransactionException {
            throw new TransactionException("BAC.0003.0029");
        }

        public void txnJoin(ITransaction txn) throws TransactionException {
            throw new TransactionException("BAC.0003.0029");
        }

        public void txnAborted() {
        }

        public void txnCommitted() {
        }

        private boolean keyMatch(IDataCursor cc, String key) {
            String k = cc.getKey();
            return key == null && k == null || key != null && k != null && key.equals(k);
        }

        private boolean errorCheck(boolean ret) throws DataException {
            if (this.dc.hasMoreErrors()) {
                throw this.dc.getLastError();
            }
            return ret;
        }

        private IDataSharedCursor errorCheck(IDataSharedCursor ret) throws DataException {
            if (this.dc.hasMoreErrors()) {
                throw this.dc.getLastError();
            }
            return ret;
        }

        private IData errorCheck(IData ret) throws DataException {
            if (this.dc.hasMoreErrors()) {
                throw this.dc.getLastError();
            }
            return ret;
        }

        private String errorCheck(String ret) throws DataException {
            if (this.dc.hasMoreErrors()) {
                throw this.dc.getLastError();
            }
            return ret;
        }

        private Object errorCheck(Object ret) throws DataException {
            if (this.dc.hasMoreErrors()) {
                throw this.dc.getLastError();
            }
            return ret;
        }

        private void errorCheck() throws DataException {
            if (this.dc.hasMoreErrors()) {
                throw this.dc.getLastError();
            }
        }
    }

    final class Cursor
    implements IDataCursor {
        private Element now;

        Cursor(Element now) {
            this.init(now);
        }

        Element getElement() {
            return this.now;
        }

        void init(Element now) {
            this.now = now;
        }

        public void setErrorMode(int m) {
        }

        public DataException getLastError() {
            return null;
        }

        public boolean hasMoreErrors() {
            return false;
        }

        public void home() {
            this.now = null;
        }

        public String getKey() {
            if (this.now == null) {
                return null;
            }
            return this.now.key;
        }

        public Object getValue() {
            if (this.now == null) {
                return null;
            }
            return this.now.value;
        }

        public void setKey(String key) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0001.0060");
            }
            if (this.now != null) {
                String oldkey = this.now.key;
                this.now.key = key;
                if (MemData.this.index != null) {
                    MemData.this.index.updateKey(this.now, oldkey);
                }
            }
        }

        public void setValue(Object value) {
            if (this.now != null) {
                this.now.value = value;
            }
        }

        public boolean delete() {
            if (this.now == null) {
                return false;
            }
            Element tmp = this.now;
            boolean more = tmp.next != null;
            this.now = more ? tmp.next : tmp.prev;
            tmp.delete();
            return more;
        }

        public void insertBefore(String key, Object value) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0001.0060");
            }
            if (this.now != null) {
                this.now = this.now.insertBefore(key, value);
            } else {
                this.now = new Element(key, value);
                this.now.addAsFirst();
            }
        }

        public void insertAfter(String key, Object value) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0001.0060");
            }
            if (this.now != null) {
                this.now = this.now.insertAfter(key, value);
            } else {
                this.now = new Element(key, value);
                this.now.addAsLast();
            }
        }

        public IData insertDataBefore(String key) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0001.0060");
            }
            MemData nd = MemData.this.newInstance();
            this.insertBefore(key, nd);
            return nd;
        }

        public IData insertDataAfter(String key) {
            if (key == null) {
                throw new BasisRuntimeException("BAC.0001.0060");
            }
            MemData nd = MemData.this.newInstance();
            this.insertAfter(key, nd);
            return nd;
        }

        public boolean next() {
            if (this.now == null) {
                this.now = MemData.this.first;
            } else {
                if (this.now.next == null) {
                    return false;
                }
                this.now = this.now.next;
            }
            return this.now != null;
        }

        public boolean next(String key) {
            if (this.now == null) {
                return this.first(key);
            }
            Element next = this.now.next(key);
            if (next != null) {
                this.now = next;
                return true;
            }
            return false;
        }

        public boolean previous() {
            if (this.now == null) {
                this.now = MemData.this.last;
            } else {
                if (this.now.prev == null) {
                    return false;
                }
                this.now = this.now.prev;
            }
            return this.now != null;
        }

        public boolean previous(String key) {
            if (this.now == null) {
                return this.last(key);
            }
            Element prev = this.now.previous(key);
            if (prev != null) {
                this.now = prev;
                return true;
            }
            return false;
        }

        public boolean first() {
            this.now = MemData.this.first;
            return this.now != null;
        }

        public boolean first(String key) {
            if (MemData.this.first == null) {
                return false;
            }
            if (MemData.this.first.keyMatch(key)) {
                this.now = MemData.this.first;
                return true;
            }
            Element el = null;
            if (MemData.this.index != null) {
                el = MemData.this.index.first(key);
                if (el != null) {
                    this.now = el;
                    return true;
                }
                return false;
            }
            el = MemData.this.first.next(key);
            if (el != null) {
                this.now = el;
                return true;
            }
            return false;
        }

        public boolean last() {
            this.now = MemData.this.last;
            return this.now != null;
        }

        public boolean last(String key) {
            if (MemData.this.last == null) {
                return false;
            }
            if (MemData.this.last.keyMatch(key)) {
                this.now = MemData.this.last;
                return true;
            }
            Element el = null;
            if (MemData.this.index != null) {
                el = MemData.this.index.last(key);
                if (el != null) {
                    this.now = el;
                    return true;
                }
                return false;
            }
            el = MemData.this.last.previous(key);
            if (el != null) {
                this.now = el;
                return true;
            }
            return false;
        }

        public void destroy() {
        }

        public boolean hasMoreData() {
            if (this.now == null) {
                return MemData.this.first != null;
            }
            return this.now.next != null;
        }

        public IDataCursor getCursorClone() {
            Cursor ret = null;
            ret = new Cursor(this.now);
            return ret;
        }

        public String toString() {
            if (this.now == null) {
                return "Cursor:null";
            }
            return "Cursor:" + this.now.key;
        }
    }

    final class Element
    implements Serializable {
        static final long serialVersionUID = -3811989298497138477L;
        private Element prev;
        private Element next;
        private String key;
        private Object value;

        Element(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean delete() {
            MemData.this.size--;
            if (this.prev == null) {
                MemData.this.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next == null) {
                MemData.this.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
            if (MemData.this.index != null) {
                MemData.this.index.delete(this);
            }
            this.prev = null;
            return true;
        }

        public Element insertBefore(String key, Object value) {
            Element item = new Element(key, value);
            this.insertAfter(this.prev, item);
            return item;
        }

        public Element insertAfter(String key, Object value) {
            Element item = new Element(key, value);
            this.insertAfter(this, item);
            return item;
        }

        private void insertAfter(Element previous, Element element) {
            if (previous == null) {
                element.addAsFirst();
            } else if (previous == MemData.this.last) {
                element.addAsLast();
            } else {
                if (MemData.this.index != null) {
                    MemData.this.index.insertAfter(previous, element);
                }
                element.next = previous.next;
                element.prev = previous;
                previous.next = element;
                if (element.next != null) {
                    element.next.prev = element;
                }
                MemData.this.size++;
            }
        }

        void addAsLast() {
            if (MemData.this.size == 0) {
                MemData.this.first = this;
                MemData.this.last = this;
                this.next = null;
                this.prev = null;
                MemData.this.index = null;
            } else {
                if (MemData.this.last == null) {
                    throw new BasisRuntimeException("BAC.0001.0053", new String[]{"" + MemData.this.size});
                }
                if (MemData.this.index != null) {
                    MemData.this.index.addAsLast(this);
                }
                this.prev = MemData.this.last;
                this.next = null;
                ((MemData)MemData.this).last.next = this;
                MemData.this.last = this;
            }
            MemData.this.size++;
        }

        void addAsFirst() {
            if (MemData.this.size == 0) {
                MemData.this.first = this;
                MemData.this.last = this;
                this.next = null;
                this.prev = null;
                MemData.this.index = null;
            } else {
                if (MemData.this.first == null) {
                    throw new BasisRuntimeException("BAC.0001.0054", new String[]{"" + MemData.this.size});
                }
                if (MemData.this.index != null) {
                    MemData.this.index.addAsFirst(this);
                }
                this.prev = null;
                this.next = MemData.this.first;
                ((MemData)MemData.this).first.prev = this;
                MemData.this.first = this;
            }
            MemData.this.size++;
        }

        public boolean keyMatch(String k1) {
            if (this.key == k1) {
                return true;
            }
            return this.key.equals(k1);
        }

        public boolean keyMatch(Element e) {
            if (this.key == e.key) {
                return true;
            }
            return this.key.equals(e.key);
        }

        private boolean keyMatch(String k1, String k2) {
            if (k1 == k2) {
                return true;
            }
            if (k1 == null) {
                return false;
            }
            return k1.equals(k2);
        }

        public Element next(String skey) {
            if (MemData.this.index == null && MemData.this.useIndex()) {
                MemData.this.index = new MemDataIndex(MemData.this.first);
            }
            if (MemData.this.index != null && this.keyMatch(this.key, skey)) {
                return MemData.this.index.seek(this, true);
            }
            Element ne = this.next;
            while (ne != null) {
                if (this.keyMatch(ne.key, skey)) {
                    return ne;
                }
                ne = ne.next;
            }
            return null;
        }

        public Element previous(String skey) {
            if (MemData.this.index == null && MemData.this.useIndex()) {
                MemData.this.index = new MemDataIndex(MemData.this.first);
            }
            if (MemData.this.index != null && this.keyMatch(this.key, skey)) {
                return MemData.this.index.seek(this, false);
            }
            Element ne = this.prev;
            while (ne != null) {
                if (this.keyMatch(ne.key, skey)) {
                    return ne;
                }
                ne = ne.prev;
            }
            return null;
        }

        public String toString() {
            return this.key + ":" + this.value;
        }
    }
}

