/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.data;

import com.wm.util.BasisRuntimeException;
import java.util.Enumeration;

public final class IntHashtable
implements Cloneable {
    int threshold;
    float loadFactor;
    transient int count;
    transient Entry[] table;

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"" + initialCapacity + ":" + loadFactor});
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(int key) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Enumeration elements() {
        return new Enum();
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(int key, Object value) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        tab[index] = e = new Entry(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            IntHashtable t = (IntHashtable)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Entry[] tab = this.table;
        for (int i = 0; i <= this.count; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(Integer.toString(e.key));
                buf.append('=');
                buf.append(e.value.toString());
                e = e.next;
            }
        }
        buf.append("}");
        return buf.toString();
    }

    final class Enum
    implements Enumeration {
        int idx = 0;
        Entry pos;
        Entry[] tab;

        Enum() {
            this.tab = IntHashtable.this.table;
            this.next();
        }

        public boolean hasMoreElements() {
            return this.pos != null;
        }

        public Object nextElement() {
            Object v = this.pos.value;
            this.next();
            return v;
        }

        private void next() {
            if (this.pos != null) {
                this.pos = this.pos.next;
            }
            while (this.pos == null && this.idx < this.tab.length) {
                this.pos = this.tab[this.idx++];
            }
        }
    }

    final class Entry {
        int key;
        Object value;
        Entry next;

        public Entry(int key, Object val, Entry next) {
            this.key = key;
            this.value = val;
            this.next = next;
        }

        public Object clone() {
            Entry entry = new Entry(this.key, this.value, this.next != null ? (Entry)this.next.clone() : null);
            return entry;
        }
    }
}

