/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.data;

import com.wm.data.DataTreeCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.util.BasisRuntimeException;
import com.wm.util.codec.TextDataCodec;
import com.wm.util.data.IDataShellCommand;
import com.wm.util.data.MData;
import com.wm.util.data.MInteger;
import com.wm.util.io.Files;
import com.wm.util.text.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DataShell
implements Runnable {
    private IData data;
    private boolean shell;
    private boolean server;
    private InputStream in = System.in;
    private PrintStream out = System.out;
    private String nl = System.getProperty("line.separator");
    private Hashtable cmds = new Hashtable();
    private Hashtable newcmds = new Hashtable();
    private DataTreeCursor cursor;

    public static void main(String[] args) throws Exception {
        new DataShell(args, new MData()).run();
    }

    public void addCommand(String key, String desc, IDataShellCommand cmd) {
        this.newcmds.put(key, desc);
        this._addCommand(key, cmd);
    }

    public void setServer(boolean server) {
        this.server = server;
    }

    private void _addCommand(String key, IDataShellCommand cmd) {
        this.cmds.put(key, cmd);
    }

    private void _addCommand(String k1, String k2, IDataShellCommand cmd) {
        this.cmds.put(k1, cmd);
        this.cmds.put(k2, cmd);
    }

    public DataTreeCursor getCursor() {
        return this.cursor;
    }

    public synchronized void run() {
        this._addCommand("pe", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                if (DataShell.this.cursor.hasMoreErrors()) {
                    DataShell.this.cursor.getLastError().printStackTrace();
                }
                return 3;
            }
        });
        this._addCommand("vm", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                long mem = Runtime.getRuntime().totalMemory();
                long fre = Runtime.getRuntime().freeMemory();
                DataShell.this.println("System", System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
                DataShell.this.println("JVM", System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + "mem=" + mem / 1024L + "k " + "free=" + fre / 1024L + "k");
                return 3;
            }
        });
        this._addCommand("pk", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.println("key", DataShell.this.cursor.getKey());
                return 3;
            }
        });
        this._addCommand("pv", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.println("value", DataShell.this.cursor.getValue());
                return 3;
            }
        });
        this._addCommand("pwd", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.println("path", DataShell.this.cursor.getPath());
                return 3;
            }
        });
        this._addCommand("sk", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.cursor.setKey(args[0]);
                return 3;
            }
        });
        this._addCommand("sv", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.cursor.setValue(args[0]);
                return 3;
            }
        });
        this._addCommand("n", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.next() ? 1 : 2;
            }
        });
        this._addCommand("p", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.previous() ? 1 : 2;
            }
        });
        this._addCommand("f", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.first() ? 1 : 2;
            }
        });
        this._addCommand("l", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.last() ? 1 : 2;
            }
        });
        this._addCommand("ls", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.list(DataShell.this.cursor, false);
                return 3;
            }
        });
        this._addCommand("lsv", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.list(DataShell.this.cursor, true);
                return 3;
            }
        });
        this._addCommand("d", "delete", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.delete() ? 1 : 2;
            }
        });
        this._addCommand("cc", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.cursor.home();
                return 3;
            }
        });
        this._addCommand("cd", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.navigate(args[0]) ? 1 : 2;
            }
        });
        this._addCommand("cpi", new IDataShellCommand(){

            public int command(DataShell s, String[] args) throws Exception {
                File f = new File(args[0]);
                if (!f.exists()) {
                    return 2;
                }
                DataShell.this.cursor.insertAfter(args[1], Files.readFully(f));
                return 1;
            }
        });
        this._addCommand("dall", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                IDataCursor cc = DataShell.this.cursor.getCursorClone();
                cc.first();
                while (cc.delete()) {
                }
                cc.destroy();
                return 3;
            }
        });
        this._addCommand("ia", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.cursor.insertAfter(args[0], args[1]);
                return 3;
            }
        });
        this._addCommand("ib", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this.cursor.insertBefore(args[0], args[1]);
                return 3;
            }
        });
        this._addCommand("ida", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.insertDataAfter(args[0]) != null ? 1 : 2;
            }
        });
        this._addCommand("idb", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.insertDataBefore(args[0]) != null ? 1 : 2;
            }
        });
        this._addCommand("dexport", new IDataShellCommand(){

            public int command(DataShell s, String[] args) throws Exception {
                File f;
                File file = f = args.length > 1 ? new File(args[1]) : new File(".");
                if (f.exists() && f.isDirectory() && DataShell.this.cursor.navigate(args[0])) {
                    DataShell.this._export(f, DataShell.this.cursor);
                    return 1;
                }
                return 2;
            }
        });
        this._addCommand("dimport", new IDataShellCommand(){

            public int command(DataShell s, String[] args) throws Exception {
                boolean nav;
                File f = new File(args[0]);
                boolean bl = nav = args.length > 1 ? DataShell.this.cursor.navigate(args[1]) : true;
                if (nav && f.exists() && f.isDirectory()) {
                    DataShell.this._import(f, DataShell.this.cursor);
                    return 1;
                }
                return 2;
            }
        });
        this._addCommand("fexport", new IDataShellCommand(){

            public int command(DataShell s, String[] args) throws Exception {
                if (DataShell.this.cursor.navigate(args[0])) {
                    Files.write(new File(args[1]), TextDataCodec.encode(DataShell.this.cursor).getBytes());
                    return 1;
                }
                return 2;
            }
        });
        this._addCommand("fimport", new IDataShellCommand(){

            public int command(DataShell s, String[] args) throws Exception {
                if (args.length == 1 || DataShell.this.cursor.navigate(args[1])) {
                    TextDataCodec.decode(DataShell.this.cursor, new String(Files.readFully(new File(args[0]))));
                    return 1;
                }
                return 2;
            }
        });
        this._addCommand("tk", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.getKey().equals(args[0]) ? 1 : 2;
            }
        });
        this._addCommand("tv", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.getValue().equals(args[0]) ? 1 : 2;
            }
        });
        this._addCommand("dn", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.down() ? 1 : 2;
            }
        });
        this._addCommand("up", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return DataShell.this.cursor.up() ? 1 : 2;
            }
        });
        this._addCommand("bli", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                int i;
                int count = Integer.parseInt(args[0]);
                byte[] foo = new byte[Integer.parseInt(args[1])];
                for (i = 0; i < foo.length; ++i) {
                    foo[i] = (byte)(48 + i % 10);
                }
                for (i = 0; i < count; ++i) {
                    DataShell.this.cursor.insertAfter(Integer.toString(i), new String(foo));
                }
                return 3;
            }
        });
        this._addCommand("bi", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                int count = Integer.parseInt(args[0]);
                for (int i = 0; i < count; ++i) {
                    DataShell.this.cursor.insertAfter(Integer.toString(i), Long.toString(System.currentTimeMillis()));
                }
                return 3;
            }
        });
        this._addCommand("?", "help", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                DataShell.this._printHelp();
                return 3;
            }
        });
        this._addCommand("x", "exit", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                System.exit(1);
                return 4;
            }
        });
        this._addCommand("q", "quit", new IDataShellCommand(){

            public int command(DataShell s, String[] args) {
                return 4;
            }
        });
        try {
            this.println("DataShell", new Date());
            this.cursor = DataTreeCursor.create(this.data);
            this.cmd();
            if (!this.server) {
                this.in.close();
                this.out.close();
            }
            this.cursor.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DataShell(InputStream in, OutputStream out, IData data) throws IOException {
        this.data = data;
        this.server = false;
        out = new PrintStream(out);
        this.nl = "\r\n";
        new Thread(this).start();
    }

    public DataShell(String[] args, IData data) throws Exception {
        this.data = data;
        for (int i = 0; i < args.length; ++i) {
            i += this.processArg(args, args[i], i, args.length - i - 1);
        }
        this.server = true;
    }

    private void usage() {
        System.out.println("DataShell [-s]");
    }

    private String hdr(String hdr) {
        return Strings.lpad(hdr, ' ', 15);
    }

    private void print(String msg) {
        this.print("", msg);
    }

    private void println(String msg) {
        this.println("", msg);
    }

    public void print(String hdr, Object msg) {
        this.out.print(this.hdr(hdr) + " | " + msg);
    }

    public void println(String hdr, Object msg) {
        this.print(hdr, msg + this.nl);
    }

    protected int processArg(String[] args, String arg, int index, int left) throws Exception {
        if (arg.equals("-s") || arg.equals("--shell")) {
            this.shell = true;
            return 0;
        }
        return 0;
    }

    private void cmd() {
        DataTreeCursor c = this.cursor;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.in));
        String key = null;
        String cmd = null;
        boolean done = false;
        int line = 0;
        block11: while (!done) {
            try {
                block18: {
                    block17: {
                        IDataShellCommand CMD;
                        if (!this.shell) {
                            this.print("<" + key + ">", "");
                        }
                        String raw = in.readLine();
                        ++line;
                        if (this.shell) {
                            this.println("SHELL-CMD", "***** " + raw + " *****");
                        }
                        if (raw == null) break;
                        if (raw.length() == 0) continue;
                        StringTokenizer st = new StringTokenizer(raw);
                        cmd = st.nextToken();
                        Vector<Object> v = new Vector<Object>();
                        while (st.hasMoreTokens()) {
                            v.addElement(st.nextElement());
                        }
                        Object[] opt = null;
                        if (v.size() > 0) {
                            opt = new String[v.size()];
                            v.copyInto(opt);
                        }
                        if ((CMD = (IDataShellCommand)this.cmds.get(cmd)) == null) break block17;
                        switch (CMD.command(this, (String[])opt)) {
                            case 1: {
                                this.println("", "true");
                                break block18;
                            }
                            case 2: {
                                this.println("", "false");
                                break block18;
                            }
                            case 3: {
                                break block18;
                            }
                            case 4: {
                                done = true;
                                continue block11;
                            }
                            default: {
                                throw new BasisRuntimeException("BAC.0001.0032");
                            }
                        }
                    }
                    this.println("Unknown command: '" + cmd + "'");
                    continue;
                }
                if (c.hasMoreErrors()) {
                    throw c.getLastError();
                }
                key = c.getKey();
                if (!c.hasMoreErrors()) continue;
                key = null;
                c.getLastError();
            }
            catch (NullPointerException npe) {
                this.println("not enough arguments to '" + cmd + "' command.");
                npe.printStackTrace();
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                this.println("not enough arguments to '" + cmd + "' command.");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void _printHelp() {
        this.println("command line help:");
        this.println(" ?, h                  = this help message");
        this.println(" q                     = quit");
        this.println(" x                     = exit Java VM");
        this.println("-( cursor )-------------------------------------------------");
        this.println(" cc                    = clear cursor to home (unpositioned)");
        this.println(" cd <path>             = navigate with abs or rel path");
        this.println(" cpi <src> [dst]       = copy from local filesystem");
        this.println(" cpo <src> <dst>       = copy to local filesystem");
        this.println(" d                     = delete current");
        this.println(" f                     = first item in IData");
        this.println(" ib <key> <val>        = insert before");
        this.println(" ia <key> <val>        = insert after");
        this.println(" idb <key>             = insert data before <key>");
        this.println(" ida <key>             = insert data after <key>");
        this.println(" l                     = last item in IData");
        this.println(" n                     = next");
        this.println(" p                     = previous");
        this.println(" pk                    = print current key");
        this.println(" up                    = step 'up' out of IData");
        this.println(" dn                    = step 'down' into IData");
        this.println(" pv                    = print current value");
        this.println(" sk <key>              = set current key");
        this.println(" sv <value>            = set current value");
        this.println("-( utility )------------------------------------------------");
        this.println(" dall                  = delete all items in current dir");
        this.println(" dexport <src> [dst]   = export items to directory tree");
        this.println(" dimport <src> [dst]   = import items from directory tree");
        this.println(" fexport <src> <dst>   = export items to ascii file");
        this.println(" fimport <src> <dst>   = import items from ascii file");
        this.println(" ls                    = list all keys in dir");
        this.println(" lsv                   = list all keys and values in dir");
        this.println(" pwd                   = print tree path to current position");
        this.println(" tk <key>              = test for key equals <key>");
        this.println(" tv <key>              = test for value equals <key>");
        this.println("-( debug )--------------------------------------------------");
        this.println(" pe                    = print next error");
        this.println(" sync                  = clones cursor and calls destroy");
        this.println(" vm                    = print Java VM stats");
        this.println("-( macro )--------------------------------------------------");
        this.println(" bi <x>                = bulk insert x random items");
        this.println(" bli <x> <y>           = bulk insert x items of y bytes");
        if (this.newcmds.size() > 0) {
            this.println("-( custom )-------------------------------------------------");
            Enumeration e = this.newcmds.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                String d = (String)this.newcmds.get(k);
                this.println(Strings.rpad(" " + k, ' ', 24) + " = " + d);
            }
        }
    }

    private void list(IDataCursor c, boolean pv) {
        IDataCursor cc = c.getCursorClone();
        if (cc.first()) {
            int i = 1;
            do {
                this.println("#" + i++, pv ? cc.getKey() + " = " + cc.getValue() : cc.getKey());
            } while (cc.next());
        }
        cc.destroy();
    }

    private void _export(File f, IDataCursor c) throws IOException {
        if (c.first() && f.exists() && f.isDirectory()) {
            Hashtable<String, MInteger> store = new Hashtable<String, MInteger>();
            do {
                OutputStream os;
                String key = c.getKey();
                Object val = c.getValue();
                File nf = new File(f, key);
                MInteger num = (MInteger)store.get(key);
                if (num == null) {
                    num = new MInteger(0);
                    store.put(key, num);
                }
                int nval = num.getValue();
                this.println("export", nf);
                if (val instanceof IData) {
                    nf.mkdirs();
                    IDataCursor nc = ((IData)val).getCursor();
                    this._export(nf, nc);
                    nc.destroy();
                } else if (val instanceof byte[]) {
                    os = new FileOutputStream(nf);
                    ((FileOutputStream)os).write((byte[])val);
                    ((FileOutputStream)os).close();
                } else {
                    os = new ObjectOutputStream(new FileOutputStream(nf + (nval > 0 ? "#" + nval : "") + "~"));
                    ((ObjectOutputStream)os).writeObject(val);
                    ((ObjectOutputStream)os).close();
                }
                num.setValue(nval + 1);
            } while (c.next());
        }
    }

    private void _import(File f, IDataCursor c) throws IOException, ClassNotFoundException {
        if (f.exists() && f.isDirectory()) {
            String[] l = f.list();
            for (int i = 0; i < l.length; ++i) {
                Object data;
                File nf = new File(f, l[i]);
                if (nf.isDirectory()) {
                    IData d = c.insertDataAfter(l[i]);
                    IDataCursor dc = d.getCursor();
                    this._import(nf, dc);
                    dc.destroy();
                    continue;
                }
                if (!nf.isFile()) continue;
                if (l[i].endsWith("~")) {
                    l[i] = l[i].substring(0, l[i].length() - 1);
                    if (l[i].indexOf("#") > 0) {
                        l[i] = l[i].substring(0, l[i].indexOf("#"));
                    }
                    data = new ObjectInputStream(new FileInputStream(nf)).readObject();
                } else {
                    data = Files.readFully(nf);
                }
                this.println("import", nf);
                c.insertAfter(l[i], data);
            }
        }
    }
}

