/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.comm;

import com.wm.data.IData;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILink;
import com.wm.io.comm.ILinkListener;
import com.wm.io.comm.ILinkParameters;
import com.wm.io.comm.IMessage;
import com.wm.io.comm.IMessageHandler;
import com.wm.util.BasisRuntimeException;
import com.wm.util.pool.ThreadPool;
import com.wm.util.text.UUID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Connection {
    private static int poolMin = 10;
    private static int poolMax = 100;
    private static String MSG0023 = "BAC.0006.0023";
    private static String MSG0024 = "BAC.0006.0024";
    private static MultiReader mlr = null;
    private static ThreadPool threadPool = new ThreadPool(poolMin, poolMax, "Connection");
    private ILink link;
    private boolean poll;
    private Hashtable handleMsg;
    private Hashtable handleUUID;
    private Reader reader;
    private Thread readerThread;
    private IMessageHandler defHandle;
    private ILinkListener listener;

    public static synchronized void setThreadPoolBounds(int min, int max) {
        threadPool.setBounds(min, max);
    }

    public Connection(ILink link) {
        this(link, false);
    }

    public Connection(ILink link, boolean poll) {
        this.link = link;
        this.poll = poll;
        this.handleMsg = new Hashtable(11);
        this.handleUUID = new Hashtable(11);
    }

    public String toString() {
        return this.link + " (UUIDHandlers=" + this.handleUUID.size() + ":Msg Handlers=" + this.handleMsg.size() + ")";
    }

    public void handleLinkError(CommException err) {
        if (this.listener != null) {
            this.listener.linkError(err);
        }
    }

    public void handleMessage(IMessage msg) {
        if (this.defHandle != null) {
            this.defHandle.handleMessage(this.link, msg);
        }
    }

    public void setDefaultHandler(IMessageHandler mh) {
        this.defHandle = mh;
    }

    public void setLinkListener(ILinkListener cl) {
        this.listener = cl;
        this.link.setLinkListener(cl);
    }

    public ILinkParameters getLinkInfo() {
        return this.link.getLinkInfo();
    }

    public synchronized void setLinkReady() {
        if (this.reader != null) {
            return;
        }
        this.reader = new Reader();
        if (this.poll) {
            if (mlr == null) {
                mlr = new MultiReader();
                mlr.setDaemon(true);
                mlr.start();
            }
            mlr.add(this.reader);
        } else {
            this.readerThread = new Thread(this.reader);
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }
    }

    public IData sendReceive(String cmd, IData data) throws CommException {
        return this.waitReply(this.send(cmd, null, data), 0L).getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(String cmd, Properties prop, IData data) throws CommException {
        String uuid = UUID.generate();
        Hashtable hashtable = this.handleUUID;
        synchronized (hashtable) {
            this.handleUUID.put(uuid, new Request());
        }
        this.link.send(uuid, cmd, prop, data);
        return uuid;
    }

    public void send(String uuid, String cmd, Properties prop, IData data) throws CommException {
        this.link.send(uuid, cmd, prop, data);
    }

    public void handleSyncMsg(ILink lk, IMessage msg) {
        new PollRunner(lk, msg).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage waitReply(String uuid, long wait) throws CommException {
        Request mreq = null;
        IMessage msg = null;
        Hashtable hashtable = this.handleUUID;
        synchronized (hashtable) {
            mreq = (Request)this.handleUUID.get(uuid);
            if (mreq == null) {
                throw new BasisRuntimeException("BAC.0009.0031", new String[]{"uuid:" + uuid});
            }
        }
        msg = mreq.getData(wait);
        hashtable = this.handleUUID;
        synchronized (hashtable) {
            this.handleUUID.remove(uuid);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(String cmd, IMessageHandler handler) {
        Connection connection = this;
        synchronized (connection) {
            if (handler != null) {
                this.handleMsg.put(cmd, handler);
            } else {
                this.handleMsg.remove(cmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUUIDHandler(String uuid, IMessageHandler handler) {
        Connection connection = this;
        synchronized (connection) {
            if (handler != null) {
                this.handleUUID.put(uuid, handler);
            } else {
                this.handleUUID.remove(uuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        CommException err = new CommException(MSG0023);
        this.link.disconnect();
        Hashtable hashtable = this.handleUUID;
        synchronized (hashtable) {
            Enumeration enumvar = this.handleUUID.keys();
            while (enumvar.hasMoreElements()) {
                String uuid = (String)enumvar.nextElement();
                Request msg = (Request)this.handleUUID.get(uuid);
                msg.setError(err);
            }
        }
        this.reader.terminate();
        if (this.readerThread != null && this.readerThread.isAlive()) {
            this.readerThread.interrupt();
        }
        if (mlr != null) {
            mlr.remove(this.reader);
        }
        this.handleMsg.clear();
        this.handleUUID.clear();
    }

    public void runTarget(Runnable run) {
        threadPool.getThread().runTarget(run);
    }

    static final class Request
    implements IMessageHandler {
        private IMessage msg;
        private CommException err;

        Request() {
        }

        synchronized void setData(IMessage msg) {
            this.msg = msg;
            this.notifyAll();
        }

        synchronized void setError(CommException err) {
            this.err = err;
            this.notifyAll();
        }

        synchronized IMessage getData(long wait) throws CommException {
            if (this.msg == null && this.err == null) {
                try {
                    this.wait(wait);
                }
                catch (InterruptedException e) {
                    throw new CommException(MSG0024);
                }
            }
            if (this.err != null) {
                throw this.err;
            }
            return this.msg;
        }

        public void handleMessage(ILink conn, IMessage msg) {
            CommException err = msg.getError();
            if (err != null) {
                this.setError(err);
            } else {
                this.setData(msg);
            }
        }
    }

    static final class MultiReader
    extends Thread {
        private Vector readers = new Vector();

        MultiReader() {
        }

        public void add(Reader reader) {
            this.readers.addElement(reader);
        }

        public void remove(Reader reader) {
            this.readers.removeElement(reader);
        }

        public void run() {
            while (true) {
                int reads = 0;
                Enumeration e = this.readers.elements();
                while (e.hasMoreElements()) {
                    Reader lr = (Reader)e.nextElement();
                    if (!lr.done()) {
                        lr.readLink();
                        ++reads;
                        continue;
                    }
                    this.readers.removeElement(lr);
                }
                if (reads != 0) continue;
                try {
                    MultiReader.sleep(100L);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    final class Reader
    implements Runnable {
        boolean done = false;

        public void run() {
            while (!this.done && this.readLink()) {
            }
        }

        public boolean done() {
            return this.done;
        }

        public boolean readLink() {
            if (this.done) {
                return false;
            }
            try {
                IMessage msg = Connection.this.link.receive(Connection.this.poll);
                if (msg != null) {
                    Connection.this.runTarget(new PollRunner(msg));
                }
                return true;
            }
            catch (CommException e) {
                Connection.this.handleLinkError(e);
                return true;
            }
        }

        public void terminate() {
            this.done = true;
        }
    }

    final class PollRunner
    implements Runnable {
        private ILink mylink;
        private IMessage msg;

        public PollRunner(IMessage msg) {
            this(connection.link, msg);
        }

        public PollRunner(ILink lk, IMessage msg) {
            this.mylink = lk;
            this.msg = msg;
        }

        public void run() {
            try {
                String cmd = this.msg.getCommand();
                String uuid = this.msg.getUUID();
                IMessageHandler uuidrh = (IMessageHandler)Connection.this.handleUUID.get(uuid);
                if (uuidrh != null) {
                    uuidrh.handleMessage(this.mylink, this.msg);
                    return;
                }
                if (cmd == null) {
                    Connection.this.handleMessage(this.msg);
                    return;
                }
                IMessageHandler rh = (IMessageHandler)Connection.this.handleMsg.get(cmd);
                if (rh != null) {
                    rh.handleMessage(this.mylink, this.msg);
                    return;
                }
                Connection.this.handleMessage(this.msg);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

