/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.comm;

import com.wm.io.comm.CommException;
import com.wm.io.comm.ILink;
import com.wm.io.comm.ILinkFactory;
import com.wm.io.comm.ILinkParameters;
import com.wm.io.comm.ILinkServer;
import com.wm.util.comm.Connection;
import java.util.Enumeration;
import java.util.Hashtable;

public class CommFactory {
    private static Hashtable factories = new Hashtable();
    private static String BUNDLE = "com.wm.resources.CoreExcpMsgs";
    private static String MSG0021 = "BAC.0006.0021";
    private static String MSG0022 = "BAC.0006.0022";

    public static synchronized void registerFactory(String name, ILinkFactory cf) throws CommException {
        if (CommFactory.getFactory(name) != null) {
            throw new CommException(MSG0021, BUNDLE, new String[]{name});
        }
        factories.put(name, cf);
    }

    public static synchronized void deregisterFactory(String name) throws CommException {
        if (factories.remove(name) == null) {
            throw new CommException(MSG0022, BUNDLE, new String[]{name});
        }
    }

    public static synchronized ILinkFactory getFactory(String name) throws CommException {
        ILinkFactory cf = (ILinkFactory)factories.get(name);
        if (cf == null) {
            throw new CommException(MSG0022, BUNDLE, new String[]{name});
        }
        return cf;
    }

    public synchronized Enumeration listFactories() {
        return factories.keys();
    }

    public static synchronized ILinkServer startLinkServer(String factory, ILinkParameters lp) throws CommException {
        return CommFactory.getFactory(factory).startLinkServer(lp);
    }

    public static synchronized ILink openLink(String factory, ILinkParameters lp) throws CommException {
        return CommFactory.getFactory(factory).openLink(lp);
    }

    public static synchronized Connection openConnection(String factory, ILinkParameters lp) throws CommException {
        return new Connection(CommFactory.getFactory(factory).openLink(lp));
    }
}

