/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.IData;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.coder.IDataXMLCoder;
import com.wm.util.coder.InvalidDatatypeException;
import com.wm.util.coder.XMLCoder;
import com.wm.util.coder.resources.CoderExceptionBundle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XMLCoderWrapper {
    static final int TYPE_UNKNOWN = 0;
    static final int TYPE_XMLCODER = 1;
    static final int TYPE_IDATAXMLCODER = 2;
    static Name idataRootTag = Name.create("IDataXMLCoder");
    static Name valuesRootTag = Name.create("Values");
    static String fileEncoding = System.getProperty("file.encoding");
    int type = 0;
    XMLCoder xmlCoder;
    IDataXMLCoder idataCoder;
    Document doc = null;

    public int getFileType() {
        return this.type;
    }

    private void setFileType() throws WMDocumentException {
        if (this.doc == null) {
            this.type = 0;
        } else {
            Node root = this.doc.getFirstChildWm();
            while (root != null) {
                Name localName = root.getLocalNameWm();
                if (idataRootTag == localName) {
                    this.type = 2;
                    return;
                }
                if (valuesRootTag == localName) {
                    this.type = 1;
                    return;
                }
                root = this.doc.getNextSiblingOfChild(root);
            }
        }
        this.type = 0;
    }

    public IData decode(InputStream is) throws IOException, InvalidDatatypeException {
        byte[] bhdr = new byte[64];
        try {
            is = new BufferedInputStream(is, 64);
            is.mark(64);
            int i = is.read(bhdr);
            is.reset();
            String hdr = new String(bhdr, 0, i, "8859_1");
            String encoding = hdr.indexOf("encoding=\"UTF-8\"") != -1 ? "UTF8" : fileEncoding;
            this.doc = new Document(is, "XMLCoderFile", encoding, false, true);
            this.setFileType();
            if (this.type == 1) {
                this.xmlCoder = new XMLCoder(true);
                return this.xmlCoder.decode(this.doc);
            }
            if (this.type == 2) {
                this.idataCoder = new IDataXMLCoder();
                return this.idataCoder.decode(this.doc);
            }
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.XMLCODERWRAPPER_FILE, "");
        }
        catch (WMDocumentException e) {
            throw new InvalidDatatypeException(e.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        String xmlEncoded = "<?xml version='1.0' encoding='UTF-8'?>\n\n<Values version=\"2.0\">\n  <value name=\"testString\">testStringValue</value>\n  <array name=\"testStringList\" type=\"value\" depth=\"1\">\n    <value>testStringListValue1</value>\n    <value>testStringListValue2</value>\n    <value>testStringListValue3</value>\n    <value></value>\n  </array>\n  <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n    <array type=\"value\" depth=\"1\">\n      <value>1</value>\n      <value>11</value>\n      <value>21</value>\n    </array>\n    <array type=\"value\" depth=\"1\">\n      <value>2</value>\n      <value>12</value>\n      <value>22</value>\n    </array>\n    <array type=\"value\" depth=\"1\">\n      <value>3</value>\n      <value>13</value>\n      <value>23</value>\n    </array>\n    <array type=\"value\" depth=\"1\">\n      <value>4</value>\n      <value>14</value>\n      <value>24</value>\n    </array>\n  </array>\n  <record name=\"pipeline\" javaclass=\"com.wm.util.Values\">\n    <value name=\"testString\">testStringValue</value>\n    <array name=\"testStringList\" type=\"value\" depth=\"1\">\n      <value>testStringListValue1</value>\n      <value>testStringListValue2</value>\n      <value>testStringListValue3</value>\n      <value></value>\n    </array>\n    <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n      <array type=\"value\" depth=\"1\">\n        <value>1</value>\n        <value>11</value>\n        <value>21</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>2</value>\n        <value>12</value>\n        <value>22</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>3</value>\n        <value>13</value>\n        <value>23</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>4</value>\n        <value>14</value>\n        <value>24</value>\n      </array>\n    </array>\n    <record name=\"testRecord\" javaclass=\"com.wm.util.Values\">\n      <value name=\"testString\">testStringValue</value>\n      <array name=\"testStringList\" type=\"value\" depth=\"1\">\n        <value>testStringListValue1</value>\n        <value>testStringListValue2</value>\n        <value>testStringListValue3</value>\n        <value></value>\n      </array>\n      <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n        <array type=\"value\" depth=\"1\">\n          <value>1</value>\n          <value>11</value>\n          <value>21</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>2</value>\n          <value>12</value>\n          <value>22</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>3</value>\n          <value>13</value>\n          <value>23</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>4</value>\n          <value>14</value>\n          <value>24</value>\n        </array>\n      </array>\n    </record>\n  </record>\n  <value name=\"fileName\">flow_save_restore_pipe.xml</value>\n</Values>\n";
        String xmlUtf8Encoded = "<?xml version='1.0'?>\n\n<Values version=\"2.0\">\n  <value name=\"testString\">testStringValue</value>\n  <array name=\"testStringList\" type=\"value\" depth=\"1\">\n    <value>testStringListValue1</value>\n    <value>testStringListValue2</value>\n    <value>testStringListValue3</value>\n    <value></value>\n  </array>\n  <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n    <array type=\"value\" depth=\"1\">\n      <value>1</value>\n      <value>11</value>\n      <value>21</value>\n    </array>\n    <array type=\"value\" depth=\"1\">\n      <value>2</value>\n      <value>12</value>\n      <value>22</value>\n    </array>\n    <array type=\"value\" depth=\"1\">\n      <value>3</value>\n      <value>13</value>\n      <value>23</value>\n    </array>\n    <array type=\"value\" depth=\"1\">\n      <value>4</value>\n      <value>14</value>\n      <value>24</value>\n    </array>\n  </array>\n  <record name=\"pipeline\" javaclass=\"com.wm.util.Values\">\n    <value name=\"testString\">testStringValue</value>\n    <array name=\"testStringList\" type=\"value\" depth=\"1\">\n      <value>testStringListValue1</value>\n      <value>testStringListValue2</value>\n      <value>testStringListValue3</value>\n      <value></value>\n    </array>\n    <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n      <array type=\"value\" depth=\"1\">\n        <value>1</value>\n        <value>11</value>\n        <value>21</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>2</value>\n        <value>12</value>\n        <value>22</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>3</value>\n        <value>13</value>\n        <value>23</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>4</value>\n        <value>14</value>\n        <value>24</value>\n      </array>\n    </array>\n    <record name=\"testRecord\" javaclass=\"com.wm.util.Values\">\n      <value name=\"testString\">testStringValue</value>\n      <array name=\"testStringList\" type=\"value\" depth=\"1\">\n        <value>testStringListValue1</value>\n        <value>testStringListValue2</value>\n        <value>testStringListValue3</value>\n        <value></value>\n      </array>\n      <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n        <array type=\"value\" depth=\"1\">\n          <value>1</value>\n          <value>11</value>\n          <value>21</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>2</value>\n          <value>12</value>\n          <value>22</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>3</value>\n          <value>13</value>\n          <value>23</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>4</value>\n          <value>14</value>\n          <value>24</value>\n        </array>\n      </array>\n    </record>\n  </record>\n  <value name=\"fileName\">flow_save_restore_pipe.xml</value>\n</Values>\n";
        String idataEncoded = "<?xml version='1.0' encoding='UTF-8'?>\n\n<IDataXMLCoder version=\"1.0\">\n  <record javaclass=\"com.wm.data.BasicData\">\n    <value name=\"testString\">testStringValue</value>\n    <array name=\"testStringList\" type=\"value\" depth=\"1\">\n      <value>testStringListValue1</value>\n      <value>testStringListValue2</value>\n      <value>testStringListValue3</value>\n      <value></value>\n    </array>\n    <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n      <array type=\"value\" depth=\"1\">\n        <value>1</value>\n        <value>11</value>\n        <value>21</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>2</value>\n        <value>12</value>\n        <value>22</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>3</value>\n        <value>13</value>\n        <value>23</value>\n      </array>\n      <array type=\"value\" depth=\"1\">\n        <value>4</value>\n        <value>14</value>\n        <value>24</value>\n      </array>\n    </array>\n    <record name=\"pipeline\" javaclass=\"com.wm.data.BasicData\">\n      <value name=\"testString\">testStringValue</value>\n      <array name=\"testStringList\" type=\"value\" depth=\"1\">\n        <value>testStringListValue1</value>\n        <value>testStringListValue2</value>\n        <value>testStringListValue3</value>\n        <value></value>\n      </array>\n      <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n        <array type=\"value\" depth=\"1\">\n          <value>1</value>\n          <value>11</value>\n          <value>21</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>2</value>\n          <value>12</value>\n          <value>22</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>3</value>\n          <value>13</value>\n          <value>23</value>\n        </array>\n        <array type=\"value\" depth=\"1\">\n          <value>4</value>\n          <value>14</value>\n          <value>24</value>\n        </array>\n      </array>\n      <record name=\"testRecord\" javaclass=\"com.wm.data.BasicData\">\n        <value name=\"testString\">testStringValue</value>\n        <array name=\"testStringList\" type=\"value\" depth=\"1\">\n          <value>testStringListValue1</value>\n          <value>testStringListValue2</value>\n          <value>testStringListValue3</value>\n          <value></value>\n        </array>\n        <array name=\"testStringTable\" type=\"value\" depth=\"2\">\n          <array type=\"value\" depth=\"1\">\n            <value>1</value>\n            <value>11</value>\n            <value>21</value>\n          </array>\n          <array type=\"value\" depth=\"1\">\n            <value>2</value>\n            <value>12</value>\n            <value>22</value>\n          </array>\n          <array type=\"value\" depth=\"1\">\n            <value>3</value>\n            <value>13</value>\n            <value>23</value>\n          </array>\n          <array type=\"value\" depth=\"1\">\n            <value>4</value>\n            <value>14</value>\n            <value>24</value>\n          </array>\n        </array>\n      </record>\n    </record>\n    <value name=\"fileName\">\temp\flow_save_restore_pipe.xml</value>\n  </record>\n</IDataXMLCoder>\n";
        XMLCoderWrapper c = new XMLCoderWrapper();
        System.err.println(xmlEncoded);
        ByteArrayInputStream data = new ByteArrayInputStream(xmlEncoded.getBytes());
        System.err.println(c.decode(data));
        System.err.println(xmlUtf8Encoded);
        data = new ByteArrayInputStream(xmlUtf8Encoded.getBytes("UTF8"));
        System.err.println(c.decode(data));
        System.err.println(idataEncoded);
        data = new ByteArrayInputStream(idataEncoded.getBytes("UTF8"));
        System.err.println(c.decode(data));
    }
}

