/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

public class XMLCoderHelper {
    protected static int ENCODED_CHARS_LIST_COUNT = 3;
    protected static int MAX_ESCAPE_ENCODE_LEN = 10;
    protected static String[][] encodeChars = new String[][]{{"\"", "quote"}, {">", "gt"}, {"<", "lt"}};

    public static String encodeString(String inStr) {
        if (inStr == null) {
            return inStr;
        }
        StringBuffer buf = new StringBuffer();
        try {
            buf = new StringBuffer(inStr.length());
            for (int i = 0; i < inStr.length(); ++i) {
                char strChar = inStr.charAt(i);
                boolean bReplace = false;
                String encodeReplaceStr = null;
                for (int j = 0; j < ENCODED_CHARS_LIST_COUNT; ++j) {
                    char encodeChar = encodeChars[j][0].charAt(0);
                    if (strChar != encodeChar) continue;
                    bReplace = true;
                    encodeReplaceStr = encodeChars[j][1];
                }
                if (bReplace) {
                    buf.append("&");
                    buf.append(encodeReplaceStr);
                    buf.append(";");
                    continue;
                }
                buf.append(inStr.charAt(i));
            }
            return buf.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return inStr;
        }
    }

    public static String decodeString(String inStr) {
        if (inStr == null) {
            return inStr;
        }
        if (inStr.indexOf("&") < 0) {
            return inStr;
        }
        StringBuffer buf = new StringBuffer(inStr);
        try {
            int pos = 0;
            while ((pos = XMLCoderHelper.bufferIndexOf(buf, 38, pos++)) >= 0) {
                int epos = XMLCoderHelper.bufferIndexOf(buf, 59, pos + 1);
                if (epos < 0 || epos > pos + MAX_ESCAPE_ENCODE_LEN) {
                    return buf.toString();
                }
                String extractedStr = buf.substring(pos + 1, epos);
                boolean bFound = false;
                for (int i = 0; i < ENCODED_CHARS_LIST_COUNT && !bFound; ++i) {
                    if (!extractedStr.equalsIgnoreCase(encodeChars[i][1])) continue;
                    String replaceStr = buf.substring(pos, epos + 1);
                    buf.replace(pos, epos + 1, encodeChars[i][0]);
                    bFound = true;
                }
                if (bFound) continue;
                ++pos;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return inStr;
        }
        return buf.toString();
    }

    public static int bufferIndexOf(StringBuffer stringBuff, int matchChar, int startPos) {
        for (int i = startPos; i < stringBuff.length(); ++i) {
            char bufChar = stringBuff.charAt(i);
            if (bufChar != matchChar) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] args) {
        String testString = "Quote\"Greater>Than\"Less<Than";
        System.out.println("testString=" + testString);
        String encStr = XMLCoderHelper.encodeString(testString);
        System.out.println("encStr=" + encStr);
        String decStr = XMLCoderHelper.decodeString(encStr);
        System.out.println("decStr=" + decStr);
    }
}

