/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.EncodingNames;
import com.wm.util.List;
import com.wm.util.Name;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.Codable;
import com.wm.util.coder.Coder;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.InvalidDatatypeException;
import com.wm.util.coder.StringCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.coder.XMLCoderHelper;
import com.wm.util.coder.resources.CoderExceptionBundle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class XMLCoder
extends Coder {
    static final double version = 2.0;
    static Name recordTag = Name.create("record");
    static Name arrayTag = Name.create("array");
    static Name floatTag = Name.create("float");
    static Name doubleTag = Name.create("double");
    static Name numberTag = Name.create("number");
    static Name dateTag = Name.create("date");
    static Name CharacterTag = Name.create("Character");
    static Name BooleanTag = Name.create("Boolean");
    static Name valueTag = Name.create("value");
    static Name listTag = Name.create("list");
    static Name nullTag = Name.create("null");
    static Name byteTag = Name.create("byte");
    static Name objectTag = Name.create("object");
    static String fileEncoding = System.getProperty("file.encoding");
    Name rootTag;
    String ctype = "text/xml";
    boolean pretty = true;
    boolean useOIDs = false;
    boolean useXMLHeader = true;
    boolean first = true;
    boolean ignoreInvalid = true;
    boolean useUTF8 = false;
    Hashtable hash;
    int nextID = 0;
    int nest = 0;
    double cVersion;
    public static final String NUMBER_NAN = "NaN";
    public static final String NUMBER_NEGATIVE_INFINITY = "-Infinity";
    public static final String NUMBER_POSITIVE_INFINITY = "Infinity";

    public XMLCoder() {
        this(true);
    }

    public XMLCoder(boolean utf8) {
        this.setRootTag("Values");
        this.useUTF8 = utf8;
        fileEncoding = EncUtil.getFileEncoding();
    }

    public void setUseXMLHeader(boolean use) {
        this.useXMLHeader = use;
    }

    public void setUseOIDs(boolean use) {
        this.useOIDs = use;
    }

    public void setUseUTF8(boolean use) {
        this.useUTF8 = use;
    }

    public void setIgnoreInvalid(boolean ignore) {
        this.ignoreInvalid = ignore;
    }

    public void setRootTag(String tag) {
        this.rootTag = Name.create(tag);
    }

    String getHeader() {
        if (this.useUTF8) {
            return Strings.cat(this.useXMLHeader ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" : "", "\n\n<", this.rootTag.toString(), " version=\"", Double.toString(2.0), "\">\n");
        }
        return Strings.cat(this.useXMLHeader ? "<?xml version=\"1.0\"?>" : "", "\n\n<", this.rootTag.toString(), " version=\"", Double.toString(2.0), "\">\n");
    }

    String getFooter() {
        return Strings.cat("</", this.rootTag.toString(), ">\n");
    }

    public void setContentType(String ctype) {
        this.ctype = ctype;
    }

    public String getContentType() {
        return this.ctype;
    }

    public void encode(OutputStream os, Values data) throws IOException, InvalidDatatypeException {
        this.cVersion = 2.0;
        this.first = true;
        this.hash = new Hashtable();
        if (data == null) {
            data = new Values();
        }
        OutputStreamWriter stream = this.useUTF8 ? new OutputStreamWriter(os, "UTF8") : new OutputStreamWriter(os, fileEncoding);
        stream.write(this.getHeader());
        this.doEncode(stream, null, data);
        stream.write(this.getFooter());
        ((Writer)stream).flush();
    }

    public Values decode(InputStream is) throws IOException, InvalidDatatypeException {
        Node root;
        this.hash = new Hashtable();
        Document doc = null;
        try {
            byte[] bhdr = new byte[64];
            is = new BufferedInputStream(is, 64);
            is.mark(64);
            int i = is.read(bhdr);
            is.reset();
            String encoding = null;
            if (i > 0) {
                String hdr = new String(bhdr, 0, i, "8859_1");
                encoding = EncUtil.getDocEncoding(hdr.toCharArray(), true);
            }
            if ((root = (doc = new Document(is, null, encoding = encoding == null ? "UTF8" : EncodingNames.getJavaName(encoding), false, true)).getFirstChildWm()) == null) {
                throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.XMLCODER_ROOTFULL, "");
            }
            while (this.rootTag != root.getLocalNameWm()) {
                Node newRoot = doc.getNextSiblingOfChild(root);
                if (newRoot == null) {
                    Object[] subs = new String[]{this.rootTag.toString(), root.getLocalNameWm() == null ? "null" : root.getLocalNameWm().toString(), root.toString()};
                    throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.XMLCODER_ROOTTAG, "", subs);
                }
                root = newRoot;
            }
            String sVersion = root.getAttributeValue(null, Name.create("version"));
            this.cVersion = sVersion == null ? 1.0 : new Double(sVersion);
        }
        catch (WMDocumentException e) {
            throw new InvalidDatatypeException(e.toString());
        }
        return (Values)this.doRecordDecode((ElementNode)root, true, null);
    }

    public Values decode(Document doc) throws IOException, InvalidDatatypeException {
        Node root;
        this.hash = new Hashtable();
        try {
            root = doc.getFirstChildWm();
            if (root == null) {
                throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.XMLCODER_ROOTFULL, "");
            }
            while (this.rootTag != root.getLocalNameWm()) {
                Node newRoot = doc.getNextSiblingOfChild(root);
                if (newRoot == null) {
                    Object[] subs = new String[]{this.rootTag.toString(), root.getLocalNameWm().toString(), root.toString()};
                    throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.XMLCODER_ROOTTAG, "", subs);
                }
                root = newRoot;
            }
            String sVersion = root.getAttributeValue(null, Name.create("version"));
            this.cVersion = sVersion == null ? 1.0 : new Double(sVersion);
        }
        catch (WMDocumentException e) {
            throw new InvalidDatatypeException(e.toString());
        }
        return (Values)this.doRecordDecode((ElementNode)root, true, null);
    }

    boolean inHash(Writer stream, Object o, String name) throws IOException {
        if (!this.useOIDs || o == null) {
            return false;
        }
        Integer wo = (Integer)this.hash.get(o);
        if (wo == null) {
            this.hash.put(o, new Integer(this.nextID++));
            return false;
        }
        stream.write(Strings.cat(this.pad(this.nest + 1), "<" + objectTag.toString(), this.name("idref", wo.toString()), this.name("name", name), "/>", this.pretty ? "\n" : ""));
        return true;
    }

    String pad(int len) {
        if (!this.pretty) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    String name(String attr, String val) {
        if (val != null) {
            return Strings.cat(" ", attr, "=\"", val, "\"");
        }
        return "";
    }

    String openTag(Name type, String name, Object o, String javaclass) {
        String depth = null;
        String subtype = null;
        String oid = null;
        boolean value = false;
        if (this.useOIDs) {
            Integer i = (Integer)this.hash.get(o);
            if (i == null) {
                i = new Integer(this.nextID++);
                this.hash.put(o, i);
            }
            oid = i.toString();
        }
        if (o instanceof String) {
            value = true;
        } else if (o instanceof String[]) {
            subtype = valueTag.toString();
            depth = "1";
        } else if (o instanceof String[][]) {
            subtype = valueTag.toString();
            depth = "2";
        } else if (o instanceof Values[]) {
            subtype = recordTag.toString();
            depth = "1";
        } else if (o instanceof IData[]) {
            subtype = recordTag.toString();
            depth = "1";
        } else if (o instanceof ValuesCodable[]) {
            subtype = recordTag.toString();
            depth = "1";
        } else if (o instanceof IDataCodable[]) {
            subtype = recordTag.toString();
            depth = "1";
        } else if (o instanceof IDataPortable[]) {
            subtype = recordTag.toString();
            depth = "1";
        } else if (o instanceof Object[]) {
            int len = ((Object[])o).length;
            Class firstNonNullClass = Object.class;
            for (int i = 0; i < len; ++i) {
                if (((Object[])o)[i] == null) continue;
                firstNonNullClass = ((Object[])o)[i].getClass();
                break;
            }
            boolean same = true;
            if (firstNonNullClass == Object.class) {
                same = false;
            } else {
                for (int i = 0; i < len && (((Object[])o)[i] == null || (same = firstNonNullClass.isInstance(((Object[])o)[i]))); ++i) {
                }
            }
            if (!same) {
                subtype = objectTag.toString();
                depth = "1";
            } else {
                if (o instanceof Boolean[] || o instanceof Character[] || o instanceof Date[] || o instanceof Number[] || o instanceof Vector[]) {
                    subtype = objectTag.toString();
                    depth = "1";
                    try {
                        javaclass = firstNonNullClass.getName();
                    }
                    catch (Exception cce) {
                        javaclass = null;
                    }
                } else {
                    subtype = valueTag.toString();
                }
                depth = "1";
            }
        } else if (o instanceof Number) {
            String s = o.getClass().getName();
            subtype = s.substring(s.lastIndexOf(46) + 1);
            value = true;
        } else if (o instanceof Date) {
            value = true;
        } else if (o instanceof Boolean) {
            value = true;
        } else if (o instanceof Character) {
            value = true;
        }
        String tag = Strings.cat(type.toString(), this.name("name", name), this.name("type", subtype), this.name("depth", depth), this.name("id", oid), this.name("javaclass", javaclass));
        return Strings.cat(this.pretty ? this.pad(++this.nest) : "", "<", tag, ">", this.pretty && !value ? "\n" : "");
    }

    String closeTag(Name type) {
        return this.closeTag(type, this.pretty);
    }

    String closeTag(Name type, boolean pad) {
        String s = Strings.cat(pad ? this.pad(this.nest) : "", "</", type.toString(), ">", this.pretty ? "\n" : "");
        --this.nest;
        return s;
    }

    void doEncode(Writer stream, String name, Object data) throws IOException {
        if (this.inHash(stream, data, name)) {
            return;
        }
        name = XMLCoderHelper.encodeString(name);
        if (data == null) {
            stream.write(Strings.cat(this.pad(this.nest + 1), "<", nullTag.toString(), name != null ? Strings.cat(" name=\"", name, "\"") : "", "/>", this.pretty ? "\n" : ""));
            return;
        }
        if (data instanceof ValuesCodable) {
            data = ((ValuesCodable)data).getValues();
        }
        if (data instanceof StringCodable) {
            data = ((StringCodable)data).getValue();
        }
        if (!(data instanceof Codable) && !(data instanceof ValuesCodable)) {
            if (data instanceof IDataCodable) {
                data = Values.use(((IDataCodable)data).getIData());
            } else if (data instanceof IData) {
                data = Values.use((IData)data);
            } else if (data instanceof IDataPortable) {
                data = Values.use(((IDataPortable)data).getAsData());
            }
        }
        if (data instanceof Values) {
            boolean doTag = !this.first;
            this.first = false;
            if (doTag) {
                stream.write(this.openTag(recordTag, name, data, data.getClass().getName()));
            }
            IData idata = ((Values)data).getIData();
            IDataCursor cur = idata.getCursor();
            while (cur.next()) {
                String k = cur.getKey();
                Object v = cur.getValue();
                v = Values.wrapIData(v);
                this.doEncode(stream, k, v);
            }
            if (doTag) {
                stream.write(this.closeTag(recordTag));
            }
        } else if (data instanceof Codable) {
            stream.write(this.openTag(recordTag, name, data, data.getClass().getName()));
            String[] k = ((Codable)data).getValueKeys();
            for (int i = 0; i < k.length; ++i) {
                this.doEncode(stream, k[i], ((Codable)data).getValue(k[i]));
            }
            stream.write(this.closeTag(recordTag));
        } else if (data instanceof Vector) {
            stream.write(this.openTag(listTag, name, data, null));
            for (int i = 0; i < ((Vector)data).size(); ++i) {
                this.doEncode(stream, null, ((Vector)data).elementAt(i));
            }
            stream.write(this.closeTag(listTag));
        } else if (data instanceof Float) {
            stream.write(this.openTag(floatTag, name, data, null));
            stream.write(((Float)data).toString());
            stream.write(this.closeTag(floatTag, false));
        } else if (data instanceof Double) {
            stream.write(this.openTag(doubleTag, name, data, null));
            stream.write(((Double)data).toString());
            stream.write(this.closeTag(doubleTag, false));
        } else if (data instanceof Number) {
            stream.write(this.openTag(numberTag, name, data, null));
            stream.write(((Number)data).toString());
            stream.write(this.closeTag(numberTag, false));
        } else if (data instanceof Date) {
            stream.write(this.openTag(dateTag, name, data, null));
            stream.write(((Date)data).toString());
            stream.write(this.closeTag(dateTag, false));
        } else if (data instanceof Character) {
            stream.write(this.openTag(CharacterTag, name, data, null));
            Character Cha = (Character)data;
            char ch = Cha.charValue();
            if (ch == '<') {
                stream.write("&lt;");
            } else if (ch == '>') {
                stream.write("&gt;");
            } else if (ch == '&') {
                stream.write("&amp;");
            } else {
                stream.write(Cha.toString());
            }
            stream.write(this.closeTag(CharacterTag, false));
        } else if (data instanceof Boolean) {
            stream.write(this.openTag(BooleanTag, name, data, null));
            stream.write(((Boolean)data).toString());
            stream.write(this.closeTag(BooleanTag, false));
        } else if (data instanceof String) {
            stream.write(this.openTag(valueTag, name, data, null));
            String dStr = (String)data;
            int iLength = dStr.length();
            for (int i = 0; i < iLength; ++i) {
                char ch = dStr.charAt(i);
                if (ch == '<') {
                    stream.write("&lt;");
                    continue;
                }
                if (ch == '>') {
                    stream.write("&gt;");
                    continue;
                }
                if (ch == '&') {
                    stream.write("&amp;");
                    continue;
                }
                stream.write(ch);
            }
            stream.write(this.closeTag(valueTag, false));
        } else if (data instanceof byte[]) {
            stream.write(this.openTag(byteTag, name, data, null));
            byte[] ba2 = Base64.encode((byte[])data, false);
            String tmp = new String(ba2);
            stream.write(tmp);
            stream.write(this.closeTag(byteTag));
        } else if (data instanceof Object[]) {
            stream.write(this.openTag(arrayTag, name, data, null));
            Object[] oArray = (Object[])data;
            int iLength = oArray.length;
            for (int i = 0; i < iLength; ++i) {
                this.doEncode(stream, null, oArray[i]);
            }
            stream.write(this.closeTag(arrayTag));
        } else {
            if (!this.ignoreInvalid) {
                throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_ENCODING, "", data.getClass().getName());
            }
            return;
        }
    }

    public String doStringDecode(ElementNode e) throws IOException, WMDocumentException {
        return (String)this.putHash(e.getText(), e);
    }

    public Boolean doBooleanDecode(ElementNode e) throws IOException {
        Boolean b = null;
        try {
            b = new Boolean(e.getText());
        }
        catch (Throwable t) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_1, "", t.toString());
        }
        return (Boolean)this.putHash(b, e);
    }

    private Object doBytesDecode(ElementNode ne) throws IOException, WMDocumentException {
        byte[] b = null;
        String tmp = this.doStringDecode(ne);
        b = tmp.getBytes();
        b = Base64.decode(b);
        return b;
    }

    public Character doCharacterDecode(ElementNode e) throws IOException {
        Character C = null;
        try {
            C = new Character(e.getText().charAt(0));
        }
        catch (Throwable t) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_1, "", t.toString());
        }
        return (Character)this.putHash(C, e);
    }

    public Date doDateDecode(ElementNode e) throws IOException {
        Date dt = null;
        try {
            String format = "EEE MMM dd HH:mm:ss z yyyy";
            SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
            Object[] sig = new Object[]{e.getText()};
            dt = df.parse((String)sig[0]);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", "date");
        }
        return (Date)this.putHash(dt, e);
    }

    private Number doFloatDecode(ElementNode e) throws IOException {
        Float n;
        String type = this.attribute(e, "type");
        try {
            String floatStr = e.getText();
            n = floatStr.equals(NUMBER_NAN) ? new Float(Float.NaN) : (floatStr.equals(NUMBER_NEGATIVE_INFINITY) ? new Float(Float.NEGATIVE_INFINITY) : (floatStr.equals(NUMBER_POSITIVE_INFINITY) ? new Float(Float.POSITIVE_INFINITY) : new Float(floatStr)));
        }
        catch (Exception ex) {
            Object[] subs = new String[]{type, ex.toString()};
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING, "", subs);
        }
        return (Number)this.putHash(n, e);
    }

    private Number doDoubleDecode(ElementNode e) throws IOException {
        Double n;
        String type = this.attribute(e, "type");
        try {
            String doubleStr = e.getText();
            n = doubleStr.equals(NUMBER_NAN) ? new Double(Double.NaN) : (doubleStr.equals(NUMBER_NEGATIVE_INFINITY) ? new Double(Double.NEGATIVE_INFINITY) : (doubleStr.equals(NUMBER_POSITIVE_INFINITY) ? new Double(Double.POSITIVE_INFINITY) : new Double(doubleStr)));
        }
        catch (Exception ex) {
            Object[] subs = new String[]{type, ex.toString()};
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING, "", subs);
        }
        return (Number)this.putHash(n, e);
    }

    public Number doNumberDecode(ElementNode e) throws IOException {
        Number n;
        String type = this.attribute(e, "type");
        Class<?> cl = null;
        try {
            cl = Class.forName("java.lang." + type);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Class[] cs = new Class[]{Class.forName("java.lang.String")};
            if (cl == null) {
                cl = Class.forName("java.math." + type);
            }
            Constructor<?> cn = cl.getConstructor(cs);
            Object[] sig = new Object[]{e.getText()};
            n = (Number)cn.newInstance(sig);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", type);
        }
        return (Number)this.putHash(n, e);
    }

    public Object doArrayDecode(ElementNode e) throws IOException, WMDocumentException {
        if (this.name(e) == objectTag) {
            return this.getHash(e);
        }
        if (this.name(e) == nullTag) {
            return null;
        }
        String t = this.attribute(e, "type");
        String d = this.attribute(e, "depth");
        if (t == null) {
            return null;
        }
        int depth = d != null ? Integer.parseInt(d) : 1;
        String javaclass = this.attribute(e, "javaclass");
        Name type = Name.create(t);
        return this.doArrayDecode(e, type, depth, javaclass);
    }

    public Object doArrayDecode(ElementNode e, Name type, int depth, String javaclass) throws IOException, WMDocumentException {
        String[][] co;
        if (this.name(e) == objectTag) {
            return this.getHash(e);
        }
        boolean objectType = type == objectTag;
        ElementNode[] c = this.children(e, depth > 1 ? arrayTag : type);
        if (c == null) {
            return null;
        }
        if (depth == 2) {
            co = new String[c.length][];
        } else if (type == valueTag) {
            co = new String[c.length];
        } else if (type == objectTag) {
            if (javaclass == null) {
                co = new Object[c.length];
            } else {
                try {
                    co = (Object[])Array.newInstance(Class.forName(javaclass), c.length);
                }
                catch (Exception cce) {
                    co = new Object[c.length];
                }
            }
        } else {
            co = new Values[c.length];
        }
        for (int i = 0; i < c.length; ++i) {
            ElementNode ne = c[i];
            if (this.name(ne) == objectTag) {
                co[i] = this.getHash(ne);
                continue;
            }
            if (this.name(ne) == nullTag) {
                co[i] = null;
                continue;
            }
            if (depth > 1) {
                co[i] = this.doArrayDecode(ne, type, depth - 1, javaclass);
                continue;
            }
            if (objectType) {
                type = this.name(ne);
            }
            if (type == valueTag) {
                if (this.name(ne) == nullTag) continue;
                co[i] = this.doStringDecode(ne);
                continue;
            }
            co[i] = type == recordTag ? (Values)this.doRecordDecode(ne, true, null) : (type == listTag ? (Vector)this.doRecordDecode(ne, false, null) : (type == floatTag ? this.doFloatDecode(ne) : (type == doubleTag ? this.doDoubleDecode(ne) : (type == numberTag ? this.doNumberDecode(ne) : (type == BooleanTag ? this.doBooleanDecode(ne) : (type == CharacterTag ? this.doCharacterDecode(ne) : (type == dateTag ? this.doDateDecode(ne) : null)))))));
        }
        if (depth == 2) {
            if (type == valueTag) {
                return this.putHash(co, e);
            }
        } else if (!objectType) {
            if (type == valueTag) {
                return this.putHash((String[])co, e);
            }
            if (type == recordTag) {
                return this.putHash((Values[])co, e);
            }
        }
        return this.putHash(co, e);
    }

    Name name(ElementNode e) {
        return e.getLocalNameWm();
    }

    ElementNode[] children(ElementNode e, Name type) throws WMDocumentException {
        List v = new List();
        List c = new List();
        Node node = e.getFirstChildWm();
        node = e.getFirstChildWm();
        while (node != null) {
            if (node.getNodeType() == 1) {
                v.addElement(node);
            }
            node = e.getNextSiblingOfChild(node);
        }
        for (int i = 0; i < v.size(); ++i) {
            ElementNode ne = (ElementNode)v.elementAt(i);
            Name n = this.name(ne);
            if (type == objectTag && n != null) {
                c.addElement(ne);
                continue;
            }
            if (n != type && n != nullTag && n != objectTag) continue;
            c.addElement(ne);
        }
        Object[] ret = new ElementNode[c.size()];
        c.copyInto(ret);
        return ret;
    }

    Object getHash(ElementNode e) {
        String oid = this.attribute(e, "idref");
        Object o = this.hash.get(oid);
        return o;
    }

    Object putHash(Object o, ElementNode e) {
        String oid;
        if (this.useOIDs && o != null && (oid = this.attribute(e, "id")) != null) {
            this.hash.put(oid, o);
        }
        return o;
    }

    String attribute(ElementNode e, String attr) {
        return e.getAttributeValue(null, Name.create(attr));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doRecordDecode(ElementNode e, boolean withNames, String asClass) throws IOException {
        void var4_8;
        block44: {
            block45: {
                if (this.name(e) == objectTag) {
                    return this.getHash(e);
                }
                if (!withNames) break block45;
                if (asClass == null) {
                    Values values = new Values();
                    break block44;
                } else {
                    try {
                        asClass = XMLCoder.getEquiv(asClass);
                        Object obj = Class.forName(asClass).newInstance();
                        if (!(obj instanceof Codable)) {
                            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", asClass);
                        }
                        break block44;
                    }
                    catch (Exception ex) {
                        throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", asClass);
                    }
                }
            }
            if (asClass == null) {
                Vector vector = new Vector();
            } else {
                ArrayList arrayList = new ArrayList();
            }
        }
        List c = new List();
        try {
            Node node = e.getFirstChildWm();
            IDataCursor cur = null;
            node = e.getFirstChildWm();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    c.addElement(node);
                }
                node = e.getNextSiblingOfChild(node);
            }
            if (c == null) return this.putHash(var4_8, e);
            if (var4_8 instanceof Values) {
                cur = ((Values)var4_8).getIData().getCursor();
            }
            for (int i = 0; i < c.size(); ++i) {
                Object v;
                ElementNode ne = (ElementNode)c.elementAt(i);
                Name n = ne.getLocalNameWm();
                if (n == null) continue;
                String nm = this.attribute(ne, "name");
                String cl = this.attribute(ne, "javaclass");
                if (n == recordTag) {
                    v = this.doRecordDecode(ne, true, cl);
                } else if (n == listTag) {
                    v = this.doRecordDecode(ne, false, null);
                } else if (n == arrayTag) {
                    v = this.doArrayDecode(ne);
                } else if (n == valueTag) {
                    v = this.doStringDecode(ne);
                } else if (n == floatTag) {
                    v = this.doFloatDecode(ne);
                } else if (n == doubleTag) {
                    v = this.doDoubleDecode(ne);
                } else if (n == numberTag) {
                    v = this.doNumberDecode(ne);
                } else if (n == dateTag) {
                    v = this.doDateDecode(ne);
                } else if (n == BooleanTag) {
                    v = this.doBooleanDecode(ne);
                } else if (n == CharacterTag) {
                    v = this.doCharacterDecode(ne);
                } else if (n == byteTag) {
                    v = this.doBytesDecode(ne);
                } else if (n == objectTag) {
                    v = this.getHash(ne);
                } else {
                    if (n != nullTag) {
                        throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", n.toString());
                    }
                    v = null;
                }
                if (var4_8 instanceof Values) {
                    if (nm != null) {
                        cur.insertAfter(XMLCoderHelper.decodeString(nm), v);
                        continue;
                    }
                    cur.insertAfter("", v);
                    continue;
                }
                if (var4_8 instanceof Vector) {
                    ((Vector)var4_8).addElement(v);
                    continue;
                }
                if (var4_8 instanceof ArrayList) {
                    ((ArrayList)var4_8).add(v);
                    continue;
                }
                if (!(var4_8 instanceof Codable)) continue;
                ((Codable)var4_8).setValue(nm, v);
            }
            return this.putHash(var4_8, e);
        }
        catch (WMDocumentException ex) {
            // empty catch block
        }
        return this.putHash(var4_8, e);
    }
}

