/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.util.coder.RPCHashEntry;

final class RPCHash {
    RPCHashEntry[] hash = new RPCHashEntry[113];
    int count = 0;
    boolean rehashed = false;

    RPCHash() {
    }

    void put(Object key, int value) {
        RPCHashEntry e;
        RPCHashEntry[] h = this.hash;
        int hc = key.hashCode();
        int idx = (hc & Integer.MAX_VALUE) % h.length;
        boolean useEqMethod = false;
        if (key instanceof String) {
            useEqMethod = true;
        }
        if (useEqMethod) {
            e = h[idx];
            while (e != null) {
                if (e.hc == hc && e.key.equals(key)) {
                    e.value = value;
                    return;
                }
                e = e.next;
            }
        } else {
            e = h[idx];
            while (e != null) {
                if (e.hc == hc && e.key == key) {
                    e.value = value;
                    return;
                }
                e = e.next;
            }
        }
        if (this.count >= h.length && !this.rehashed) {
            this.rehash();
            this.rehashed = true;
        }
        e = new RPCHashEntry();
        e.hc = hc;
        e.key = key;
        e.value = value;
        e.next = this.hash[idx];
        this.hash[idx] = e;
        ++this.count;
    }

    int get(Object key) {
        RPCHashEntry[] h = this.hash;
        int hc = key.hashCode();
        int idx = (hc & Integer.MAX_VALUE) % h.length;
        RPCHashEntry e = h[idx];
        while (e != null) {
            if (e.hc == hc && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return -1;
    }

    protected void rehash() {
        int oldCapacity = this.hash.length;
        RPCHashEntry[] oldTable = this.hash;
        int newCapacity = (oldCapacity << 4) + 1;
        RPCHashEntry[] newTable = new RPCHashEntry[newCapacity];
        this.hash = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            RPCHashEntry old = oldTable[i];
            while (old != null) {
                RPCHashEntry e = old;
                old = old.next;
                int index = (e.key.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }
}

