/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.BasicIDataCodable;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataDeserializable;
import com.wm.data.IDataIndexCursor;
import com.wm.data.ISMemDataImpl;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.LocalizedIOException;
import com.wm.util.Table;
import com.wm.util.Values;
import com.wm.util.coder.BlockInputStream;
import com.wm.util.coder.BlockOutputStream;
import com.wm.util.coder.Codable;
import com.wm.util.coder.Coder;
import com.wm.util.coder.DefaultReferenceManager;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.IDataEntryRPC;
import com.wm.util.coder.InvalidDatatypeException;
import com.wm.util.coder.RPCHash;
import com.wm.util.coder.ReferenceManager;
import com.wm.util.coder.RemoteReferenceCodable;
import com.wm.util.coder.StringCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.coder.ZInputStream;
import com.wm.util.coder.ZOutputStream;
import com.wm.util.coder.resources.CoderExceptionBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class RPCBinCoder2
extends Coder {
    static final boolean debug = false;
    static final int VERSION_2x = 4;
    static final String PROPERTY_RPCVER = "watt.xmlrpc.version";
    static final String PROPERTY_RPCCMP = "watt.xmlrpc.compressSize";
    static final int comprSizeMin = 65535;
    static int comprSize = Integer.MAX_VALUE;
    static final int initHashSize = 113;
    static final int rpc2Version = 7;
    static int dfltVersion = -1;
    static final int LONG_DATA = 128;
    static final int COMP_DATA = 64;
    static final int ENCODE = 1;
    static final int DECODE = 2;
    static final String ctype = "application/x-wmrpc2";
    public static final int DT_OBJREF = 0;
    public static final int DT_UNKNOWN = 1;
    public static final int DT_NULL = 2;
    public static final int DT_BYTE_ARRAY = 3;
    public static final int DT_CHAR_ARRAY = 4;
    public static final int DT_VALUES = 5;
    public static final int DT_LIST = 6;
    public static final int DT_TABLE = 7;
    public static final int DT_HASH = 8;
    public static final int DT_VECTOR = 9;
    public static final int DT_ARRAY = 10;
    public static final int DT_INTEGER = 11;
    public static final int DT_FLOAT = 12;
    public static final int DT_AS_STRING = 13;
    public static final int DT_CODABLE = 14;
    public static final int DT_REMOTE_REF = 15;
    public static final int DT_COMPRESS = 16;
    public static final int DT_RREF_TABLE = 17;
    public static final int DT_IDATCODABLE = 18;
    public static final int DT_IDATA_ENTRY = 19;
    public static final int DT_IDATA = 20;
    public static final String TYPE_REMOTE_REF = "com.wm.util.RemoteReference";
    private Object[] objArray = new Object[128];
    int version;
    String encoding;
    volatile transient RPCHash objIn;
    volatile transient Vector objOut;
    int nextOID;
    int mode;
    private boolean gEncodeUnkAsStr;
    private boolean gCompress;
    private ReferenceManager gRefMgr;

    public RPCBinCoder2() {
        this(new DefaultReferenceManager());
    }

    public RPCBinCoder2(int ver) {
        this(new DefaultReferenceManager());
        this.setVersion(ver);
    }

    public RPCBinCoder2(ReferenceManager rm) {
        if (dfltVersion == -1) {
            this.initFromProps();
        }
        this.version = dfltVersion;
        this.gEncodeUnkAsStr = true;
        this.gRefMgr = rm;
    }

    private void initFromProps() {
        int i = -1;
        dfltVersion = 7;
        String s = System.getProperty(PROPERTY_RPCVER);
        if (s != null) {
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (i >= 0 && i <= 7) {
                dfltVersion = i;
            }
        }
        if ((s = System.getProperty(PROPERTY_RPCCMP)) != null) {
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (i >= 65535) {
                comprSize = i;
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        if (v >= 0) {
            this.version = v <= 7 ? v : 7;
        }
    }

    public static int getHighestVersionSupported() {
        return 7;
    }

    public boolean getEncodeUnkAsString() {
        return this.gEncodeUnkAsStr;
    }

    public void setEncodeUnkAsString(boolean bVal) {
        this.gEncodeUnkAsStr = bVal;
    }

    public String getContentType() {
        return ctype;
    }

    public ZOutputStream startCompression(OutputStream os) throws IOException {
        if (os instanceof ZOutputStream) {
            return (ZOutputStream)os;
        }
        this.writeHeader(os, 0, 16);
        return new ZOutputStream(new BlockOutputStream(os, comprSize));
    }

    public boolean endCompression(OutputStream os) throws IOException {
        if (os instanceof ZOutputStream) {
            ((ZOutputStream)os).end();
            return true;
        }
        return false;
    }

    public ZInputStream startCompression(InputStream is) throws IOException {
        if (is instanceof ZInputStream) {
            return (ZInputStream)is;
        }
        return new ZInputStream(new BlockInputStream(is));
    }

    public boolean endCompression(InputStream is) throws IOException {
        if (is instanceof ZInputStream) {
            ZInputStream gz = (ZInputStream)is;
            gz.end();
            return true;
        }
        return false;
    }

    public void encode(OutputStream os, Values data) throws IOException, InvalidDatatypeException {
        this.mode = 1;
        this.objIn = new RPCHash();
        this.nextOID = 0;
        this.encoding = "UTF8";
        this._encode(os, new Integer(this.version));
        this._encode(os, this.encoding);
        this.encoding = Config.getEncoding();
        this._encode(os, data);
        os.flush();
    }

    public Values decode(InputStream is) throws IOException, InvalidDatatypeException {
        this.mode = 2;
        this.objOut = new Vector(113);
        this.nextOID = 0;
        this.encoding = "UTF8";
        Integer ret = (Integer)this._decode(is);
        if (ret != null) {
            this.version = ret;
        }
        if (this.version > 7) {
            throw new LocalizedIOException(CoderExceptionBundle.class, CoderExceptionBundle.RPCBINCODER_UNSUPPORT, "", Integer.toString(this.version));
        }
        Object o = this._decode(is);
        this.encoding = (String)o;
        return (Values)this._decode(is);
    }

    public void writeHeader(OutputStream os, int length, int dtype) throws IOException {
        if (length > 255) {
            os.write(0x80 | dtype);
            this.writeInt(os, length);
        } else {
            os.write(dtype);
            os.write(length);
        }
    }

    public void writeInt(OutputStream os, int iv) throws IOException {
        os.write(iv >> 24 & 0xFF);
        os.write(iv >> 16 & 0xFF);
        os.write(iv >> 8 & 0xFF);
        os.write(iv & 0xFF);
    }

    public void _encode(OutputStream os, Object value) throws IOException {
        int id = this.nextOID++;
        if (this.version < 7 && value instanceof IData && !(value instanceof Values)) {
            value = Values.use((IData)value);
        }
        if (value == null) {
            this.writeHeader(os, 0, 2);
            return;
        }
        int oid = this.objIn.get(value);
        if (oid >= 0) {
            this.writeHeader(os, oid, 0);
            return;
        }
        this.objIn.put(value, id);
        if (this.version >= 6 && value instanceof RemoteReferenceCodable) {
            this.writeHeader(os, 1, 15);
            String key = ((RemoteReferenceCodable)value).getValue();
            this.gRefMgr.put(key, value);
            this._encode(os, key);
            return;
        }
        if (value instanceof StringCodable) {
            value = ((StringCodable)value).getValue();
        }
        if (value instanceof String) {
            switch (this.version) {
                case 0: {
                    byte[] b = ((String)value).getBytes("UTF8");
                    this.writeHeader(os, b.length, 3);
                    os.write(b);
                    break;
                }
                case 1: {
                    byte[] b = ((String)value).getBytes(this.encoding);
                    this.writeHeader(os, b.length, 3);
                    os.write(b);
                    break;
                }
                default: {
                    char[] c = new char[((String)value).length()];
                    ((String)value).getChars(0, c.length, c, 0);
                    OutputStream orig = os;
                    if (c.length > comprSize) {
                        os = this.startCompression(os);
                    }
                    this.writeHeader(os, c.length, 4);
                    for (int i = 0; i < c.length; ++i) {
                        os.write(c[i] >> 8 & 0xFF);
                        os.write(c[i] & 0xFF);
                    }
                    if (c.length > comprSize) {
                        if (this.endCompression(os)) {
                            // empty if block
                        }
                        os = orig;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.version >= 7 && value instanceof IDataCodable && !(value instanceof Table)) {
            this.writeHeader(os, 1, 18);
            this._encode(os, RPCBinCoder2.getEquiv(value.getClass().getName()));
            this._encode(os, ((IDataCodable)value).getIData());
        } else if (this.version >= 7 && value instanceof IData) {
            IDataCursor c = ((IData)value).getCursor();
            this.writeHeader(os, 1, 20);
            this._encode(os, RPCBinCoder2.getEquiv(value.getClass().getName()));
            while (c.next()) {
                this.writeHeader(os, 1, 19);
                this._encode(os, c.getKey());
                this._encode(os, c.getValue());
            }
            c.destroy();
            this.writeHeader(os, 0, 2);
        } else if (value instanceof Values) {
            IData idata = ((Values)value).getIData();
            IDataIndexCursor icur = idata.getIndexCursor();
            this.writeHeader(os, icur.count(), 5);
            icur.destroy();
            IDataCursor cur = idata.getCursor();
            while (cur.next()) {
                Object v = cur.getValue();
                v = Values.wrapIData(v);
                this._encode(os, cur.getKey());
                this._encode(os, v);
            }
            cur.destroy();
        } else if (value instanceof ValuesCodable) {
            Values v = ((ValuesCodable)value).getValues();
            this.writeHeader(os, v.size(), 5);
            Enumeration e = v.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                this._encode(os, k);
                this._encode(os, v.get(k));
            }
        } else if (value instanceof Table) {
            Table t = (Table)value;
            this.writeHeader(os, t.getRowCount(), 7);
            this._encode(os, t.getValue("name"));
            this._encode(os, t.getValue("cols"));
            this._encode(os, t.getValue("sizes"));
            this._encode(os, t.getValue("rows"));
        } else if (value instanceof List) {
            List v = (List)value;
            int vSize = v.size();
            this.writeHeader(os, vSize, 6);
            for (int i = 0; i < vSize; ++i) {
                this._encode(os, v.elementAt(i));
            }
        } else if (value instanceof Hashtable) {
            Hashtable v = (Hashtable)value;
            this.writeHeader(os, v.size(), 8);
            Enumeration e = v.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                this._encode(os, k);
                this._encode(os, v.get(k));
            }
        } else if (value instanceof Vector) {
            Vector v = (Vector)value;
            int vSize = v.size();
            this.writeHeader(os, vSize, 9);
            for (int i = 0; i < vSize; ++i) {
                this._encode(os, v.elementAt(i));
            }
        } else if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            this.writeHeader(os, b.length, 3);
            os.write(b);
        } else if (this.version >= 6 && value instanceof RemoteReferenceCodable[][]) {
            RemoteReferenceCodable[][] o = (RemoteReferenceCodable[][])value;
            this.writeHeader(os, o.length, 17);
            this.writeInt(os, o[0].length);
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[0].length; ++j) {
                    String key;
                    if (o[i][j] != null) {
                        key = o[i][j].getValue();
                        this.gRefMgr.put(key, o[i][j]);
                    } else {
                        key = null;
                    }
                    this._encode(os, key);
                }
            }
        } else if (value instanceof Object[]) {
            Object[] o = (Object[])value;
            this.writeHeader(os, o.length, 10);
            Class<?> atype = o.getClass().getComponentType();
            if (this.version >= 6 && o instanceof RemoteReferenceCodable[]) {
                this._encode(os, TYPE_REMOTE_REF);
            } else if (o instanceof ValuesCodable[]) {
                this._encode(os, "com.wm.util.Values");
            } else if (o instanceof StringCodable[]) {
                this._encode(os, "java.lang.String");
            } else {
                String tmp = RPCBinCoder2.getEquiv(atype.getName());
                if (this.version <= 4 && tmp.equals("com.wm.util.Values")) {
                    this._encode(os, "watt.util.Values");
                } else {
                    this._encode(os, tmp);
                }
            }
            for (int i = 0; i < o.length; ++i) {
                this._encode(os, o[i]);
            }
        } else if (value instanceof Integer) {
            int iv = (Integer)value;
            this.writeHeader(os, 4, 11);
            this.writeInt(os, iv);
        } else if (value instanceof Float) {
            String fv = value.toString();
            this.writeHeader(os, 1, 12);
            this._encode(os, fv);
        } else if (value instanceof Codable) {
            Codable code = (Codable)value;
            String[] vk = code.getValueKeys();
            this.writeHeader(os, vk.length, 14);
            this._encode(os, RPCBinCoder2.getEquiv(value.getClass().getName()));
            for (int i = 0; i < vk.length; ++i) {
                this._encode(os, vk[i]);
                this._encode(os, code.getValue(vk[i]));
            }
        } else if (value instanceof Number || value instanceof Boolean || value instanceof java.util.Date) {
            Class<?> c = value.getClass();
            Field[] f = c.getDeclaredFields();
            this.writeHeader(os, 1, 13);
            this._encode(os, c.getName());
            this._encode(os, value.toString());
        } else if (this.gEncodeUnkAsStr) {
            this.writeHeader(os, 1, 1);
            Class<?> c = value.getClass();
            this._encode(os, c.getName());
        } else {
            this.writeHeader(os, 0, 2);
        }
    }

    public final int nextByte(InputStream is) throws IOException {
        return is.read() & 0xFF;
    }

    public int readInt(InputStream is) throws IOException {
        return this.nextByte(is) << 24 | this.nextByte(is) << 16 | this.nextByte(is) << 8 | this.nextByte(is);
    }

    public Object _decode(InputStream is) throws IOException {
        Object ret;
        int id = this.nextOID++;
        int hdrByte = this.nextByte(is);
        if (hdrByte == -1) {
            return null;
        }
        int dtype = hdrByte & 0x3F;
        int length = (hdrByte & 0x80) > 0 ? this.readInt(is) : this.nextByte(is);
        switch (dtype) {
            case 20: {
                IData data;
                String classname = (String)this._decode(is);
                Class[] parmTypes = new Class[]{};
                Object[] initArgs = new Object[]{};
                try {
                    Class<?> clazz = Class.forName(classname);
                    Method meth = clazz.getMethod("create", parmTypes);
                    data = (IData)meth.invoke(null, initArgs);
                }
                catch (Throwable e) {
                    Object[] parms = new String[]{classname, "ISMemDataImpl", e.toString()};
                    JournalLogger.log(24, 76, 2, parms);
                    data = ISMemDataImpl.create();
                }
                if (data instanceof IDataDeserializable) {
                    int i = 0;
                    while (true) {
                        this.setObjArrayEntry(i, (String)this._decode(is));
                        if (this.objArray[i++] == null) break;
                        this.setObjArrayEntry(i++, this._decode(is));
                    }
                    ((IDataDeserializable)((Object)data)).deserialize(this.objArray);
                } else {
                    IDataCursor cur = data.getCursor();
                    IDataEntryRPC ide = null;
                    while ((ide = this._decodeIDataEntry(ide, is)) != null) {
                        String k = ide.getKey();
                        Object v = ide.getValue();
                        cur.insertAfter(k, v);
                    }
                    cur.destroy();
                }
                ret = data;
                this.putDecode(ret, id);
                break;
            }
            case 18: {
                String cname = (String)this._decode(is);
                IData data = (IData)this._decode(is);
                try {
                    Class<?> c = Class.forName(cname);
                    Class[] ct = new Class[]{};
                    Object[] oc = new Object[]{};
                    Constructor<?> ctor = c.getConstructor(ct);
                    IDataCodable codeable = (IDataCodable)ctor.newInstance(oc);
                    codeable.setIData(data);
                    ret = codeable;
                }
                catch (Throwable e) {
                    Object[] parms = new String[]{cname, "BasicDataCodable", e.toString()};
                    JournalLogger.log(25, 76, 2, parms);
                    ret = new BasicIDataCodable(data);
                }
                this.putDecode(ret, id);
                break;
            }
            case 16: {
                ZInputStream nis = this.startCompression(is);
                if (nis != is) {
                    --this.nextOID;
                    Object ret2 = this._decode(nis);
                    this.endCompression(nis);
                    return ret2;
                }
                ret = this._decode(is);
                break;
            }
            case 17: {
                int width = this.readInt(is);
                Object[][] refTab = new Object[length][width];
                for (int i = 0; i < length; ++i) {
                    for (int j = 0; j < width; ++j) {
                        String key = (String)this._decode(is);
                        refTab[i][j] = this.gRefMgr.get(key);
                    }
                }
                this.putDecode(refTab, id);
                ret = refTab;
                break;
            }
            case 15: {
                if (this.version >= 6) {
                    String key = (String)this._decode(is);
                    ret = this.gRefMgr.get(key);
                    this.putDecode(ret, id);
                    break;
                }
            }
            case 3: {
                int toRead;
                byte[] b = new byte[length];
                int blen = toRead = b.length;
                while (toRead > 0) {
                    toRead -= is.read(b, blen - toRead, toRead);
                }
                switch (this.version) {
                    case 0: {
                        ret = new String(b, "UTF8");
                        break;
                    }
                    case 1: 
                    case 2: {
                        ret = new String(b, this.encoding);
                        break;
                    }
                    default: {
                        ret = b;
                    }
                }
                this.putDecode(ret, id);
                break;
            }
            case 4: {
                char[] ca = new char[length];
                for (int ci = 0; ci < ca.length; ++ci) {
                    ca[ci] = (char)(this.nextByte(is) << 8 | this.nextByte(is));
                }
                ret = new String(ca);
                this.putDecode(ret, id);
                break;
            }
            case 5: {
                Values v = new Values();
                ret = v;
                IDataCursor cur = v.getIData().getCursor();
                this.putDecode(ret, id);
                for (int i = 0; i < length; ++i) {
                    Object key = this._decode(is);
                    Object val = this._decode(is);
                    cur.insertAfter((String)key, val);
                }
                break;
            }
            case 7: {
                Table t = new Table((String)this._decode(is), (String[])this._decode(is), (String[])this._decode(is));
                t.setValue("rows", (Vector)this._decode(is));
                ret = t;
                this.putDecode(ret, id);
                break;
            }
            case 6: {
                List l = new List(length);
                ret = l;
                this.putDecode(ret, id);
                for (int i = 0; i < length; ++i) {
                    l.addElement(this._decode(is));
                }
                break;
            }
            case 8: {
                Hashtable<Object, Object> h = new Hashtable<Object, Object>(length == 0 ? 1 : length);
                ret = h;
                this.putDecode(ret, id);
                for (int i = 0; i < length; ++i) {
                    Object key = this._decode(is);
                    Object val = this._decode(is);
                    h.put(key, val);
                }
                break;
            }
            case 9: {
                Vector<Object> vl = new Vector<Object>(length);
                ret = vl;
                this.putDecode(ret, id);
                for (int i = 0; i < length; ++i) {
                    vl.addElement(this._decode(is));
                }
                break;
            }
            case 10: {
                Object[] o;
                String atype = RPCBinCoder2.getEquiv((String)this._decode(is));
                try {
                    o = !(atype == null || atype.equalsIgnoreCase(TYPE_REMOTE_REF) && this.version >= 6) ? (Object[])Array.newInstance(Class.forName(atype), length) : new Object[length];
                }
                catch (Exception e) {
                    Object[] parms = new String[]{atype};
                    JournalLogger.log(9, 76, 1, parms);
                    o = new Values[length];
                }
                ret = o;
                this.putDecode(ret, id);
                for (int i = 0; i < length; ++i) {
                    o[i] = this._decode(is);
                }
                ret = o;
                break;
            }
            case 11: {
                ret = new Integer(this.readInt(is));
                this.putDecode(ret, id);
                break;
            }
            case 12: {
                ret = new Float((String)this._decode(is));
                this.putDecode(ret, id);
                break;
            }
            case 14: {
                String cname = (String)this._decode(is);
                try {
                    Class<?> c = Class.forName(cname);
                    Class[] ct = new Class[]{};
                    Object[] oc = new Object[]{};
                    Codable code = (Codable)c.getConstructor(ct).newInstance(oc);
                    for (int i = 0; i < length; ++i) {
                        code.setValue((String)this._decode(is), this._decode(is));
                    }
                    ret = code;
                }
                catch (IOException ie) {
                    ie.fillInStackTrace();
                    throw ie;
                }
                catch (Throwable e) {
                    Object[] parms = new String[]{cname};
                    JournalLogger.log(10, 76, 1, parms);
                    Values uv = new Values();
                    for (int i = 0; i < length; ++i) {
                        uv.put((String)this._decode(is), this._decode(is));
                    }
                    ret = uv;
                }
                this.putDecode(ret, id);
                break;
            }
            case 13: {
                String asdtype = null;
                String sdval = null;
                try {
                    asdtype = RPCBinCoder2.getEquiv((String)this._decode(is));
                    sdval = (String)this._decode(is);
                    if (asdtype.equals("java.util.Date")) {
                        String format = "EEE MMM dd HH:mm:ss z yyyy";
                        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
                        ret = df.parse(sdval);
                    } else if (asdtype.equals("java.sql.Date")) {
                        String format = "yyyy-MM-dd";
                        Calendar cal = Calendar.getInstance();
                        SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
                        java.util.Date d = df.parse(sdval);
                        cal.setTime(d);
                        ret = new Date(cal.get(1) - 1900, cal.get(2), cal.get(5));
                    } else {
                        Class<?> c = Class.forName(asdtype);
                        Field[] f = c.getDeclaredFields();
                        String[] ss = new String[]{sdval};
                        Class[] cc = new Class[]{sdval.getClass()};
                        ret = c.getConstructor(cc).newInstance(ss);
                    }
                }
                catch (IOException ie) {
                    ie.fillInStackTrace();
                    throw ie;
                }
                catch (Exception e) {
                    ret = null;
                    Object[] parms = new String[]{asdtype};
                    JournalLogger.log(11, 76, 1, parms);
                }
                this.putDecode(ret, id);
                break;
            }
            case 1: {
                String sdtype = RPCBinCoder2.getEquiv((String)this._decode(is));
                ret = sdtype;
                this.putDecode(ret, id);
                break;
            }
            case 0: {
                ret = this.objOut.elementAt(length);
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    void putDecode(Object val, int idx) {
        int sz = this.objOut.size();
        if (idx == sz) {
            this.objOut.addElement(val);
        } else if (idx > sz) {
            for (int i = idx - sz; i > 0; --i) {
                this.objOut.addElement(null);
            }
            this.objOut.addElement(val);
        } else {
            this.objOut.setElementAt(val, idx);
        }
    }

    private void setObjArrayEntry(int index, Object obj) {
        if (index < this.objArray.length) {
            this.objArray[index] = obj;
        } else {
            int len = this.objArray.length;
            Object[] newArray = new Object[len << 1];
            System.arraycopy(this.objArray, 0, newArray, 0, len);
            this.objArray = newArray;
            this.objArray[index] = obj;
        }
    }

    private IDataEntryRPC _decodeIDataEntry(IDataEntryRPC ide, InputStream is) throws IOException {
        int hdrByte = this.nextByte(is);
        if (hdrByte == -1) {
            return null;
        }
        int dtype = hdrByte & 0x3F;
        if ((hdrByte & 0x80) > 0) {
            int length = this.readInt(is);
        } else {
            int length = this.nextByte(is);
        }
        if (dtype == 19) {
            if (ide == null) {
                ide = new IDataEntryRPC();
            }
            ide.setKey((String)this._decode(is));
            ide.setValue(this._decode(is));
            return ide;
        }
        return null;
    }
}

