/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.util.List;
import com.wm.util.Values;
import com.wm.util.coder.Coder;
import com.wm.util.coder.InvalidDatatypeException;
import com.wm.util.coder.resources.CoderExceptionBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class RPCBinCoder
extends Coder {
    int datalen;
    int version;
    boolean strict = false;
    static final byte[] header = new byte[]{49, 0, 48, 0};
    static final String ctype = "application/x-wmrpc-bin";

    public String getContentType() {
        return ctype;
    }

    public void encode(OutputStream os, Values data) throws IOException, InvalidDatatypeException {
        this.writeHeader(os);
        os.write(this.doEncode(data));
    }

    public Values decode(InputStream is) throws IOException, InvalidDatatypeException {
        return this._decode(is);
    }

    private void writeHeader(OutputStream stream) throws IOException {
        stream.write(header);
    }

    private byte[] doEncode(byte[] value) throws IOException {
        if (value == null) {
            return this.doEncode();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write((value.length + "\u0000").getBytes());
        output.write(value);
        return output.toByteArray();
    }

    private void writeName(OutputStream stream, String name) throws IOException {
        stream.write(name.getBytes());
        stream.write(0);
    }

    private byte[] doEncode() {
        return "-\u0000".getBytes();
    }

    private byte[] doEncode(String value) throws IOException {
        if (value == null) {
            return this.doEncode();
        }
        return (value.length() + "\u0000" + value).getBytes();
    }

    private byte[] doEncode(String[] value) throws IOException {
        if (value == null) {
            return this.doEncode();
        }
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        for (int i = 0; i < value.length; ++i) {
            sb.write(this.doEncode(value[i]));
        }
        return this.doEncode(sb.toByteArray());
    }

    private byte[] doEncode(String[][] value) throws IOException {
        if (value == null) {
            return this.doEncode();
        }
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        for (int i = 0; i < value.length; ++i) {
            sb.write(this.doEncode(value[i]));
        }
        return this.doEncode(sb.toByteArray());
    }

    private byte[] doEncode(Values data) throws IOException {
        if (data == null) {
            return this.doEncode();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Enumeration e = data.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object val = data.get(key);
            if (val == null) {
                this.writeName(output, key);
                this.writeName(output, "s0");
                output.write(this.doEncode());
                continue;
            }
            if (val instanceof String[][]) {
                this.writeName(output, key);
                this.writeName(output, "s2");
                output.write(this.doEncode((String[][])val));
                continue;
            }
            if (val instanceof String[]) {
                this.writeName(output, key);
                this.writeName(output, "s1");
                output.write(this.doEncode((String[])val));
                continue;
            }
            if (val instanceof String) {
                this.writeName(output, key);
                this.writeName(output, "s0");
                output.write(this.doEncode((String)val));
                continue;
            }
            if (val instanceof Values[]) {
                this.writeName(output, key);
                this.writeName(output, "r1");
                output.write(this.doEncode((Values[])val));
                continue;
            }
            if (val instanceof Values) {
                this.writeName(output, key);
                this.writeName(output, "r0");
                output.write(this.doEncode((Values)val));
                continue;
            }
            if (val instanceof Vector) continue;
            if (val instanceof Integer) {
                this.writeName(output, key);
                this.writeName(output, "I0");
                output.write(this.doEncode(val.toString()));
                continue;
            }
            if (val instanceof Long) {
                this.writeName(output, key);
                this.writeName(output, "L0");
                output.write(this.doEncode(val.toString()));
                continue;
            }
            if (val instanceof Float) {
                this.writeName(output, key);
                this.writeName(output, "F0");
                output.write(this.doEncode(val.toString()));
                continue;
            }
            if (val instanceof Double) {
                this.writeName(output, key);
                this.writeName(output, "D0");
                output.write(this.doEncode(val.toString()));
                continue;
            }
            if (val instanceof Date) {
                this.writeName(output, key);
                this.writeName(output, "d0");
                output.write(this.doEncode(val.toString()));
                continue;
            }
            if (!this.strict) continue;
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_ENCODING, "", val.getClass().getName());
        }
        return this.doEncode(output.toByteArray());
    }

    private byte[] doEncode(Values[] data) throws IOException {
        if (data == null) {
            return this.doEncode();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (int i = 0; i < data.length; ++i) {
            output.write(this.doEncode(data[i]));
        }
        return this.doEncode(output.toByteArray());
    }

    public Values _decode(InputStream stream) throws IOException {
        this.readHeader(stream);
        return this.readValues(stream);
    }

    private byte[] readValue(InputStream stream) throws IOException {
        int len = this.readLength(stream);
        if (len > 0) {
            return this.getLenBlock(stream, len);
        }
        if (len == 0) {
            return new byte[0];
        }
        return null;
    }

    private byte[][] readArray(byte[] b) throws IOException {
        return this.readArray(new ByteArrayInputStream(b));
    }

    private byte[][] readArray(InputStream stream) throws IOException {
        List v = new List();
        while (stream.available() > 0) {
            v.addElement(this.readValue(stream));
        }
        byte[][] b = new byte[v.size()][];
        v.copyInto((Object[])b);
        return b;
    }

    private String readString(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    private String[] readStringArray(byte[] data) throws IOException {
        byte[][] b = this.readArray(data);
        String[] s = new String[b.length];
        for (int i = 0; i < b.length; ++i) {
            s[i] = this.readString(b[i]);
        }
        return s;
    }

    private Values readValues(InputStream stream) throws IOException {
        if (stream.available() == 0) {
            return new Values();
        }
        byte[] value = this.readValue(stream);
        return this.readValues(value);
    }

    private Values readValues(byte[] value) throws IOException {
        Values d = new Values();
        if (value == null) {
            return null;
        }
        if (value == null) {
            return null;
        }
        ByteArrayInputStream bi = new ByteArrayInputStream(value);
        block9: while (bi.available() > 0) {
            String name = this.readName(bi);
            byte[] type = new byte[]{(byte)bi.read(), (byte)bi.read()};
            bi.read();
            byte[] data = this.readValue(bi);
            switch (type[0]) {
                case 73: {
                    d.put(name, new Integer(this.readString(data)));
                    continue block9;
                }
                case 76: {
                    d.put(name, new Long(this.readString(data)));
                    continue block9;
                }
                case 70: {
                    d.put(name, new Float(this.readString(data)));
                    continue block9;
                }
                case 68: {
                    d.put(name, new Double(this.readString(data)));
                    continue block9;
                }
                case 100: {
                    d.put(name, new Date(this.readString(data)));
                    continue block9;
                }
                case 115: {
                    if (type[1] == 48) {
                        d.put(name, this.readString(data));
                        continue block9;
                    }
                    if (type[1] == 49) {
                        d.put(name, this.readStringArray(data));
                        continue block9;
                    }
                    if (type[1] != 50) continue block9;
                    byte[][] b = this.readArray(data);
                    String[][] s = new String[b.length][];
                    for (int i = 0; i < b.length; ++i) {
                        s[i] = this.readStringArray(b[i]);
                    }
                    d.put(name, s);
                    continue block9;
                }
                case 114: {
                    if (type[1] == 48) {
                        d.put(name, this.readValues(data));
                        continue block9;
                    }
                    if (type[1] != 49) continue block9;
                    List v = new List();
                    ByteArrayInputStream bis = new ByteArrayInputStream(data);
                    while (bis.available() > 0) {
                        v.addElement(this.readValues(bis));
                    }
                    Object[] s = new Values[v.size()];
                    v.copyInto(s);
                    d.put(name, s);
                    continue block9;
                }
            }
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", new String(type));
        }
        return d;
    }

    private String readName(InputStream stream) throws IOException {
        return new String(this.getTermBlock(stream, 0));
    }

    private int readLength(InputStream stream) throws IOException {
        byte[] b = this.getTermBlock(stream, 0);
        if (b[0] == 45) {
            return -1;
        }
        return Integer.parseInt(new String(b));
    }

    private byte[] readHeader(InputStream stream) throws IOException {
        this.version = this.readLength(stream);
        byte[] hdr = this.getLenBlock(stream, this.readLength(stream));
        return hdr;
    }

    private byte[] getTermBlock(InputStream in, int termChar) throws IOException {
        int c;
        byte[] lineBuffer;
        byte[] buf = lineBuffer = new byte[128];
        int room = 128;
        int offset = 0;
        boolean numRead = false;
        while ((c = in.read()) != -1 && c != termChar) {
            if (--room < 0) {
                buf = new byte[offset + 128];
                room = buf.length - offset - 1;
                System.arraycopy(lineBuffer, 0, buf, 0, offset);
                lineBuffer = buf;
            }
            buf[offset++] = (byte)c;
        }
        byte[] ret = new byte[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        return ret;
    }

    private byte[] getLenBlock(InputStream in, int length) throws IOException {
        byte[] buf = new byte[length];
        for (int total = length; total > 0; total -= in.read(buf, length - total, total)) {
        }
        return buf;
    }
}

