/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.MBoolean;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Base64;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.IntegerList;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.Name;
import com.wm.util.Strings;
import com.wm.util.Table;
import com.wm.util.Values;
import com.wm.util.coder.Codable;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.IDataCoder;
import com.wm.util.coder.InvalidDatatypeException;
import com.wm.util.coder.StringCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.coder.XMLCoderHelper;
import com.wm.util.coder.resources.CoderExceptionBundle;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class IDataXMLCoder
extends IDataCoder {
    static final double version = 1.0;
    static Name recordTag = Name.create("record");
    static Name idatacodableTag = Name.create("idatacodable");
    static Name idataportableTag = Name.create("idataportable");
    static Name arrayTag = Name.create("array");
    static Name floatTag = Name.create("float");
    static Name doubleTag = Name.create("double");
    static Name numberTag = Name.create("number");
    static Name valueTag = Name.create("value");
    static Name listTag = Name.create("list");
    static Name nullTag = Name.create("null");
    static Name objectTag = Name.create("object");
    static Name booleanTag = Name.create("boolean");
    static Name jbooleanTag = Name.create("jboolean");
    static Name dateTag = Name.create("Date");
    static Name CharacterTag = Name.create("Character");
    static Name gCalendarTag = Name.create("GregorianCalendar");
    static Name byteTag = Name.create("byte");
    static Name javaClassName = Name.create("javaclass");
    static Name nameName = Name.create("name");
    static Name typeName = Name.create("type");
    static Name versionName = Name.create("version");
    static Name depthName = Name.create("depth");
    static Name idrefName = Name.create("idref");
    static Name idName = Name.create("id");
    static Name YEAR = Name.create("year");
    static Name MONTH = Name.create("month");
    static Name DAY = Name.create("day");
    static Name HOUR = Name.create("hour");
    static Name MIN = Name.create("min");
    static Name SEC = Name.create("sec");
    static Name MSEC = Name.create("millSec");
    static final String CLOSE_TAG = "/>";
    static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    private static ClassLoader cloader = null;
    private static final String DATE_TIME_FORMAT = "EEE MMM dd HH:mm:ss z yyyy";
    Name rootTag = Name.create("IDataXMLCoder");
    String ctype = "text/xml";
    boolean pretty = true;
    boolean useOIDs = false;
    boolean useXMLHeader = true;
    boolean first = true;
    boolean ignoreInvalid = true;
    Hashtable hash;
    int nextID = 0;
    int nest = 0;
    double cVersion;
    public static final String NUMBER_NAN = "NaN";
    public static final String NUMBER_NEGATIVE_INFINITY = "-Infinity";
    public static final String NUMBER_POSITIVE_INFINITY = "Infinity";
    private String encoding = null;

    public IDataXMLCoder(String encoding) {
        this();
        this.encoding = encoding;
    }

    public IDataXMLCoder() {
    }

    public void setUseXMLHeader(boolean use) {
        this.useXMLHeader = use;
    }

    public void setUseOIDs(boolean use) {
        this.useOIDs = use;
    }

    public void setIgnoreInvalid(boolean ignore) {
        this.ignoreInvalid = ignore;
    }

    public static void setClassLoader(ClassLoader cl) {
        cloader = cl;
    }

    private Class loadClass(String cname) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = cloader == null ? Class.forName(cname) : cloader.loadClass(cname);
        return clazz;
    }

    private String getHeader() {
        String encodingType = this.encoding != null ? this.encoding : "UTF-8";
        return Strings.cat(this.useXMLHeader ? "<?xml version=\"1.0\" encoding=\"" + encodingType + "\"?>" : "", "\n\n<", this.rootTag.toString(), " version=\"", Double.toString(1.0), "\">\n");
    }

    private String getFooter() {
        return Strings.cat("</", this.rootTag.toString(), ">\n");
    }

    public void setContentType(String ctype) {
        this.ctype = ctype;
    }

    public String getContentType() {
        return this.ctype;
    }

    public void encode(OutputStream os, IData data) throws IOException, InvalidDatatypeException {
        this.cVersion = 1.0;
        this.first = true;
        this.hash = new Hashtable();
        if (data == null) {
            data = IDataFactory.create();
        }
        BufferedWriter stream = new BufferedWriter(new OutputStreamWriter(os, this.encoding != null ? this.encoding : "UTF8"));
        stream.write(this.getHeader());
        this.doEncode(stream, null, data);
        stream.write(this.getFooter());
        ((Writer)stream).flush();
    }

    public IData decode(InputStream is) throws IOException, InvalidDatatypeException {
        Document doc = null;
        try {
            doc = new Document(is, null, this.encoding, false, true);
            return this.decode(doc);
        }
        catch (WMDocumentException e) {
            throw new InvalidDatatypeException(e.toString());
        }
    }

    public IData decode(Document doc) throws IOException, InvalidDatatypeException {
        Node rootData;
        this.hash = new Hashtable();
        byte[] bhdr = new byte[64];
        try {
            Node root = doc.getFirstChildWm();
            while (root != null && !this.rootTag.equals(root.getLocalNameWm())) {
                root = doc.getNextSiblingOfChild(root);
            }
            if (root == null) {
                throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DATATYPE, "");
            }
            String sVersion = root.getAttributeValue(null, versionName);
            this.cVersion = sVersion == null ? 1.0 : new Double(sVersion);
            rootData = root.getFirstChildWm();
            while (rootData != null) {
                if (rootData.getNodeType() != 1) {
                    rootData = root.getNextSiblingOfChild(rootData);
                    continue;
                }
                break;
            }
        }
        catch (WMDocumentException e) {
            throw new InvalidDatatypeException(e.toString());
        }
        String javaclass = this.attribute((ElementNode)rootData, javaClassName);
        return (IData)this.doRecordDecode((ElementNode)rootData, true, javaclass);
    }

    String pad(int len) {
        if (!this.pretty) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private boolean inHash(Writer stream, Object o, String name) throws IOException {
        if (!this.useOIDs || o == null) {
            return false;
        }
        Integer wo = (Integer)this.hash.get(o);
        if (wo == null) {
            this.hash.put(o, new Integer(this.nextID++));
            return false;
        }
        stream.write(Strings.cat(this.pad(this.nest + 1), "<" + objectTag.toString(), this.attrEncode("idref", wo.toString()), this.attrEncode("name", name), CLOSE_TAG, this.pretty ? "\n" : ""));
        return true;
    }

    private String attrEncode(String attr, String val) {
        if (val != null) {
            return Strings.cat(" ", attr, "=\"", val, "\"");
        }
        return "";
    }

    private String openTag(Name type, String name, Object o, String javaclass) {
        String depth = null;
        String subtype = null;
        String oid = null;
        boolean value = false;
        if (this.useOIDs) {
            Integer i = (Integer)this.hash.get(o);
            if (i == null) {
                i = new Integer(this.nextID++);
                this.hash.put(o, i);
            }
            oid = i.toString();
        }
        if (o instanceof String) {
            value = true;
        } else if (o instanceof String[]) {
            subtype = valueTag.toString();
            depth = "1";
        } else if (o instanceof String[][]) {
            subtype = valueTag.toString();
            depth = "2";
        } else if (o instanceof IDataCodable[]) {
            subtype = idatacodableTag.toString();
            depth = "1";
        } else if (o instanceof IDataPortable[]) {
            subtype = idataportableTag.toString();
            depth = "1";
        } else if (o instanceof IData[]) {
            subtype = recordTag.toString();
            depth = "1";
        } else if (o instanceof Object[]) {
            int len = ((Object[])o).length;
            boolean isAllNull = true;
            Class firstNonNullClass = Object.class;
            for (int i = 0; i < len; ++i) {
                if (((Object[])o)[i] == null) continue;
                firstNonNullClass = ((Object[])o)[i].getClass();
                isAllNull = false;
                break;
            }
            boolean same = true;
            if (firstNonNullClass == Object.class) {
                if (isAllNull) {
                    Class<?> componentType = o.getClass().getComponentType();
                    if (componentType.isArray()) {
                        same = false;
                    } else {
                        firstNonNullClass = componentType;
                    }
                } else {
                    same = false;
                }
            } else {
                for (int i = 0; i < len && (((Object[])o)[i] == null || (same = firstNonNullClass.isInstance(((Object[])o)[i]))); ++i) {
                }
            }
            if (!same) {
                subtype = objectTag.toString();
                depth = "1";
            } else {
                if (o instanceof Boolean[] || o instanceof Character[] || o instanceof Date[] || o instanceof Number[] || o instanceof Vector[]) {
                    subtype = objectTag.toString();
                    depth = "1";
                    try {
                        javaclass = firstNonNullClass.getName();
                    }
                    catch (Exception cce) {
                        javaclass = null;
                    }
                } else {
                    subtype = valueTag.toString();
                }
                depth = "1";
            }
        } else if (o instanceof Number) {
            subtype = o.getClass().getName();
            value = true;
        } else if (o instanceof MBoolean) {
            value = true;
        } else if (o instanceof Boolean) {
            value = true;
        } else if (o instanceof Date) {
            subtype = o.getClass().getName();
            value = true;
        } else if (o instanceof Character) {
            value = true;
        } else if (o instanceof GregorianCalendar) {
            value = true;
        }
        String tag = Strings.cat(type.toString(), this.attrEncode("name", name), this.attrEncode("type", subtype), this.attrEncode("depth", depth), this.attrEncode("id", oid), this.attrEncode("javaclass", javaclass));
        return Strings.cat(this.pretty ? this.pad(++this.nest) : "", "<", tag, ">", this.pretty && !value ? "\n" : "");
    }

    private String closeTag(Name type) {
        return this.closeTag(type, this.pretty);
    }

    private String closeTag(Name type, boolean pad) {
        String s = Strings.cat(pad ? this.pad(this.nest) : "", "</", type.toString(), ">", this.pretty ? "\n" : "");
        --this.nest;
        return s;
    }

    private void doEncode(Writer stream, String name, Object data) throws IOException {
        if (this.inHash(stream, data, name = XMLCoderHelper.encodeString(name))) {
            return;
        }
        if (data == null) {
            stream.write(Strings.cat(this.pad(this.nest + 1), "<", nullTag.toString(), name != null ? Strings.cat(" name=\"", name, "\"") : "", CLOSE_TAG, this.pretty ? "\n" : ""));
            return;
        }
        if (data instanceof ValuesCodable) {
            data = ((ValuesCodable)data).getValues();
        } else if (data instanceof StringCodable) {
            data = ((StringCodable)data).getValue();
        }
        if (data instanceof IDataCodable && !(data instanceof Table)) {
            IData idat = ((IDataCodable)data).getIData();
            IDataCursor c = idat.getCursor();
            stream.write(this.openTag(idatacodableTag, name, data, IDataXMLCoder.getEquiv(data.getClass().getName())));
            while (c.next()) {
                this.doEncode(stream, c.getKey(), c.getValue());
            }
            c.destroy();
            stream.write(this.closeTag(idatacodableTag));
        } else if (data instanceof IData) {
            stream.write(this.openTag(recordTag, name, data, IDataXMLCoder.getEquiv(data.getClass().getName())));
            IDataCursor c = ((IData)data).getCursor();
            while (c.next()) {
                this.doEncode(stream, c.getKey(), c.getValue());
            }
            c.destroy();
            stream.write(this.closeTag(recordTag));
        } else if (data instanceof IDataPortable && !(data instanceof Table)) {
            IData idat = ((IDataPortable)data).getAsData();
            IDataCursor c = idat.getCursor();
            stream.write(this.openTag(idataportableTag, name, data, data.getClass().getName()));
            while (c.next()) {
                this.doEncode(stream, c.getKey(), c.getValue());
            }
            c.destroy();
            stream.write(this.closeTag(idataportableTag));
        } else if (data instanceof Codable) {
            stream.write(this.openTag(recordTag, name, data, data.getClass().getName()));
            String[] k = ((Codable)data).getValueKeys();
            for (int i = 0; i < k.length; ++i) {
                this.doEncode(stream, k[i], ((Codable)data).getValue(k[i]));
            }
            stream.write(this.closeTag(recordTag));
        } else if (data instanceof Vector) {
            stream.write(this.openTag(listTag, name, data, null));
            for (int i = 0; i < ((Vector)data).size(); ++i) {
                this.doEncode(stream, null, ((Vector)data).elementAt(i));
            }
            stream.write(this.closeTag(listTag));
        } else if (data instanceof Float) {
            stream.write(this.openTag(floatTag, name, data, null));
            stream.write(((Float)data).toString());
            stream.write(this.closeTag(floatTag, false));
        } else if (data instanceof Double) {
            stream.write(this.openTag(doubleTag, name, data, null));
            stream.write(((Double)data).toString());
            stream.write(this.closeTag(doubleTag, false));
        } else if (data instanceof Number) {
            stream.write(this.openTag(numberTag, name, data, null));
            stream.write(((Number)data).toString());
            stream.write(this.closeTag(numberTag, false));
        } else if (data instanceof MBoolean) {
            stream.write(this.openTag(booleanTag, name, data, null));
            stream.write(((MBoolean)data).toString());
            stream.write(this.closeTag(booleanTag, false));
        } else if (data instanceof String) {
            stream.write(this.openTag(valueTag, name, data, null));
            String dStr = (String)data;
            int iLength = dStr.length();
            for (int i = 0; i < iLength; ++i) {
                char ch = dStr.charAt(i);
                if (ch == '<') {
                    stream.write("&lt;");
                    continue;
                }
                if (ch == '>') {
                    stream.write("&gt;");
                    continue;
                }
                if (ch == '&') {
                    stream.write("&amp;");
                    continue;
                }
                stream.write(ch);
            }
            stream.write(this.closeTag(valueTag, false));
        } else if (data instanceof Boolean) {
            stream.write(this.openTag(jbooleanTag, name, data, null));
            stream.write(((Boolean)data).toString());
            stream.write(this.closeTag(jbooleanTag, false));
        } else if (data instanceof Date) {
            stream.write(this.openTag(dateTag, name, data, null));
            if (data instanceof Timestamp) {
                stream.write(((Timestamp)data).toString());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.US);
                stream.write(sdf.format((Date)data));
            }
            stream.write(this.closeTag(dateTag, false));
        } else if (data instanceof Character) {
            stream.write(this.openTag(CharacterTag, name, data, null));
            Character Cha = (Character)data;
            char ch = Cha.charValue();
            if (ch == '<') {
                stream.write("&lt;");
            } else if (ch == '>') {
                stream.write("&gt;");
            } else if (ch == '&') {
                stream.write("&amp;");
            } else {
                stream.write(Cha.toString());
            }
            stream.write(this.closeTag(CharacterTag, false));
        } else if (data instanceof byte[]) {
            stream.write(this.openTag(byteTag, name, data, null));
            byte[] ba2 = Base64.encode((byte[])data, false);
            String tmp = new String(ba2);
            stream.write(tmp);
            stream.write(this.closeTag(byteTag));
        } else if (data instanceof Object[]) {
            stream.write(this.openTag(arrayTag, name, data, null));
            Object[] oArray = (Object[])data;
            int iLength = oArray.length;
            for (int i = 0; i < iLength; ++i) {
                this.doEncode(stream, null, oArray[i]);
            }
            stream.write(this.closeTag(arrayTag));
        } else {
            Object[] parms = new String[]{data.getClass().getName()};
            JournalLogger.log(7, 76, 2, parms);
            if (!this.ignoreInvalid) {
                throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_ENCODING, "", data.getClass().getName());
            }
            return;
        }
    }

    private String doStringDecode(ElementNode e) throws IOException, WMDocumentException {
        return (String)this.putHash(e.getText(), e);
    }

    private Number doNumberDecode(ElementNode e) throws IOException {
        Number n;
        String type = this.attribute(e, typeName);
        try {
            Class[] cs = new Class[]{Class.forName("java.lang.String")};
            Class cl = this.loadClass(type);
            Constructor cn = cl.getConstructor(cs);
            Object[] sig = new Object[]{e.getText()};
            n = (Number)cn.newInstance(sig);
        }
        catch (Exception ex) {
            Object[] subs = new String[]{type, ex.toString()};
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING, "", subs);
        }
        return (Number)this.putHash(n, e);
    }

    private Number doFloatDecode(ElementNode e) throws IOException {
        Float n;
        String type = this.attribute(e, typeName);
        try {
            String floatStr = e.getText();
            n = floatStr.equals(NUMBER_NAN) ? new Float(Float.NaN) : (floatStr.equals(NUMBER_NEGATIVE_INFINITY) ? new Float(Float.NEGATIVE_INFINITY) : (floatStr.equals(NUMBER_POSITIVE_INFINITY) ? new Float(Float.POSITIVE_INFINITY) : new Float(floatStr)));
        }
        catch (Exception ex) {
            Object[] subs = new String[]{type, ex.toString()};
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING, "", subs);
        }
        return (Number)this.putHash(n, e);
    }

    private Number doDoubleDecode(ElementNode e) throws IOException {
        Double n;
        String type = this.attribute(e, typeName);
        try {
            String doubleStr = e.getText();
            n = doubleStr.equals(NUMBER_NAN) ? new Double(Double.NaN) : (doubleStr.equals(NUMBER_NEGATIVE_INFINITY) ? new Double(Double.NEGATIVE_INFINITY) : (doubleStr.equals(NUMBER_POSITIVE_INFINITY) ? new Double(Double.POSITIVE_INFINITY) : new Double(doubleStr)));
        }
        catch (Exception ex) {
            Object[] subs = new String[]{type, ex.toString()};
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING, "", subs);
        }
        return (Number)this.putHash(n, e);
    }

    public Character doCharacterDecode(ElementNode e) throws IOException {
        Character C = null;
        try {
            C = new Character(e.getText().charAt(0));
        }
        catch (Throwable t) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_1, "", t.toString());
        }
        return (Character)this.putHash(C, e);
    }

    private MBoolean doBooleanDecode(ElementNode e) throws IOException {
        MBoolean b = null;
        try {
            b = new MBoolean(e.getText());
        }
        catch (Exception ex) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_1, "", ex.toString());
        }
        return (MBoolean)this.putHash(b, e);
    }

    private Boolean doJBooleanDecode(ElementNode e) throws IOException {
        Boolean b = null;
        try {
            b = new Boolean(e.getText());
        }
        catch (Exception ex) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_1, "", ex.toString());
        }
        return (Boolean)this.putHash(b, e);
    }

    private Date doDateDecode(ElementNode e) throws IOException {
        Date d = null;
        String type = this.attribute(e, typeName);
        try {
            if (type == null || "".equals(type)) {
                type = "java.util.Date";
            }
            Class cl = this.loadClass(type);
            Class timestampCls = this.loadClass("java.sql.Timestamp");
            if (timestampCls.isAssignableFrom(cl)) {
                d = Timestamp.valueOf(e.getText());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.US);
                Date tmpDate = sdf.parse(e.getText());
                Constructor cn = cl.getConstructor(Long.TYPE);
                Object[] sig = new Object[]{new Long(tmpDate.getTime())};
                d = (Date)cn.newInstance(sig);
            }
        }
        catch (Exception ex) {
            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_1, "", ex.toString());
        }
        return (Date)this.putHash(d, e);
    }

    private Object doArrayDecode(ElementNode e) throws IOException, WMDocumentException {
        if (this.name(e) == objectTag) {
            return this.getHash(e);
        }
        if (this.name(e) == nullTag) {
            return null;
        }
        String t = this.attribute(e, typeName);
        String d = this.attribute(e, depthName);
        if (t == null) {
            return null;
        }
        int depth = d != null ? Integer.parseInt(d) : 1;
        Name type = Name.create(t);
        return this.doArrayDecode(e, type, depth);
    }

    private Object doArrayDecode(ElementNode e, Name type, int depth) throws IOException, WMDocumentException {
        String javaclass;
        String[][] co;
        boolean objectType = type == objectTag;
        boolean allIDataValues = true;
        if (this.name(e) == objectTag) {
            return this.getHash(e);
        }
        ElementNode[] c = this.children(e, depth > 1 ? arrayTag : type);
        if (c == null) {
            return null;
        }
        if (depth == 2) {
            co = new String[c.length][];
        } else if (type == valueTag) {
            co = new String[c.length];
        } else if (type == objectTag) {
            co = new Object[c.length];
            javaclass = this.attribute(e, javaClassName);
            if (javaclass == null) {
                co = new Object[c.length];
            } else {
                try {
                    co = (Object[])Array.newInstance(this.loadClass(javaclass), c.length);
                }
                catch (Exception cce) {
                    co = new Object[c.length];
                }
            }
        } else {
            co = type == idatacodableTag ? new IDataCodable[c.length] : (type == idataportableTag ? new IDataPortable[c.length] : new IData[c.length]);
        }
        for (int i = 0; i < c.length; ++i) {
            ElementNode ne = c[i];
            if (this.name(ne) == objectTag) {
                co[i] = this.getHash(ne);
                continue;
            }
            if (this.name(ne) == nullTag) {
                co[i] = null;
                continue;
            }
            if (depth > 1) {
                co[i] = this.doArrayDecode(ne, type, depth - 1);
                continue;
            }
            if (objectType) {
                type = this.name(ne);
            }
            if (type == valueTag) {
                if (this.name(ne) == nullTag) continue;
                co[i] = this.doStringDecode(ne);
                continue;
            }
            if (type == idatacodableTag) {
                javaclass = this.attribute(ne, javaClassName);
                co[i] = (IDataCodable)this.doRecordDecode(ne, true, javaclass);
                continue;
            }
            if (type == idataportableTag) {
                javaclass = this.attribute(ne, javaClassName);
                co[i] = (IDataPortable)this.doRecordDecode(ne, true, javaclass);
                continue;
            }
            if (type == recordTag) {
                javaclass = this.attribute(ne, javaClassName);
                co[i] = this.doRecordDecode(ne, true, javaclass);
                if (co[i] instanceof Values) continue;
                allIDataValues = false;
                continue;
            }
            co[i] = type == listTag ? (Vector)this.doRecordDecode(ne, false, null) : (type == floatTag ? this.doFloatDecode(ne) : (type == doubleTag ? this.doDoubleDecode(ne) : (type == numberTag ? this.doNumberDecode(ne) : (type == jbooleanTag ? this.doJBooleanDecode(ne) : (type == booleanTag ? this.doBooleanDecode(ne) : (type == CharacterTag ? this.doCharacterDecode(ne) : (type == dateTag ? this.doDateDecode(ne) : null)))))));
        }
        if (depth == 2) {
            if (type == valueTag) {
                return this.putHash(co, e);
            }
        } else if (!objectType) {
            if (type == valueTag) {
                return this.putHash((String[])co, e);
            }
            if (type == recordTag) {
                if (co instanceof IData[] && allIDataValues) {
                    Values[] va = new Values[co.length];
                    System.arraycopy(co, 0, va, 0, co.length);
                    co = va;
                }
                return this.putHash((IData[])co, e);
            }
        }
        return this.putHash(co, e);
    }

    private Object doBytesDecode(ElementNode ne) throws IOException, WMDocumentException {
        byte[] b = null;
        String tmp = this.doStringDecode(ne);
        b = tmp.getBytes();
        b = Base64.decode(b);
        return b;
    }

    private Name name(ElementNode e) {
        return e.getLocalNameWm();
    }

    private ElementNode[] children(ElementNode e, Name type) throws WMDocumentException {
        List v = new List();
        List c = new List();
        Node node = e.getFirstChildWm();
        node = e.getFirstChildWm();
        while (node != null) {
            if (node.getNodeType() == 1) {
                v.addElement(node);
            }
            node = e.getNextSiblingOfChild(node);
        }
        for (int i = 0; i < v.size(); ++i) {
            ElementNode ne = (ElementNode)v.elementAt(i);
            Name n = this.name(ne);
            if (type == objectTag && n != null) {
                c.addElement(ne);
                continue;
            }
            if (n != type && n != nullTag && n != objectTag) continue;
            c.addElement(ne);
        }
        Object[] ret = new ElementNode[c.size()];
        c.copyInto(ret);
        return ret;
    }

    private Object getHash(ElementNode e) {
        String oid = this.attribute(e, idrefName);
        Object o = this.hash.get(oid);
        return o;
    }

    private Object putHash(Object o, ElementNode e) {
        String oid;
        if (this.useOIDs && o != null && (oid = this.attribute(e, idName)) != null) {
            this.hash.put(oid, o);
        }
        return o;
    }

    private String attribute(ElementNode e, Name attrName) {
        return e.getAttributeValue(null, attrName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object doRecordDecode(ElementNode e, boolean withNames, String asClass) throws IOException {
        Object ret;
        if (this.name(e) == objectTag) {
            return this.getHash(e);
        }
        if (this.name(e) == nullTag) {
            return null;
        }
        IData idata = null;
        if (withNames) {
            if (asClass == null) {
                idata = IDataFactory.create();
                ret = idata;
            } else {
                try {
                    Class[] parmTypes = new Class[]{};
                    Object[] initArgs = new Object[]{};
                    Class clazz = this.loadClass(asClass);
                    if (Class.forName("com.wm.data.IData").isAssignableFrom(clazz)) {
                        Method meth = clazz.getMethod("create", parmTypes);
                        if (meth == null) {
                            throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_RECORDDECODE, "", asClass);
                        }
                        ret = (IData)meth.invoke(null, initArgs);
                    } else {
                        ret = clazz.newInstance();
                    }
                }
                catch (Exception ex) {
                    Object[] subs = new String[]{asClass, ex.toString()};
                    throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING, "", subs);
                }
                if (ret instanceof IDataCodable) {
                    idata = IDataFactory.create();
                } else if (ret instanceof IData) {
                    idata = (IData)ret;
                } else if (ret instanceof Codable) {
                    idata = IDataFactory.create();
                } else {
                    if (!(ret instanceof IDataPortable)) throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", asClass);
                    idata = IDataFactory.create();
                }
            }
        } else {
            ret = new Vector();
        }
        List c = new List();
        try {
            Node node = e.getFirstChildWm();
            node = e.getFirstChildWm();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    c.addElement(node);
                }
                node = e.getNextSiblingOfChild(node);
            }
            if (c == null) return this.putHash(ret, e);
            IDataCursor cur = null;
            for (int i = 0; i < c.size(); ++i) {
                ElementNode ne = (ElementNode)c.elementAt(i);
                Name n = ne.getLocalNameWm();
                if (n != null) {
                    Object v;
                    String nm = this.attribute(ne, nameName);
                    String cl = this.attribute(ne, javaClassName);
                    if (n == recordTag) {
                        v = this.doRecordDecode(ne, true, cl);
                    } else if (n == idatacodableTag) {
                        v = this.doRecordDecode(ne, true, cl);
                    } else if (n == idataportableTag) {
                        v = this.doRecordDecode(ne, true, cl);
                    } else if (n == listTag) {
                        v = this.doRecordDecode(ne, false, null);
                    } else if (n == arrayTag) {
                        v = this.doArrayDecode(ne);
                    } else if (n == valueTag) {
                        v = this.doStringDecode(ne);
                    } else if (n == floatTag) {
                        v = this.doFloatDecode(ne);
                    } else if (n == doubleTag) {
                        v = this.doDoubleDecode(ne);
                    } else if (n == numberTag) {
                        v = this.doNumberDecode(ne);
                    } else if (n == booleanTag) {
                        v = this.doBooleanDecode(ne);
                    } else if (n == jbooleanTag) {
                        v = this.doJBooleanDecode(ne);
                    } else if (n == dateTag) {
                        v = this.doDateDecode(ne);
                    } else if (n == CharacterTag) {
                        v = this.doCharacterDecode(ne);
                    } else if (n == objectTag) {
                        v = this.getHash(ne);
                    } else if (n == byteTag) {
                        v = this.doBytesDecode(ne);
                    } else {
                        if (n != nullTag) throw new InvalidDatatypeException(CoderExceptionBundle.class, CoderExceptionBundle.IDATAXMLCODER_DECODING_2, "", n.toString());
                        v = null;
                    }
                    if (ret instanceof IData || ret instanceof IDataCodable || ret instanceof IDataPortable) {
                        if (cur == null) {
                            cur = idata.getCursor();
                            cur.last();
                        }
                        if (nm != null) {
                            cur.insertAfter(XMLCoderHelper.decodeString(nm), v);
                        } else {
                            cur.insertAfter("", v);
                        }
                    } else if (ret instanceof Vector) {
                        ((Vector)ret).addElement(v);
                    } else if (ret instanceof Codable) {
                        ((Codable)ret).setValue(nm, v);
                    }
                }
                if (cur == null) continue;
                cur.destroy();
                cur = null;
            }
            if (ret instanceof IDataCodable) {
                ((IDataCodable)ret).setIData(idata);
                return this.putHash(ret, e);
            } else {
                if (!(ret instanceof IDataPortable)) return this.putHash(ret, e);
                ((IDataPortable)ret).setFromData(idata);
            }
            return this.putHash(ret, e);
        }
        catch (WMDocumentException ex) {
            Object[] parms = new String[]{ex.toString()};
            JournalLogger.log(8, 76, 2, parms);
        }
        return this.putHash(ret, e);
    }

    private void doGregorianCalendarEncode(Writer stream, String name, Object data) throws IOException {
        String src = this.openTag(gCalendarTag, name, data, null);
        src = src.replace('>', ' ');
        GregorianCalendar date = (GregorianCalendar)data;
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date.getTime());
        String sYear = String.valueOf(calendar.get(1));
        String sMonth = String.valueOf(calendar.get(2));
        String sDays = String.valueOf(calendar.get(5));
        String sHours = String.valueOf(calendar.get(11));
        String sMin = String.valueOf(calendar.get(12));
        String sSec = String.valueOf(calendar.get(13));
        String sMSec = String.valueOf(calendar.get(14));
        String time = date.getTime().toString();
        src = Strings.cat(src, this.attrEncode(MSEC.toString(), sMSec), this.attrEncode("time", time), CLOSE_TAG);
        stream.write(src);
        String s = this.pretty ? "\n" : "";
        --this.nest;
        stream.write(s);
    }

    private GregorianCalendar doGregorianCalendarDecode(ElementNode e) {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        try {
            String pattern = DATE_TIME_FORMAT;
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
            Name time = Name.create("time");
            Date d = sdf.parse(e.getAttributeValue(null, time));
            calendar.setTime(d);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return (GregorianCalendar)this.putHash(calendar, e);
    }

    public static void main(String[] args) throws Exception {
        IDataXMLCoder c = new IDataXMLCoder();
        Values v = new Values();
        byte[] bytes = new byte[255];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(-128 + i);
        }
        v.put("bytes", bytes);
        ByteOutputBuffer os = new ByteOutputBuffer();
        c.encode(os, v);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        IData id = c.decode(is);
        Values out = Values.use(id);
        byte[] bout = (byte[])out.get("bytes");
        boolean bad = false;
        for (int i = 0; i < bytes.length; ++i) {
            if (bout[i] != bytes[i]) {
                System.out.println("bytes[" + i + "] bad:" + bytes[i] + " output:" + bout[i]);
                bad = true;
                continue;
            }
            System.out.println("bytes[" + i + "] good:" + bytes[i]);
        }
        if (bad) {
            System.out.println("bad!");
        }
    }

    private String computeArrayType(Object[] array) {
        IntegerList iList = new IntegerList();
        Class<?> clazz = array.getClass();
        Object[] anArray = array;
        while (true) {
            iList.addInteger(anArray.length);
            clazz = clazz.getComponentType();
            if (!clazz.isArray()) break;
            anArray = (Object[])anArray[0];
        }
        int[] dimensions = new int[iList.size()];
        iList.copyInto(dimensions);
        StringBuffer sb = new StringBuffer();
        sb.append("javaType=");
        sb.append(clazz.getName());
        sb.append(" [");
        for (int i = 0; i < dimensions.length; ++i) {
            sb.append(dimensions[i]);
            sb.append(']');
            if (i + 1 >= dimensions.length) continue;
            sb.append('[');
        }
        return sb.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

