/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.util.coder.IDataCoderHashEntry;

final class IDataCoderHash {
    IDataCoderHashEntry[] hash = new IDataCoderHashEntry[113];
    int count = 0;
    boolean rehashed = false;

    IDataCoderHash() {
    }

    void put(Object key, int value) {
        IDataCoderHashEntry e;
        IDataCoderHashEntry[] h = this.hash;
        int hc = key.hashCode();
        int idx = (hc & Integer.MAX_VALUE) % h.length;
        boolean useEqMethod = false;
        if (key instanceof String || key instanceof Double || key instanceof Integer || key instanceof Long || key instanceof Float || key instanceof Boolean || key instanceof Byte || key instanceof Character || key instanceof Short) {
            useEqMethod = true;
        }
        if (useEqMethod) {
            e = h[idx];
            while (e != null) {
                if (e.hc == hc && (e.key == key || e.key.equals(key))) {
                    e.value = value;
                    return;
                }
                e = e.next;
            }
        } else {
            e = h[idx];
            while (e != null) {
                if (e.hc == hc && e.key == key) {
                    e.value = value;
                    return;
                }
                e = e.next;
            }
        }
        if (this.count >= h.length && !this.rehashed) {
            this.rehash();
        }
        e = new IDataCoderHashEntry();
        e.hc = hc;
        e.key = key;
        e.value = value;
        e.next = this.hash[idx];
        this.hash[idx] = e;
        ++this.count;
    }

    int get(Object key) {
        IDataCoderHashEntry[] h = this.hash;
        int hc = key.hashCode();
        int idx = (hc & Integer.MAX_VALUE) % h.length;
        boolean useEqMethod = false;
        if (key instanceof String || key instanceof Double || key instanceof Integer || key instanceof Long || key instanceof Float || key instanceof Boolean || key instanceof Byte || key instanceof Character || key instanceof Short) {
            useEqMethod = true;
        }
        if (useEqMethod) {
            IDataCoderHashEntry e = h[idx];
            while (e != null) {
                if (e.hc == hc && (e.key == key || e.key.equals(key))) {
                    return e.value;
                }
                e = e.next;
            }
        } else {
            IDataCoderHashEntry e = h[idx];
            while (e != null) {
                if (e.hc == hc && e.key == key) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return -1;
    }

    protected void rehash() {
        int oldCapacity = this.hash.length;
        IDataCoderHashEntry[] oldTable = this.hash;
        int newCapacity = (oldCapacity << 4) + 1;
        IDataCoderHashEntry[] newTable = new IDataCoderHashEntry[newCapacity];
        this.hash = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            IDataCoderHashEntry old = oldTable[i];
            while (old != null) {
                IDataCoderHashEntry e = old;
                old = old.next;
                int index = (e.key.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }
}

