/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import java.io.IOException;
import java.io.InputStream;

class IDataCoderBlockInputStream
extends InputStream {
    byte[] buf;
    int pos;
    int buflen;
    InputStream is;
    boolean done;

    public IDataCoderBlockInputStream(InputStream is) throws IOException {
        this.is = is;
        this.done = false;
        this.fill();
    }

    public int available() throws IOException {
        return this.buflen - this.pos;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int i) {
    }

    public synchronized void reset() {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.done) {
            return -1;
        }
        if (this.pos < this.buflen) {
            return this.buf[this.pos++] & 0xFF;
        }
        if (this.fill()) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.done) {
            return -1;
        }
        int olen = len;
        while (len > this.buflen - this.pos) {
            int avail = this.buflen - this.pos;
            System.arraycopy(this.buf, this.pos, b, off, avail);
            len -= avail;
            off += avail;
            if (this.fill()) continue;
            return olen - len;
        }
        if (len > 0) {
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
        }
        return olen;
    }

    public int skip(int len) throws IOException {
        if (this.pos >= this.buflen && !this.fill()) {
            return 0;
        }
        if (this.pos < this.buflen) {
            int min = Math.min(this.buflen - this.pos, len);
            this.pos += min;
            return min;
        }
        return 0;
    }

    public void finish() throws IOException {
        while (!this.done) {
            this.read();
        }
    }

    private boolean fill() throws IOException {
        if (this.done) {
            return false;
        }
        int len = (this.is.read() & 0xFF) << 8 | this.is.read() & 0xFF;
        if (this.buf == null || len > this.buf.length) {
            this.buf = new byte[len];
        }
        if (len == 0) {
            this.done = true;
            this.buflen = 0;
            this.pos = 0;
            return false;
        }
        this.buflen = len;
        while (len > 0) {
            len -= this.is.read(this.buf, this.buflen - len, len);
        }
        this.pos = 0;
        return true;
    }
}

