/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.IData;
import com.wm.security.Config;
import com.wm.util.coder.InvalidDatatypeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class IDataCoder {
    static Hashtable equiv = new Hashtable(10);

    static String getEquiv(String cname) {
        String other = (String)equiv.get(cname);
        return other != null ? other : cname;
    }

    public abstract String getContentType();

    public abstract void encode(OutputStream var1, IData var2) throws IOException, InvalidDatatypeException;

    public abstract IData decode(InputStream var1) throws IOException, InvalidDatatypeException;

    public byte[] encodeToBytes(IData data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os, data);
        return os.toByteArray();
    }

    public IData decodeFromBytes(byte[] b) throws IOException {
        return this.decode(new ByteArrayInputStream(b));
    }

    public void writeToFile(File f, IData v) throws IOException {
        BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(f));
        this.encode(w, v);
        ((OutputStream)w).flush();
        ((OutputStream)w).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IData readFromFile(File f) throws IOException {
        IData retval = null;
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(f));
            retval = this.decode(fis);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
        }
        return retval;
    }

    static {
        equiv.put("com.wm.app.b2b.services.CValues", "com.wm.data.BasicData");
        equiv.put("com.wm.adapter.sap.idoc.IDocSegment", "com.wm.adapter.sap.idoc.IDataSegment");
        equiv.put("com.wm.adapter.sap.idoc.IDocDocument", "com.wm.adapter.sap.idoc.IDataDocument");
        equiv.put("com.wm.adapter.sap.idoc.IDocDocumentList", "com.wm.adapter.sap.idoc.IDataDocumentList");
        Config.setupProviders();
    }
}

