/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.BasicIDataCodable;
import com.wm.data.BasicIDataPortable;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataDeserializable;
import com.wm.data.IDataPortable;
import com.wm.data.ISMemDataImpl;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.List;
import com.wm.util.LocalizedIOException;
import com.wm.util.Table;
import com.wm.util.ThreadSafeSimpleDateFormat;
import com.wm.util.Values;
import com.wm.util.codec.CodecObjectInputStream;
import com.wm.util.coder.Codable;
import com.wm.util.coder.DefaultReferenceManager;
import com.wm.util.coder.IDataCodable;
import com.wm.util.coder.IDataCoder;
import com.wm.util.coder.IDataCoderHash;
import com.wm.util.coder.IDataEntry;
import com.wm.util.coder.InvalidDatatypeException;
import com.wm.util.coder.ReferenceManager;
import com.wm.util.coder.RemoteReferenceCodable;
import com.wm.util.coder.StringCodable;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.coder.resources.CoderExceptionBundle;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class IDataBinCoder
extends IDataCoder {
    static final boolean debug = false;
    private static SimpleDateFormat _sdf;
    private static SimpleDateFormat _sdfOld;
    private static SimpleDateFormat _sdfSql;
    private static ThreadSafeSimpleDateFormat formatter;
    public static final int VERSION_4_0 = 2;
    public static final int VERSION_3_5 = 1;
    private static final int VERSION_WRITE_DT_IDATA_ENTRY = 2;
    static final int VERSION = 1;
    static final int INIT_HASH = 113;
    static final int ENCODE = 1;
    static final int DECODE = 2;
    static final String ctype = "application/x-wmidatabin";
    static final int LONG_DATA = 128;
    public static final int DT_OBJREF = 0;
    public static final int DT_UNKNOWN = 1;
    public static final int DT_NULL = 2;
    public static final int DT_BYTE_ARRAY = 3;
    public static final int DT_STRING = 4;
    public static final int DT_IDATA = 5;
    public static final int DT_LIST = 6;
    public static final int DT_TABLE = 7;
    public static final int DT_HASH = 8;
    public static final int DT_VECTOR = 9;
    public static final int DT_ARRAY = 10;
    public static final int DT_INTEGER = 11;
    public static final int DT_FLOAT = 12;
    public static final int DT_AS_STRING = 13;
    public static final int DT_CODABLE = 14;
    public static final int DT_REMOTE_REF = 15;
    public static final int DT_JAVA_SER = 16;
    public static final int DT_RREF_TABLE = 17;
    public static final int DT_IDATCODABLE = 18;
    public static final int DT_IDATA_ENTRY = 19;
    public static final int DT_IDATAPORTABLE = 20;
    public static final int DT_CHAR = 21;
    public static final String TYPE_REMOTE_REF = "com.wm.util.RemoteReference";
    public static final String NUMBER_NAN = "NaN";
    public static final String NUMBER_NEGATIVE_INFINITY = "-Infinity";
    public static final String NUMBER_POSITIVE_INFINITY = "Infinity";
    private int version;
    private int mode;
    private boolean gEncodeUnkAsStr;
    private ReferenceManager gRefMgr;
    private volatile transient IDataCoderHash objIn;
    private volatile transient Vector objOut;
    private int nextOID;
    private static ClassLoader cloader;
    private Object[] objArray = new Object[128];
    private boolean supportJavaSerializable = true;
    private boolean supportObjID = true;
    private ClassLoader priorityClassLoader;

    public IDataBinCoder() {
        this(new DefaultReferenceManager());
    }

    public IDataBinCoder(ClassLoader thePriorityClassLoader, ReferenceManager rm) {
        this(rm);
        this.setPriorityClassLoader(thePriorityClassLoader);
    }

    public IDataBinCoder(ClassLoader thePriorityClassLoader) {
        this(thePriorityClassLoader, new DefaultReferenceManager());
    }

    public IDataBinCoder(ReferenceManager rm) {
        this.gRefMgr = rm;
        this.gEncodeUnkAsStr = true;
        this.setVersion(IDataBinCoder.getHighestVersionSupported());
    }

    public int getVersion() {
        return this.version;
    }

    public static int getHighestVersionSupported() {
        return 1;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean getSupportJavaSerializable() {
        return this.supportJavaSerializable;
    }

    public void setSupportJavaSerializable(boolean support) {
        this.supportJavaSerializable = support;
    }

    public boolean getUseOIDs() {
        return this.supportObjID;
    }

    public void setUseOIDs(boolean support) {
        this.supportObjID = support;
    }

    public String getContentType() {
        return ctype;
    }

    public boolean getEncodeUnkAsString() {
        return this.gEncodeUnkAsStr;
    }

    public void setEncodeUnkAsString(boolean bVal) {
        this.gEncodeUnkAsStr = bVal;
    }

    public void encode(OutputStream os, IData data) throws IOException, InvalidDatatypeException {
        this.mode = 1;
        if (this.supportObjID) {
            this.objIn = new IDataCoderHash();
            this.nextOID = 0;
        }
        this._encode(os, new Integer(this.version));
        this._encode(os, data);
        os.flush();
    }

    public IData decode(InputStream is) throws IOException, InvalidDatatypeException {
        Integer ver;
        this.mode = 2;
        if (this.supportObjID) {
            this.objOut = new Vector(113);
            this.nextOID = 0;
        }
        if ((ver = (Integer)this._decode(is)) != null) {
            this.setVersion(ver);
        }
        if (this.getVersion() > 1) {
            throw new LocalizedIOException(CoderExceptionBundle.class, CoderExceptionBundle.IDATABINCODER_DECODE_IO, "", Integer.toString(this.version));
        }
        Object o = this._decode(is);
        return (IData)o;
    }

    public void writeHeader(OutputStream os, int length, int dtype) throws IOException {
        if (length > 255) {
            os.write(0x80 | dtype);
            this.writeInt(os, length);
        } else {
            os.write(dtype);
            os.write(length);
        }
    }

    public void writeInt(OutputStream os, int iv) throws IOException {
        os.write(iv >> 24 & 0xFF);
        os.write(iv >> 16 & 0xFF);
        os.write(iv >> 8 & 0xFF);
        os.write(iv & 0xFF);
    }

    public void writeCharArray(OutputStream os, char[] c) throws IOException {
        int i;
        byte[] temp = new byte[2048];
        int len = c.length;
        int loops = len / 1024;
        int remain = len % 1024 * 2;
        int cOff = 0;
        for (int loopCnt = 0; loopCnt < loops; ++loopCnt) {
            i = 0;
            while (i < 2048) {
                temp[i] = (byte)(c[cOff] >> 8 & 0xFF);
                temp[i + 1] = (byte)(c[cOff] & 0xFF);
                i += 2;
                ++cOff;
            }
            os.write(temp);
        }
        i = 0;
        while (i < remain) {
            temp[i] = (byte)(c[cOff] >> 8 & 0xFF);
            temp[i + 1] = (byte)(c[cOff] & 0xFF);
            i += 2;
            ++cOff;
        }
        os.write(temp, 0, remain);
    }

    public void _encode(OutputStream os, Object value) throws IOException {
        int vSize;
        if (this.supportObjID) {
            int id = this.nextOID++;
            if (value == null) {
                this.writeHeader(os, 0, 2);
                return;
            }
            int oid = this.objIn.get(value);
            if (oid >= 0) {
                this.writeHeader(os, oid, 0);
                return;
            }
            this.objIn.put(value, id);
        }
        if (value instanceof ValuesCodable) {
            value = ((ValuesCodable)value).getValues();
        } else if (value instanceof StringCodable) {
            value = ((StringCodable)value).getValue();
        }
        if (value instanceof RemoteReferenceCodable) {
            this.writeHeader(os, 1, 15);
            String key = ((RemoteReferenceCodable)value).getValue();
            this.gRefMgr.put(key, value);
            this._encode(os, key);
        } else if (value instanceof String) {
            String strTmp = (String)value;
            int len = strTmp.length();
            char[] c = new char[len];
            strTmp.getChars(0, len, c, 0);
            this.writeHeader(os, len, 4);
            if (len < 2048) {
                for (int i = 0; i < len; ++i) {
                    os.write(c[i] >> 8 & 0xFF);
                    os.write(c[i] & 0xFF);
                }
            } else {
                this.writeCharArray(os, c);
            }
        } else if (value instanceof IDataCodable && !(value instanceof Table)) {
            this.writeHeader(os, 1, 18);
            this._encode(os, IDataBinCoder.getEquiv(value.getClass().getName()));
            this._encode(os, ((IDataCodable)value).getIData());
        } else if (value instanceof IDataPortable && !(value instanceof Table)) {
            this.writeHeader(os, 1, 20);
            this._encode(os, IDataBinCoder.getEquiv(value.getClass().getName()));
            this._encode(os, ((IDataPortable)value).getAsData());
        } else if (value instanceof IData) {
            IDataCursor c = ((IData)value).getCursor();
            this.writeHeader(os, 1, 5);
            this._encode(os, IDataBinCoder.getEquiv(value.getClass().getName()));
            while (c.next()) {
                String k;
                if (this.getVersion() >= 2) {
                    this.writeHeader(os, 1, 19);
                }
                if ((k = c.getKey()) == null) continue;
                this._encode(os, k);
                this._encode(os, c.getValue());
            }
            c.destroy();
            if (this.getVersion() >= 2) {
                this.writeHeader(os, 0, 2);
            } else {
                this._encode(os, null);
            }
        } else if (value instanceof Table) {
            Table t = (Table)value;
            this.writeHeader(os, t.getRowCount(), 7);
            this._encode(os, t.getValue("name"));
            this._encode(os, t.getValue("cols"));
            this._encode(os, t.getValue("sizes"));
            this._encode(os, t.getValue("rows"));
        } else if (value instanceof List) {
            List v = (List)value;
            vSize = v.size();
            this.writeHeader(os, vSize, 6);
            for (int i = 0; i < vSize; ++i) {
                this._encode(os, v.elementAt(i));
            }
        } else if (value.getClass() == Hashtable.class) {
            Hashtable v = (Hashtable)value;
            this.writeHeader(os, v.size(), 8);
            Enumeration e = v.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                this._encode(os, k);
                this._encode(os, v.get(k));
            }
        } else if (value.getClass() == Vector.class) {
            Vector v = (Vector)value;
            vSize = v.size();
            this.writeHeader(os, vSize, 9);
            for (int i = 0; i < vSize; ++i) {
                this._encode(os, v.elementAt(i));
            }
        } else if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            this.writeHeader(os, b.length, 3);
            os.write(b);
        } else if (value instanceof RemoteReferenceCodable[][]) {
            RemoteReferenceCodable[][] o = (RemoteReferenceCodable[][])value;
            this.writeHeader(os, o.length, 17);
            this.writeInt(os, o[0].length);
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[0].length; ++j) {
                    String key;
                    if (o[i][j] != null) {
                        key = o[i][j].getValue();
                        this.gRefMgr.put(key, o[i][j]);
                    } else {
                        key = null;
                    }
                    this._encode(os, key);
                }
            }
        } else if (value instanceof Object[]) {
            Object[] o = (Object[])value;
            this.writeHeader(os, o.length, 10);
            Class<?> atype = o.getClass().getComponentType();
            if (o instanceof RemoteReferenceCodable[]) {
                this._encode(os, TYPE_REMOTE_REF);
            } else if (o instanceof ValuesCodable[] || o instanceof Values[]) {
                this._encode(os, "com.wm.util.Values");
            } else if (o instanceof StringCodable[]) {
                this._encode(os, "java.lang.String");
            } else {
                this._encode(os, IDataBinCoder.getEquiv(atype.getName()));
            }
            for (int i = 0; i < o.length; ++i) {
                this._encode(os, o[i]);
            }
        } else if (value instanceof Integer) {
            int iv = (Integer)value;
            this.writeHeader(os, 4, 11);
            this.writeInt(os, iv);
        } else if (value instanceof Float) {
            String fv = value.toString();
            this.writeHeader(os, 1, 12);
            this._encode(os, fv);
        } else if (value instanceof Character) {
            String ch = value.toString();
            this.writeHeader(os, 1, 21);
            this._encode(os, ch);
        } else if (value instanceof Codable) {
            Codable code = (Codable)value;
            String[] vk = code.getValueKeys();
            this.writeHeader(os, vk.length, 14);
            this._encode(os, IDataBinCoder.getEquiv(value.getClass().getName()));
            for (int i = 0; i < vk.length; ++i) {
                this._encode(os, vk[i]);
                this._encode(os, code.getValue(vk[i]));
            }
        } else if (value instanceof Number || value instanceof Boolean || value instanceof java.util.Date && value.getClass() != Time.class && value.getClass() != Timestamp.class) {
            Class<?> c = value.getClass();
            Field[] f = c.getDeclaredFields();
            this.writeHeader(os, 1, 13);
            this._encode(os, c.getName());
            if (value instanceof java.util.Date && c != Date.class) {
                this._encode(os, formatter.format((java.util.Date)value));
            } else {
                this._encode(os, value.toString());
            }
        } else if (this.supportJavaSerializable && value instanceof Serializable) {
            this.writeHeader(os, 1, 16);
            this.doJavaSerializationEncode(os, value);
        } else if (this.gEncodeUnkAsStr) {
            this.writeHeader(os, 1, 1);
            Class<?> c = value.getClass();
            this._encode(os, c.getName());
        } else {
            this.writeHeader(os, 0, 2);
        }
    }

    protected void doJavaSerializationEncode(OutputStream os, Object value) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(value);
    }

    public final int nextByte(InputStream is) throws IOException {
        int i = is.read();
        if (i < 0) {
            throw new EOFException();
        }
        return i;
    }

    public int readInt(InputStream is) throws IOException {
        return this.nextByte(is) << 24 | this.nextByte(is) << 16 | this.nextByte(is) << 8 | this.nextByte(is);
    }

    public String readString(InputStream is, int length) throws IOException {
        int read;
        if (length < 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        char[] data = new char[length];
        int offset = 0;
        int chunkSize = 4096;
        byte[] chunk = new byte[chunkSize];
        boolean hiByte = true;
        int b1 = 0;
        int b2 = 0;
        for (int remaining = length * 2; remaining > 0; remaining -= read) {
            if (remaining < chunkSize) {
                chunkSize = remaining;
            }
            if ((read = is.read(chunk, 0, chunkSize)) < 0) {
                throw new EOFException();
            }
            for (int i = 0; i < read; ++i) {
                if (hiByte) {
                    b1 = chunk[i] & 0xFF;
                } else {
                    b2 = chunk[i] & 0xFF;
                    data[offset] = (char)(b1 << 8 | b2);
                    ++offset;
                }
                hiByte = !hiByte;
            }
        }
        return new String(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object _decode(InputStream is) throws IOException {
        id = this.nextOID++;
        hdrByte = this.nextByte(is);
        if (hdrByte == -1) {
            return null;
        }
        dtype = hdrByte & 63;
        length = (hdrByte & 128) > 0 ? this.readInt(is) : this.nextByte(is);
        switch (dtype) {
            case 5: {
                classname = (String)this._decode(is);
                parmTypes = new Class[]{};
                initArgs = new Object[]{};
                try {
                    clazz = this.loadClass(classname);
                    meth = clazz.getMethod("create", parmTypes);
                    data = (IData)meth.invoke(null, initArgs);
                }
                catch (Throwable e) {
                    parms = new String[]{classname, "ISMemDataImpl", e.toString()};
                    JournalLogger.log(1, 76, 8, parms);
                    data = ISMemDataImpl.create();
                }
                if (data instanceof IDataDeserializable) {
                    i = 0;
                    while (true) {
                        this.setObjArrayEntry(i, (String)this._decode(is));
                        if (this.objArray[i++] == null) break;
                        this.setObjArrayEntry(i++, this._decode(is));
                    }
                    ((IDataDeserializable)data).deserialize(this.objArray);
                } else {
                    cur = data.getCursor();
                    if (this.getVersion() >= 2) {
                        ide = null;
                        while ((ide = this._decodeIDataEntry(ide, is)) != null) {
                            k = ide.getKey();
                            v = ide.getValue();
                            cur.insertAfter(k, v);
                        }
                    } else {
                        while ((k = (String)this._decode(is)) != null) {
                            v = this._decode(is);
                            cur.insertAfter(k, v);
                        }
                    }
                    cur.destroy();
                }
                ret /* !! */  = data;
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 18: {
                cname = (String)this._decode(is);
                data = (IData)this._decode(is);
                try {
                    c = this.loadClass(cname);
                    ct = new Class[]{};
                    oc = new Object[]{};
                    ctor = c.getConstructor(ct);
                    codeable = (IDataCodable)ctor.newInstance(oc);
                    codeable.setIData(data);
                    ret /* !! */  = codeable;
                }
                catch (Throwable e) {
                    parms = new String[]{cname, "BasicIDataCodable", e.toString()};
                    JournalLogger.log(2, 76, 8, parms);
                    ret /* !! */  = new BasicIDataCodable(data);
                }
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 20: {
                cname = (String)this._decode(is);
                data = (IData)this._decode(is);
                try {
                    c = this.loadClass(cname);
                    ct = new Class[]{};
                    oc = new Object[]{};
                    ctor = c.getConstructor(ct);
                    codeable = (IDataPortable)ctor.newInstance(oc);
                    codeable.setFromData(data);
                    ret /* !! */  = codeable;
                }
                catch (Throwable e) {
                    parms = new String[]{cname, "BasicIDataPortable", e.toString()};
                    JournalLogger.log(2, 76, 8, parms);
                    ret /* !! */  = new BasicIDataPortable(data);
                }
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 17: {
                width = this.readInt(is);
                refTab = new Object[length][width];
                for (i = 0; i < length; ++i) {
                    for (j = 0; j < width; ++j) {
                        key = (String)this._decode(is);
                        refTab[i][j] = this.gRefMgr.get(key);
                    }
                }
                this.putDecode(refTab, id);
                ret /* !! */  = refTab;
                break;
            }
            case 15: {
                key = (String)this._decode(is);
                ret /* !! */  = this.gRefMgr.get(key);
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 3: {
                b = new byte[length];
                blen = toRead = b.length;
                while (toRead > 0) {
                    toRead -= is.read(b, blen - toRead, toRead);
                }
                ret /* !! */  = b;
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 4: {
                ret /* !! */  = this.readString(is, length);
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 7: {
                t = new Table((String)this._decode(is), (String[])this._decode(is), (String[])this._decode(is));
                t.setValue("rows", (Vector)this._decode(is));
                ret /* !! */  = t;
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 6: {
                l = new List(length);
                ret /* !! */  = l;
                this.putDecode(ret /* !! */ , id);
                for (i = 0; i < length; ++i) {
                    l.addElement(this._decode(is));
                }
                break;
            }
            case 8: {
                h = new Hashtable<Object, Object>(length == 0 ? 1 : length);
                ret /* !! */  = h;
                this.putDecode(ret /* !! */ , id);
                for (i = 0; i < length; ++i) {
                    key = this._decode(is);
                    val = this._decode(is);
                    h.put(key, val);
                }
                break;
            }
            case 9: {
                vl = new Vector<Object>(length);
                ret /* !! */  = vl;
                this.putDecode(ret /* !! */ , id);
                for (i = 0; i < length; ++i) {
                    vl.addElement(this._decode(is));
                }
                break;
            }
            case 10: {
                atype = (String)this._decode(is);
                try {
                    o = atype != null && !atype.equalsIgnoreCase("com.wm.util.RemoteReference") ? (Object[])Array.newInstance(this.loadClass(atype), length) : new Object[length];
                }
                catch (Throwable e) {
                    parms = new String[]{atype};
                    JournalLogger.log(6, 76, 2, parms);
                    o = new Object[length];
                }
                ret /* !! */  = o;
                this.putDecode(ret /* !! */ , id);
                temp = null;
                for (i = 0; i < length; ++i) {
                    temp = this._decode(is);
                    try {
                        o[i] = temp;
                        continue;
                    }
                    catch (ArrayStoreException e) {
                        if (temp instanceof IData) {
                            array = new IData[length];
                            for (j = 0; j < i; ++j) {
                                array[j] = (IData)o[i];
                            }
                            array[j] = (IData)temp;
                            o = array;
                            continue;
                        }
                        array = new Object[length];
                        for (j = 0; j < i; ++j) {
                            array[j] = o[i];
                        }
                        array[j] = temp;
                        o = array;
                    }
                }
                ret /* !! */  = o;
                break;
            }
            case 11: {
                ret /* !! */  = new Integer(this.readInt(is));
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 12: {
                floatStr = (String)this._decode(is);
                ret /* !! */  = floatStr.equals("NaN") != false ? new Float(NaNf) : (floatStr.equals("-Infinity") != false ? new Float(-Infinityf) : (floatStr.equals("Infinity") != false ? new Float(Infinityf) : new Float(floatStr)));
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 21: {
                charStr = (String)this._decode(is);
                ret /* !! */  = charStr == null ? null : new Character(charStr.charAt(0));
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 14: {
                cname = (String)this._decode(is);
                try {
                    c = this.loadClass(cname);
                    ct = new Class[]{};
                    oc = new Object[]{};
                    code = (Codable)c.getConstructor(ct).newInstance(oc);
                    for (i = 0; i < length; ++i) {
                        code.setValue((String)this._decode(is), this._decode(is));
                    }
                    ret /* !! */  = code;
                }
                catch (IOException ie) {
                    parms = new String[]{cname, ie.toString()};
                    JournalLogger.log(3, 76, 2, parms);
                    ie.fillInStackTrace();
                    throw ie;
                }
                catch (Throwable e) {
                    parms = new String[]{cname, e.toString()};
                    JournalLogger.log(3, 76, 2, parms);
                    uv = new Values();
                    for (i = 0; i < length; ++i) {
                        uv.put((String)this._decode(is), this._decode(is));
                    }
                    ret /* !! */  = uv;
                }
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 13: {
                asdtype = null;
                sdval = null;
                try {
                    asdtype = (String)this._decode(is);
                    sdval = (String)this._decode(is);
                    if (!asdtype.equals("java.util.Date")) ** GOTO lbl247
                    try {
                        uv = IDataBinCoder._sdf;
                        synchronized (uv) {
                            ret /* !! */  = IDataBinCoder._sdf.parse(sdval);
                            ** GOTO lbl278
                        }
                    }
                    catch (ParseException pe) {
                        i = IDataBinCoder._sdfOld;
                        synchronized (i) {
                            ret /* !! */  = IDataBinCoder._sdfOld.parse(sdval);
                            ** GOTO lbl278
                        }
                    }
lbl247:
                    // 1 sources

                    if (!asdtype.equals("java.sql.Date")) ** GOTO lbl259
                    cal = Calendar.getInstance();
                    i = IDataBinCoder._sdfSql;
                    synchronized (i) {
                        d = IDataBinCoder._sdfSql.parse(sdval);
                    }
                    cal.setTime(d);
                    ret /* !! */  = new Date(cal.get(1) - 1900, cal.get(2), cal.get(5));
                    ** GOTO lbl278
lbl259:
                    // 1 sources

                    if (asdtype.equals("java.lang.Double")) {
                        ret /* !! */  = sdval.equals("NaN") ? new Double(NaN) : (sdval.equals("-Infinity") ? new Double(-Infinity) : (sdval.equals("Infinity") ? new Double(Infinity) : new Double(sdval)));
                    } else {
                        c = this.loadClass(asdtype);
                        f = c.getDeclaredFields();
                        ss = new String[]{sdval};
                        cc = new Class[]{sdval.getClass()};
                        ret /* !! */  = c.getConstructor(cc).newInstance(ss);
                    }
                }
                catch (IOException ie) {
                    parms = new String[]{asdtype, sdval, ie.toString()};
                    JournalLogger.log(4, 76, 2, parms);
                    ie.fillInStackTrace();
                    throw ie;
                }
                catch (Throwable e) {
                    ret /* !! */  = null;
                    parms = new String[]{asdtype, sdval, e.toString()};
                    JournalLogger.log(4, 76, 2, parms);
                }
lbl278:
                // 6 sources

                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 1: {
                sdtype = (String)this._decode(is);
                ret /* !! */  = sdtype;
                this.putDecode(ret /* !! */ , id);
                break;
            }
            case 0: {
                if (this.supportObjID) {
                    try {
                        ret /* !! */  = this.objOut.elementAt(length);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        ret /* !! */  = null;
                    }
                    break;
                }
                ret /* !! */  = null;
                break;
            }
            case 16: {
                ret /* !! */  = this.doJavaSerializationDecode(is);
                break;
            }
            case 2: {
                ret /* !! */  = null;
                break;
            }
            default: {
                ret /* !! */  = null;
            }
        }
        return ret /* !! */ ;
    }

    protected Object doJavaSerializationDecode(InputStream is) throws IOException {
        try {
            return new IDataBinCoderObjectInputStream(is).readObject();
        }
        catch (IOException ioe) {
            Object[] parms = new String[]{ioe.toString()};
            JournalLogger.log(5, 76, 1, parms);
            ioe.fillInStackTrace();
            throw ioe;
        }
        catch (Throwable e) {
            Object[] parms = new String[]{e.toString()};
            JournalLogger.log(5, 76, 1, parms);
            int size = 0;
            byte[] b = new byte[1024];
            while (size > 0) {
                is.read(b);
            }
            return null;
        }
    }

    void putDecode(Object val, int idx) {
        if (this.supportObjID) {
            int sz = this.objOut.size();
            if (idx == sz) {
                this.objOut.addElement(val);
            } else if (idx > sz) {
                for (int i = idx - sz; i > 0; --i) {
                    this.objOut.addElement(null);
                }
                this.objOut.addElement(val);
            } else {
                this.objOut.setElementAt(val, idx);
            }
        }
    }

    public static void setClassLoader(ClassLoader cl) {
        cloader = cl;
    }

    /*
     * Unable to fully structure code
     */
    private Class loadClass(String cname) throws ClassNotFoundException {
        block15: {
            clazz = null;
            if (this.getPriorityClassLoader() != null) {
                try {
                    clazz = this.getPriorityClassLoader().loadClass(cname);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = null;
                    JournalLogger.log(34, 76, 2);
                }
            }
            if (clazz != null) {
                return clazz;
            }
            tryCtxLoaderFirst = new Boolean(Config.getProperty("false", "watt.server.coder.bincoder.trycontextloaderfirst"));
            serverClsLoaderName = Config.getProperty("watt.server.serverclassloadername");
            isCtxLoaderTried = false;
            if (serverClsLoaderName == null) {
                tryCtxLoaderFirst = false;
            }
            if (tryCtxLoaderFirst && (loader = Thread.currentThread().getContextClassLoader()) != null && loader.getClass().getName().equals(serverClsLoaderName)) {
                try {
                    isCtxLoaderTried = true;
                    clazz = loader.loadClass(cname);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (IDataBinCoder.cloader == null) {
                try {
                    clazz = Class.forName(cname);
                }
                catch (ClassNotFoundException e) {
                    if (!isCtxLoaderTried) ** GOTO lbl36
                    throw e;
                }
            } else {
                try {
                    clazz = IDataBinCoder.cloader.loadClass(cname);
                }
                catch (ClassNotFoundException e) {
                    if (!isCtxLoaderTried) break block15;
                    throw e;
                }
            }
        }
        if (clazz == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
            clazz = loader.loadClass(cname);
        }
        return clazz;
    }

    private void setObjArrayEntry(int index, Object obj) {
        if (index < this.objArray.length) {
            this.objArray[index] = obj;
        } else {
            int len = this.objArray.length;
            Object[] newArray = new Object[len << 1];
            System.arraycopy(this.objArray, 0, newArray, 0, len);
            this.objArray = newArray;
            this.objArray[index] = obj;
        }
    }

    private IDataEntry _decodeIDataEntry(IDataEntry ide, InputStream is) throws IOException {
        int hdrByte = this.nextByte(is);
        if (hdrByte == -1) {
            return null;
        }
        int dtype = hdrByte & 0x3F;
        if ((hdrByte & 0x80) > 0) {
            int length = this.readInt(is);
        } else {
            int length = this.nextByte(is);
        }
        if (dtype == 19) {
            if (ide == null) {
                ide = new IDataEntry();
            }
            ide.setKey((String)this._decode(is));
            ide.setValue(this._decode(is));
            return ide;
        }
        return null;
    }

    public ClassLoader getPriorityClassLoader() {
        return this.priorityClassLoader;
    }

    public void setPriorityClassLoader(ClassLoader priorityClassLoader) {
        this.priorityClassLoader = priorityClassLoader;
    }

    static {
        formatter = new ThreadSafeSimpleDateFormat("EEE MMM dd HH:mm:ss zz yyyy SSS", 2, 5);
        formatter.setWaitTime(-1L);
        _sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zz yyyy SSS", Locale.US);
        _sdfOld = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        _sdfSql = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        _sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        cloader = null;
    }

    class IDataBinCoderObjectInputStream
    extends CodecObjectInputStream {
        public IDataBinCoderObjectInputStream(InputStream stream) throws IOException {
            super(stream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (IDataBinCoder.this.priorityClassLoader != null) {
                try {
                    return Class.forName(desc.getName(), false, IDataBinCoder.this.priorityClassLoader);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (cloader != null) {
                try {
                    return Class.forName(desc.getName(), false, cloader);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException e) {
                ClassNotFoundException notFound = e;
                throw notFound;
            }
        }
    }
}

