/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.util.Table;
import com.wm.util.Values;
import com.wm.util.coder.IDataBinCoder;

class CoderHelper {
    private String CPPKEY = "SDKCPPKEY";

    CoderHelper() {
    }

    public byte[] encodeToBytes(Object obj) {
        try {
            IData container = IDataFactory.create();
            IDataCursor idc = container.getCursor();
            idc.insertAfter(this.CPPKEY, obj);
            idc.destroy();
            IDataBinCoder idbc = new IDataBinCoder();
            byte[] ba = idbc.encodeToBytes(container);
            return ba;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object decodeFromBytes(byte[] serial) {
        try {
            IDataBinCoder idbc = new IDataBinCoder();
            IData container = idbc.decodeFromBytes(serial);
            IDataCursor idc = container.getCursor();
            if (idc.first(this.CPPKEY)) {
                return idc.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void log(String msg) {
        System.err.println(msg);
    }

    public static void main(String[] args) {
        CoderHelper ch = new CoderHelper();
        String s = new String("hello there");
        String sres = (String)ch.decodeFromBytes(ch.encodeToBytes(s));
        System.err.println("Original: " + s + " enc-dec: " + sres);
        Values val = new Values();
        val.put("Hello", "Hello");
        val.put("There", "There");
        Values valres = (Values)ch.decodeFromBytes(ch.encodeToBytes(val));
        System.err.println("Original: " + val + " enc-dec: " + valres);
        String[] keys = new String[]{"a", "b", "c"};
        Table vt = new Table("myTable", keys);
        Values row1 = new Values();
        row1.put("a", "a1");
        row1.put("b", "b1");
        row1.put("c", "c1");
        Values row2 = new Values();
        row2.put("a", "a2");
        row2.put("b", "b2");
        row2.put("c", "c2");
        vt.addRow(row1);
        vt.addRow(row2);
        Table tabres = (Table)ch.decodeFromBytes(ch.encodeToBytes(vt));
        System.err.println("Original: " + vt + " enc-dec: " + tabres);
    }
}

