/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import com.wm.security.Config;
import com.wm.util.Streams;
import com.wm.util.Values;
import com.wm.util.coder.InvalidDatatypeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Coder {
    static Values equiv;

    static String getEquiv(String cname) {
        String other = (String)equiv.get(cname);
        return other != null ? other : cname;
    }

    public abstract void encode(OutputStream var1, Values var2) throws IOException, InvalidDatatypeException;

    public abstract Values decode(InputStream var1) throws IOException, InvalidDatatypeException;

    public abstract String getContentType();

    public byte[] encodeToBytes(Values data) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os, data);
        return os.toByteArray();
    }

    public Values decodeFromBytes(byte[] b) throws IOException {
        return this.decode(new ByteArrayInputStream(b));
    }

    public void writeToFile(File f, Values v) throws IOException {
        BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(f));
        this.encode(w, v);
        ((OutputStream)w).flush();
        ((OutputStream)w).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values readFromFile(File f) throws IOException {
        Values retval = null;
        InputStream fis = null;
        if (!f.exists()) {
            throw new FileNotFoundException(f.getCanonicalPath());
        }
        try {
            fis = new BufferedInputStream(new FileInputStream(f));
            retval = this.decode(fis);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
        return retval;
    }

    public static byte[] readFully(InputStream is) throws IOException {
        return Streams.readFully(is);
    }

    static {
        Object[][] o = new Object[][]{{"watt.util.Values", "com.wm.util.Values"}, {"watt.util.Table", "com.wm.util.Table"}, {"com.wm.app.b2b.util.CValues", "com.wm.util.Values"}, {"com.wm.adapter.sap.idoc.IDocSegment", "com.wm.adapter.sap.idoc.IDataSegment"}, {"com.wm.adapter.sap.idoc.IDocDocument", "com.wm.adapter.sap.idoc.IDataDocument"}, {"com.wm.adapter.sap.idoc.IDocDocumentList", "com.wm.adapter.sap.idoc.IDataDocumentList"}};
        equiv = new Values(o);
        Config.setupProviders();
    }
}

