/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.coder;

import java.io.IOException;
import java.io.OutputStream;

class BlockOutputStream
extends OutputStream {
    byte[] buf;
    int written;
    int bsize;
    OutputStream os;

    public BlockOutputStream(OutputStream os) throws IOException {
        this(os, 4096);
    }

    public BlockOutputStream(OutputStream os, int bsize) throws IOException {
        this.os = os;
        this.written = 0;
        this.bsize = bsize;
        this.buf = new byte[bsize];
    }

    public void close() throws IOException {
        this.writeBuf();
    }

    public void flush() throws IOException {
        this.writeBuf();
    }

    public void write(int ch) throws IOException {
        this.buf[this.written++] = (byte)ch;
        if (this.written >= this.bsize) {
            this.writeBuf();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        while (this.written + len > this.bsize) {
            int max = this.bsize - this.written;
            System.arraycopy(b, off, this.buf, this.written, max);
            off += max;
            len -= max;
            this.written += max;
            this.writeBuf();
        }
        if (len > 0) {
            System.arraycopy(b, off, this.buf, this.written, len);
            this.written += len;
            if (this.written >= this.bsize) {
                this.writeBuf();
            }
        }
    }

    public void finish() throws IOException {
        if (this.written > 0) {
            this.writeBuf();
            this.writeBuf();
        } else {
            this.writeBuf();
        }
    }

    private void writeBuf() throws IOException {
        this.os.write(this.written >> 8 & 0xFF);
        this.os.write(this.written >> 0 & 0xFF);
        if (this.written > 0) {
            this.os.write(this.buf, 0, this.written);
        }
        this.written = 0;
        this.os.flush();
    }
}

