/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.codec;

import com.wm.data.DataException;
import com.wm.data.DataSharedCursorEmulator;
import com.wm.data.DataSharedTreeCursor;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataSharedCursor;
import com.wm.util.codec.Base64;
import com.wm.util.codec.TextMemData;
import com.wm.util.io.ByteOutputBuffer;
import com.wm.util.text.Strings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Stack;

public class TextDataCodec {
    private static final Class oclass = new Object().getClass();
    private static final Hashtable classHash = new Hashtable();
    private DataSharedTreeCursor tc;
    private int indent;
    private Arr array;
    private Stack arrays;

    public static String encode(IData data) throws DataException {
        IDataSharedCursor dc = data.getSharedCursor();
        String ret = TextDataCodec.encode(dc);
        dc.destroy();
        return ret;
    }

    public static String encode(IDataCursor dc) throws DataException {
        return TextDataCodec.encode(DataSharedCursorEmulator.create(dc));
    }

    public static String encode(IDataSharedCursor dc) throws DataException {
        StringBuffer sb = new StringBuffer();
        DataSharedTreeCursor tc = DataSharedTreeCursor.create(dc.getCursorClone());
        TextDataCodec.encode(tc, sb, new Hashtable(), 0);
        tc.destroy();
        return sb.toString();
    }

    private static void encode(DataSharedTreeCursor tc, StringBuffer buf, Hashtable refs, int ind) throws DataException {
        while (tc.next()) {
            TextDataCodec._encode(tc, buf, refs, ind, tc.getKey(), tc.getValue(), tc.getValueReference());
        }
    }

    private static void _encode(DataSharedTreeCursor tc, StringBuffer buf, Hashtable refs, int ind, String key, Object val, Object valRef) throws DataException {
        for (int i = 0; i < ind; ++i) {
            buf.append("\t");
        }
        String ref = null;
        if (valRef != null) {
            ref = (String)refs.get(valRef);
            if (ref == null) {
                refs.put(valRef, tc.getPath());
            } else {
                ref = Strings.cat("{", ref, "}");
            }
        }
        if (val instanceof IData) {
            buf.append(Strings.cat("[", key, "]"));
            if (ref != null) {
                buf.append(Strings.cat(" ", ref));
            }
            buf.append("\r\n");
            if (ref == null && tc.down()) {
                TextDataCodec.encode(tc, buf, refs, ind + 1);
                tc.up();
            }
        } else {
            if (key != null) {
                if (key.startsWith("[")) {
                    buf.append(key);
                } else if (key.indexOf(" ") >= 0 || key.indexOf("\t") >= 0) {
                    buf.append("\"");
                    buf.append(key);
                    buf.append("\"");
                } else {
                    buf.append(key);
                }
            }
            buf.append("=");
            if (ref != null) {
                buf.append(ref);
            } else if (val != null) {
                if (val instanceof String) {
                    buf.append(Strings.cat("\"", val.toString(), "\""));
                } else if (val instanceof Number) {
                    buf.append("#");
                    buf.append(classHash.get(val.getClass()));
                    buf.append(val.toString());
                } else {
                    if (val instanceof Object[]) {
                        int alen = Array.getLength(val);
                        buf.append("[");
                        buf.append(Integer.toString(alen));
                        buf.append("] ");
                        Class<?> mc = val.getClass().getComponentType();
                        if (mc != oclass) {
                            buf.append(mc.getName());
                        }
                        buf.append("\r\n");
                        for (int x = 0; x < alen; ++x) {
                            Object o = Array.get(val, x);
                            if (o == null) continue;
                            TextDataCodec._encode(tc, buf, refs, ind + 1, "[" + x + "]", o, null);
                        }
                        return;
                    }
                    if (val instanceof byte[]) {
                        buf.append("<");
                        buf.append(new String(Base64.encode((byte[])val, false)));
                        buf.append(">");
                    } else {
                        try {
                            buf.append("(");
                            ByteOutputBuffer bob = new ByteOutputBuffer();
                            ObjectOutputStream os = new ObjectOutputStream(bob);
                            os.writeObject(val);
                            os.flush();
                            os.close();
                            buf.append(new String(Base64.encode(bob.toByteArray(), false)));
                            buf.append(")");
                        }
                        catch (Exception e) {
                            buf.append("(ERR:" + e.toString() + ")");
                        }
                    }
                }
            }
            buf.append("\r\n");
        }
    }

    public static IData decode(String data) throws DataException {
        TextMemData d = new TextMemData();
        IDataSharedCursor dc = d.getSharedCursor();
        TextDataCodec.decode(dc, data);
        dc.destroy();
        return d;
    }

    private TextDataCodec() {
        classHash.put(new Byte("1").getClass(), "b");
        classHash.put(new Short("1").getClass(), "s");
        classHash.put(new Integer("1").getClass(), "i");
        classHash.put(new Long("1").getClass(), "l");
        classHash.put(new Float("1").getClass(), "f");
        classHash.put(new Double("1").getClass(), "d");
        this.arrays = new Stack();
    }

    public static void decode(IDataCursor dc, String data) throws DataException {
        TextDataCodec.decode(DataSharedCursorEmulator.create(dc), data);
    }

    public static void decode(IDataSharedCursor dc, String data) throws DataException {
        new TextDataCodec()._decode(dc, data);
    }

    private void _decode(IDataSharedCursor dc, String data) throws DataException {
        this.indent = 0;
        this.tc = DataSharedTreeCursor.create(dc.getCursorClone());
        BufferedReader r = new BufferedReader(new StringReader(data));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                this._decode(line);
            }
            if (this.array != null) {
                this.tc.insertAfter(this.array.key, this.array.val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tc.destroy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _decode(String line) throws Exception {
        int nind = line.lastIndexOf("\t") + 1;
        if (nind > 0) {
            line = line.substring(nind);
        }
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return;
        }
        while (this.indent > nind) {
            if (this.array != null) {
                Arr narr;
                Arr arr = narr = this.arrays.empty() ? null : (Arr)this.arrays.pop();
                if (narr != null) {
                    if (this.array.key != null && this.array.key.length() > 0) {
                        narr.index = Integer.parseInt(this.array.key);
                    }
                    Array.set(narr.val, narr.index++, this.array.val);
                    this.array = narr;
                } else {
                    this.tc.insertAfter(this.array.key, this.array.val);
                    this.array = null;
                }
            } else {
                this.tc.up();
            }
            --this.indent;
        }
        if (this.array == null && line.charAt(0) == '[') {
            String key = line.substring(1, line.indexOf("]"));
            int refi = line.indexOf("{");
            if (refi > 0) {
                String ref = line.substring(refi + 1, line.length() - 1);
                DataSharedTreeCursor cc = (DataSharedTreeCursor)this.tc.getCursorClone();
                if (cc.navigate(ref)) {
                    this.tc.insertAfter(key, cc.getValueReference());
                } else {
                    System.out.println("unable to find '" + ref + "'");
                }
                cc.destroy();
                return;
            }
            this.tc.insertDataAfter(key);
            this.tc.down();
            ++this.indent;
            return;
        }
        int eq = line.indexOf("=");
        String key = line.substring(0, eq).trim();
        String val = line.substring(eq + 1).trim();
        if (key.length() == 0) {
            key = null;
        } else {
            char c = key.charAt(0);
            if (c == '\"' || c == '[') {
                key = key.substring(1, key.length() - 1);
            }
        }
        Object nval = null;
        int vlen = val.length();
        if (vlen == 0) {
            nval = null;
        } else {
            block1 : switch (val.charAt(0)) {
                case '\"': {
                    nval = val.substring(1, vlen - 1);
                    break;
                }
                case '#': {
                    String num = val.substring(2).trim();
                    switch (val.charAt(1)) {
                        case 'b': {
                            nval = new Byte(num);
                            break block1;
                        }
                        case 's': {
                            nval = new Short(num);
                            break block1;
                        }
                        case 'i': {
                            nval = new Integer(num);
                            break block1;
                        }
                        case 'l': {
                            nval = new Long(num);
                            break block1;
                        }
                        case 'f': {
                            nval = new Float(num);
                            break block1;
                        }
                        case 'd': {
                            nval = new Double(num);
                            break block1;
                        }
                    }
                    nval = val;
                    break;
                }
                case '{': {
                    val = val.substring(1, vlen - 1);
                    DataSharedTreeCursor cc = (DataSharedTreeCursor)this.tc.getCursorClone();
                    if (cc.navigate(val)) {
                        nval = cc.getValueReference();
                    } else {
                        System.out.println("unable to find '" + val + "'");
                    }
                    cc.destroy();
                    break;
                }
                case '[': {
                    int rb = val.indexOf("]");
                    int sz = Integer.parseInt(val.substring(1, rb));
                    String clazz = val.substring(rb + 1).trim();
                    if (this.array != null) {
                        this.arrays.push(this.array);
                    }
                    this.array = new Arr();
                    if (clazz == null || clazz.length() == 0) {
                        this.array.val = new Object[sz];
                    } else {
                        Class<?> cz = Class.forName(clazz);
                        try {
                            this.array.val = Array.newInstance(cz, sz);
                        }
                        catch (Exception e) {
                            this.array.val = new Object[sz];
                        }
                    }
                    this.array.key = key;
                    this.array.index = 0;
                    ++this.indent;
                    return;
                }
                case '<': {
                    val = val.substring(1, vlen - 1);
                    nval = Base64.decode(val.getBytes());
                    break;
                }
                case '(': {
                    val = val.substring(1, vlen - 1);
                    ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(Base64.decode(val.getBytes())));
                    nval = is.readObject();
                    is.close();
                    break;
                }
                default: {
                    nval = val;
                }
            }
        }
        if (this.array != null) {
            if (key != null && key.length() > 0) {
                this.array.index = Integer.parseInt(key);
            }
            Array.set(this.array.val, this.array.index++, nval);
            return;
        } else {
            this.tc.insertAfter(key, nval);
        }
    }

    class Arr {
        private String key;
        private Object val;
        private int index;

        Arr() {
        }
    }
}

