/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.codec;

import com.wm.io.codec.IDecodeContainer;
import com.wm.io.codec.IObjectReference;
import com.wm.io.codec.IObjectReferer;
import java.util.Hashtable;

public final class SimpleReferenceManager
implements IObjectReferer {
    private Hashtable hash;
    private int nextEnc;
    private int nextDec;

    public SimpleReferenceManager() {
        this.hash = new Hashtable();
    }

    public SimpleReferenceManager(int size) {
        this.hash = new Hashtable(size);
    }

    public IObjectReference beginEncode(Object toEncode) {
        ++this.nextEnc;
        if (toEncode == null) {
            return null;
        }
        IObjectReference sub = (IObjectReference)this.hash.get(toEncode);
        if (sub != null) {
            return sub;
        }
        this.hash.put(toEncode, new REF(this.nextEnc));
        return null;
    }

    public IDecodeContainer beginDecode() {
        ++this.nextDec;
        return new DEC(this.nextDec);
    }

    public void clear() {
        this.hash.clear();
        this.nextEnc = 0;
        this.nextDec = 0;
    }

    private final class REF
    implements IObjectReference {
        private Integer ref;

        REF(int id) {
            this.ref = new Integer(id);
        }

        public Object getReferenceValue() {
            return this.ref;
        }

        public String toString() {
            return "(ref:" + this.ref + ")";
        }
    }

    private final class DEC
    implements IDecodeContainer {
        private Object ref;

        DEC(int id) {
            this.ref = new Integer(id);
        }

        public void setDecodedValue(Object obj) {
            if (obj != null) {
                SimpleReferenceManager.this.hash.put(this.ref, obj);
            }
        }

        public void setReferenceValue(Object obj) {
            this.ref = obj;
        }

        public Object getValue() {
            return SimpleReferenceManager.this.hash.get(this.ref);
        }
    }
}

