/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class CodecObjectInputStream
extends ObjectInputStream {
    private static ClassLoader cloader = null;

    public CodecObjectInputStream(InputStream stream) throws IOException {
        super(stream);
    }

    public static void setClassLoader(ClassLoader cl) {
        cloader = cl;
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        ClassNotFoundException notFound = null;
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            ClassLoader[] loaders;
            notFound = e;
            for (ClassLoader loader : loaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), cloader}) {
                if (loader == null) continue;
                try {
                    return loader.loadClass(desc.getName());
                }
                catch (ClassNotFoundException e2) {
                    notFound = e2;
                }
            }
            throw notFound;
        }
    }
}

