/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.codec;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.io.codec.CodecException;
import com.wm.io.codec.IDecodeContainer;
import com.wm.io.codec.IObjectCodec;
import com.wm.io.codec.IObjectReference;
import com.wm.io.codec.IObjectReferer;
import com.wm.util.BasisRuntimeException;
import com.wm.util.codec.CodecObjectInputStream;
import com.wm.util.data.MemData;
import com.wm.util.io.ByteOutputBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Date;

public class BinaryCodec
implements IObjectCodec {
    private static final int version = 1;
    private static final int LONG_DATA = 128;
    private static final int DT_NULL = 0;
    protected static final int DT_OBJREF = 1;
    private static final int DT_STRING = 2;
    private static final int DT_DATA = 3;
    private static final int DT_CODABLE = 4;
    private static final int DT_BINARY = 5;
    private static final int DT_ARRAY = 6;
    private static final int DT_INTEGER = 7;
    private static final int DT_LONG = 8;
    private static final int DT_DOUBLE = 9;
    private static final int DT_FLOAT = 10;
    private static final int DT_SHORT = 11;
    private static final int DT_BOOLEAN = 12;
    private static final int DT_JAVA_SER = 13;
    private static final int DT_DATE1 = 14;
    private static final int DT_BYTE = 15;
    private static Object[] initArgs = new Object[0];
    private static Class[] parmTypes = new Class[0];
    private static ClassLoader globalLoader = null;
    private int asVersion;

    public BinaryCodec() {
        this(1);
    }

    public BinaryCodec(int asVersion) {
        if (asVersion > 1) {
            throw new BasisRuntimeException("BAC.0009.0031", new String[]{"version:" + asVersion + ">" + 1});
        }
        this.asVersion = asVersion;
    }

    public void encode(Object toEncode, OutputStream os, IObjectReferer referer) throws IOException, CodecException {
        os.write(this.asVersion);
        this._encode(os, toEncode, referer);
    }

    public Object decode(InputStream is, IObjectReferer referer) throws IOException, CodecException {
        this.asVersion = is.read();
        return this._decode(is, referer);
    }

    public static void setClassLoader(ClassLoader cl) {
        globalLoader = cl;
    }

    protected final void writeHeader(OutputStream os, int length, int dtype) throws IOException {
        if (length > 255 || length < 0) {
            os.write(0x80 | dtype);
            this.writeInt(os, length);
        } else {
            os.write(dtype);
            os.write(length);
        }
    }

    private final void writeShort(OutputStream os, int iv) throws IOException {
        os.write(iv >> 8 & 0xFF);
        os.write(iv & 0xFF);
    }

    private final void writeInt(OutputStream os, int iv) throws IOException {
        os.write(iv >> 24 & 0xFF);
        os.write(iv >> 16 & 0xFF);
        os.write(iv >> 8 & 0xFF);
        os.write(iv & 0xFF);
    }

    private final void writeLong(OutputStream os, long lv) throws IOException {
        os.write((int)(lv >> 56 & 0xFFL));
        os.write((int)(lv >> 48 & 0xFFL));
        os.write((int)(lv >> 40 & 0xFFL));
        os.write((int)(lv >> 32 & 0xFFL));
        os.write((int)(lv >> 24 & 0xFFL));
        os.write((int)(lv >> 16 & 0xFFL));
        os.write((int)(lv >> 8 & 0xFFL));
        os.write((int)(lv & 0xFFL));
    }

    protected void _encode(OutputStream os, Object value, IObjectReferer referer) throws IOException, CodecException {
        IObjectReference ref = referer.beginEncode(value);
        if (ref != null && !(value instanceof Integer)) {
            this.writeHeader(os, 0, 1);
            this._encode(os, ref.getReferenceValue(), referer);
            return;
        }
        if (value == null) {
            this.writeHeader(os, 0, 0);
        } else if (value instanceof String) {
            String stmp = (String)value;
            int len = stmp.length();
            char[] c = new char[len];
            stmp.getChars(0, len, c, 0);
            this.writeHeader(os, len, 2);
            for (int i = 0; i < len; ++i) {
                os.write(c[i] >> 8 & 0xFF);
                os.write(c[i] & 0xFF);
            }
        } else if (value instanceof IData) {
            this.writeHeader(os, 1, 3);
            IDataCursor c = ((IData)value).getCursor();
            this._encode(os, value.getClass().getName(), referer);
            while (c.next()) {
                String k = c.getKey();
                if (k == null) continue;
                this._encode(os, k, referer);
                this._encode(os, c.getValue(), referer);
            }
            c.destroy();
            this._encode(os, null, referer);
        } else if (value instanceof IDataPortable) {
            this.writeHeader(os, 1, 4);
            this._encode(os, value.getClass().getName(), referer);
            this._encode(os, ((IDataPortable)value).getAsData(), referer);
        } else if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            this.writeHeader(os, b.length, 5);
            os.write(b);
        } else if (value instanceof Object[]) {
            Object[] o = (Object[])value;
            this.writeHeader(os, o.length, 6);
            this._encode(os, o.getClass().getComponentType().getName(), referer);
            for (int i = 0; i < o.length; ++i) {
                this._encode(os, o[i], referer);
            }
        } else if (value instanceof Integer) {
            int iv = (Integer)value;
            this.writeHeader(os, iv, 7);
        } else if (value instanceof Long) {
            long lv = (Long)value;
            this.writeHeader(os, 8, 8);
            this.writeLong(os, lv);
        } else if (value instanceof Double) {
            long lv = Double.doubleToLongBits((Double)value);
            this.writeHeader(os, 8, 9);
            this.writeLong(os, lv);
        } else if (value instanceof Float) {
            int iv = Float.floatToIntBits(((Float)value).floatValue());
            this.writeHeader(os, iv, 10);
        } else if (value instanceof Short) {
            this.writeHeader(os, ((Short)value).intValue(), 11);
        } else if (value instanceof Boolean) {
            this.writeHeader(os, (Boolean)value != false ? 1 : 0, 12);
        } else if (value instanceof Date) {
            this.writeHeader(os, 1, 14);
            this.writeLong(os, ((Date)value).getTime());
        } else if (value instanceof Byte) {
            this.writeHeader(os, 1, 15);
            this.writeShort(os, ((Byte)value).byteValue());
        } else if (value instanceof Serializable) {
            ByteOutputBuffer bob = new ByteOutputBuffer();
            new ObjectOutputStream(bob).writeObject(value);
            this.writeHeader(os, bob.size(), 13);
            bob.writeToStream(os);
        } else {
            this.unknownEncodeType(os, value, referer);
        }
    }

    protected void unknownEncodeType(OutputStream os, Object value, IObjectReferer referer) throws IOException, CodecException {
        throw new CodecException("BAC.0005.0001", new String[]{value.getClass().getName()});
    }

    private final int nextByte(InputStream is) throws IOException {
        int i = is.read();
        if (i < 0) {
            throw new EOFException();
        }
        return i;
    }

    private final int readShort(InputStream is) throws IOException {
        return this.nextByte(is) << 8 | this.nextByte(is);
    }

    private final int readInt(InputStream is) throws IOException {
        return this.nextByte(is) << 24 | this.nextByte(is) << 16 | this.nextByte(is) << 8 | this.nextByte(is);
    }

    private final long readLong(InputStream is) throws IOException {
        return (long)this.nextByte(is) << 56 | (long)this.nextByte(is) << 48 | (long)this.nextByte(is) << 40 | (long)this.nextByte(is) << 32 | (long)this.nextByte(is) << 24 | (long)this.nextByte(is) << 16 | (long)this.nextByte(is) << 8 | (long)this.nextByte(is);
    }

    /*
     * Unable to fully structure code
     */
    protected Object _decode(InputStream is, IObjectReferer referer) throws IOException, CodecException {
        hdrByte = this.nextByte(is);
        dtype = hdrByte & 127;
        length = (hdrByte & 128) > 0 ? this.readInt(is) : this.nextByte(is);
        idc = referer.beginDecode();
        switch (dtype) {
            case 0: {
                idc.setDecodedValue(null);
                break;
            }
            case 1: {
                idc.setReferenceValue(this._decode(is, referer));
                break;
            }
            case 2: {
                ca = new char[length];
                for (ci = 0; ci < ca.length; ++ci) {
                    ca[ci] = (char)(this.nextByte(is) << 8 | this.nextByte(is));
                }
                idc.setDecodedValue(new String(ca));
                break;
            }
            case 3: {
                cname = (String)this._decode(is, referer);
                try {
                    dat = (IData)this.getInstance(this.loadClass(cname));
                }
                catch (Throwable e) {
                    dat = this.getNewIData();
                    if (dat != null) ** GOTO lbl28
                    throw new CodecException("BAC.0005.0002", new String[]{cname});
                }
lbl28:
                // 2 sources

                idc.setDecodedValue(dat);
                cur = dat.getCursor();
                while ((k = (String)this._decode(is, referer)) != null) {
                    v = this._decode(is, referer);
                    cur.insertAfter(k, v);
                }
                cur.destroy();
                break;
            }
            case 4: {
                cname = (String)this._decode(is, referer);
                data = (IData)this._decode(is, referer);
                try {
                    dc = (IDataPortable)this.getInstance(this.loadClass(cname));
                    idc.setDecodedValue(dc);
                    dc.setFromData(data);
                    break;
                }
                catch (Throwable e) {
                    throw new CodecException(e);
                }
            }
            case 5: {
                b = new byte[length];
                blen = toRead = b.length;
                while (toRead > 0) {
                    read = is.read(b, blen - toRead, toRead);
                    if (read < 0) {
                        throw new CodecException("BAC.0005.0003");
                    }
                    toRead -= read;
                }
                idc.setDecodedValue(b);
                break;
            }
            case 6: {
                try {
                    o = (Object[])Array.newInstance(this.loadClass((String)this._decode(is, referer)), length);
                }
                catch (Throwable t) {
                    o = new Object[length];
                }
                idc.setDecodedValue(o);
                for (i = 0; i < length; ++i) {
                    o[i] = this._decode(is, referer);
                }
                break;
            }
            case 7: {
                idc.setDecodedValue(new Integer(length));
                break;
            }
            case 8: {
                idc.setDecodedValue(new Long(this.readLong(is)));
                break;
            }
            case 9: {
                idc.setDecodedValue(new Double(Double.longBitsToDouble(this.readLong(is))));
                break;
            }
            case 10: {
                idc.setDecodedValue(new Float(Float.intBitsToFloat(length)));
                break;
            }
            case 11: {
                idc.setDecodedValue(new Short((short)length));
                break;
            }
            case 12: {
                idc.setDecodedValue(new Boolean(length == 1));
                break;
            }
            case 13: {
                try {
                    idc.setDecodedValue(new CodecObjectInputStream(is).readObject());
                    break;
                }
                catch (Throwable t) {
                    throw new CodecException(t);
                }
            }
            case 14: {
                idc.setDecodedValue(new Date(this.readLong(is)));
                break;
            }
            case 15: {
                idc.setDecodedValue(new Byte((byte)this.readShort(is)));
                break;
            }
            default: {
                this.unknownDecodeType(is, dtype, idc, referer);
            }
        }
        return idc.getValue();
    }

    protected void unknownDecodeType(InputStream is, int dtype, IDecodeContainer idc, IObjectReferer referer) throws IOException, CodecException {
        throw new CodecException("BAC.0005.0004", new String[]{"" + dtype});
    }

    public IData getNewIData() throws CodecException {
        return new MData();
    }

    public Class loadClass(String cname) throws ClassNotFoundException {
        ClassNotFoundException notFound = null;
        try {
            return Class.forName(cname);
        }
        catch (ClassNotFoundException e) {
            ClassLoader[] loaders;
            notFound = e;
            for (ClassLoader loader : loaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), globalLoader}) {
                if (loader == null) continue;
                try {
                    return loader.loadClass(cname);
                }
                catch (ClassNotFoundException e2) {
                    notFound = e2;
                }
            }
            throw notFound;
        }
    }

    public Object getInstance(Class clazz) throws CodecException {
        try {
            return clazz.newInstance();
        }
        catch (Throwable nm) {
            try {
                Method meth = clazz.getMethod("create", parmTypes);
                return meth.invoke(null, initArgs);
            }
            catch (Throwable t) {
                throw new CodecException("BAC.0005.0005", new String[]{clazz.getName()}, t);
            }
        }
    }

    public static int getVersion() {
        return 1;
    }

    private final class MData
    extends MemData {
        private MData() {
        }

        public MemData newInstance() {
            return new MData();
        }

        public String toString() {
            return "BC-MData:" + super.toString();
        }
    }
}

