/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util.classloader;

import com.wm.util.ClasspathUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AdvisoryClassLoader
extends URLClassLoader {
    private int INITIAL_CAPACITY = 10;
    private Vector _advisoryPathElements = new Vector();
    private Hashtable _nameToClassMap = new Hashtable(this.INITIAL_CAPACITY);
    public static final String CLASS_SUFFIX = ".class";
    public static final String JAR_SUFFIX = ".jar";
    public static final String ZIP_SUFFIX = ".zip";

    public AdvisoryClassLoader() {
        this(new URL[0], null, null, null);
    }

    public AdvisoryClassLoader(ClassLoader aClassLoader) {
        this(new URL[0], null, aClassLoader, null);
    }

    public AdvisoryClassLoader(String theSystemClasspath, String theAdvisorsClasspath, ClassLoader aClassLoader, URLStreamHandlerFactory aURLStreamHandlerFactory) {
        this(ClasspathUtils.getURLsFromClasspath(theSystemClasspath), ClasspathUtils.getURLsFromClasspath(theAdvisorsClasspath), aClassLoader, aURLStreamHandlerFactory);
    }

    public AdvisoryClassLoader(URL[] someSystemClasspathURLs, URL[] someAdvisorClasspathURLs, ClassLoader aClassLoader, URLStreamHandlerFactory aURLStreamHandlerFactory) {
        super(someSystemClasspathURLs, aClassLoader, aURLStreamHandlerFactory);
        this.addAdvisorClasspathItems(someAdvisorClasspathURLs);
    }

    public Class findClass(String aClassName) throws ClassNotFoundException {
        Class<?> clas = null;
        if (aClassName == null) {
            throw new ClassNotFoundException(aClassName);
        }
        Class localClass = (Class)this._nameToClassMap.get(aClassName);
        if (localClass != null) {
            return localClass;
        }
        byte[] classBytes = this.advise(aClassName);
        if (classBytes == null) {
            clas = super.findClass(aClassName);
        } else {
            try {
                clas = this.defineClass(aClassName, classBytes, 0, classBytes.length);
            }
            catch (ClassFormatError cfe) {
                System.out.println("ClassFormatError trying define the class bytes for \"" + aClassName + "\"");
                cfe.printStackTrace();
                throw cfe;
            }
        }
        this._nameToClassMap.put(aClassName, clas);
        return clas;
    }

    public static byte[] getBytesFromStream(InputStream anInputStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(anInputStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int capacity = 4096;
        byte[] byteBuffer = new byte[capacity];
        int read = 0;
        while (read != -1) {
            try {
                read = bis.read(byteBuffer);
            }
            catch (EOFException eofe) {
                read = -1;
            }
            if (read <= 0) continue;
            baos.write(byteBuffer, 0, read);
        }
        byte[] classBytes = baos.toByteArray();
        bis.close();
        baos.close();
        byteBuffer = null;
        return classBytes;
    }

    public static byte[] getBytesFromZip(String aFileName, ZipFile aZipArchive) {
        ZipEntry ze = aZipArchive.getEntry(aFileName.replace('\\', '/'));
        if (ze == null) {
            return null;
        }
        Object classBytes = null;
        InputStream is = null;
        try {
            is = aZipArchive.getInputStream(ze);
            return AdvisoryClassLoader.getBytesFromStream(is);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected byte[] advise(String aFullyQualifiedClassName) {
        if (aFullyQualifiedClassName == null) {
            return null;
        }
        byte[] bytes = null;
        String className = aFullyQualifiedClassName.replace('.', File.separatorChar);
        if (!className.endsWith(CLASS_SUFFIX)) {
            className = className.concat(CLASS_SUFFIX);
        }
        for (int i = 0; i < this._advisoryPathElements.size(); ++i) {
            try {
                URL anAdvisorPathElement = (URL)this._advisoryPathElements.elementAt(i);
                String name = anAdvisorPathElement.getFile().replace('/', File.separatorChar);
                File fileFromName = new File(name);
                if (name.endsWith(JAR_SUFFIX) || name.endsWith(ZIP_SUFFIX)) {
                    ZipFile zipArchive = new ZipFile(fileFromName);
                    bytes = AdvisoryClassLoader.getBytesFromZip(className, zipArchive);
                    if (bytes == null) continue;
                    return bytes;
                }
                if (!fileFromName.isDirectory()) continue;
                File[] filesInDir = fileFromName.listFiles();
                for (int j = 0; j < filesInDir.length; ++j) {
                    byte[] searchResults = this.advise(filesInDir[j].getName());
                    if (searchResults == null) continue;
                    return searchResults;
                }
                continue;
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public void addAdvisorClasspathItem(URL aURL) {
        if (aURL == null) {
            return;
        }
        URL[] list = this._advisoryPathElements.toArray(new URL[0]);
        if (!AdvisoryClassLoader.isListed(list, aURL)) {
            this._advisoryPathElements.add(aURL);
        }
    }

    public void addAdvisorClasspathItems(URL[] someURLs) {
        if (someURLs == null) {
            return;
        }
        for (int i = 0; i < someURLs.length; ++i) {
            URL urlToAdd;
            URL[] existingList = this._advisoryPathElements.toArray(new URL[0]);
            if (AdvisoryClassLoader.isListed(existingList, urlToAdd = someURLs[i])) continue;
            this._advisoryPathElements.add(urlToAdd);
        }
    }

    public void addClasspathItem(URL aURL) {
        if (aURL == null) {
            return;
        }
        URL[] existingList = super.getURLs();
        if (!AdvisoryClassLoader.isListed(existingList, aURL)) {
            super.addURL(aURL);
        }
    }

    public void addClasspathItems(URL[] someURLs) {
        if (someURLs == null) {
            return;
        }
        for (int i = 0; i < someURLs.length; ++i) {
            URL urlToAdd;
            URL[] existingList = super.getURLs();
            if (AdvisoryClassLoader.isListed(existingList, urlToAdd = someURLs[i])) continue;
            super.addURL(urlToAdd);
        }
    }

    public void setNewAdvisorPath(URL[] someAdvisorPathElements) {
        if (someAdvisorPathElements == null) {
            return;
        }
        if (this._advisoryPathElements != null) {
            this._advisoryPathElements.clear();
        }
        this.addAdvisorClasspathItems(someAdvisorPathElements);
    }

    public URL[] getAdvisoryClasspathItems() {
        Object[] urls = new URL[this._advisoryPathElements.size()];
        this._advisoryPathElements.copyInto(urls);
        return urls;
    }

    private static boolean isListed(URL[] someURLs, URL aURL) {
        if (someURLs == null || aURL == null) {
            return false;
        }
        String checkedPath = AdvisoryClassLoader.getPath(aURL.getFile());
        for (int i = 0; i < someURLs.length; ++i) {
            String cursorPath;
            URL cursor = someURLs[i];
            if (cursor == null || !(cursorPath = AdvisoryClassLoader.getPath(cursor.getFile())).equals(checkedPath)) continue;
            return true;
        }
        return false;
    }

    private static String getPath(String aUrlFilePath) {
        if (aUrlFilePath == null) {
            return null;
        }
        int poundCharInd = aUrlFilePath.indexOf(35);
        int qCharInd = (aUrlFilePath = poundCharInd < 0 ? aUrlFilePath : aUrlFilePath.substring(0, poundCharInd)).lastIndexOf(63);
        if (qCharInd != -1) {
            return aUrlFilePath.substring(0, qCharInd);
        }
        return aUrlFilePath;
    }
}

