/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.ByteOutputBuffer;
import com.wm.util.EncUtil;
import com.wm.util.ZipManifestEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

class ZipManifest {
    Vector list = new Vector();

    ZipManifest() {
    }

    void addEntry(ZipManifestEntry entry) {
        this.list.addElement(entry);
    }

    public byte[] getBytes() {
        PrintWriter data;
        ByteOutputBuffer bob = new ByteOutputBuffer();
        try {
            data = new PrintWriter(new OutputStreamWriter((OutputStream)bob, EncUtil.getFileEncoding()));
        }
        catch (UnsupportedEncodingException ex) {
            data = new PrintWriter(new OutputStreamWriter(bob));
        }
        data.println("Manifest-Version: 1.0");
        data.println();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            ZipManifestEntry me = (ZipManifestEntry)e.nextElement();
            if (me.data == null) continue;
            data.println("Name: " + me.entry.toString());
            data.println("Digest-Algorithms: SHA MD5");
            data.println("SHA-Digest: " + me.SHA);
            data.println("MD5-Digest: " + me.MD5);
            data.println();
        }
        data.flush();
        return bob.toByteArray();
    }

    void writeToZip(ZipOutputStream zo) throws IOException {
        byte[] data = this.getBytes();
        CRC32 crc = new CRC32();
        ZipEntry ze = new ZipEntry("META-INF/MANIFEST.MF");
        ze.setSize(data.length);
        crc.update(data);
        ze.setCrc(crc.getValue());
        zo.putNextEntry(ze);
        zo.write(data, 0, data.length);
        zo.closeEntry();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            ZipManifestEntry me = (ZipManifestEntry)e.nextElement();
            try {
                zo.putNextEntry(me.entry);
                if (me.data != null) {
                    zo.write(me.data, 0, me.data.length);
                }
            }
            catch (ZipException zex) {
                if (zex.getMessage().startsWith("duplicate entry")) {
                    System.out.println(zex.getMessage() + ": " + ze.getName() + " Ignoring Entry.");
                }
                throw zex;
            }
            zo.closeEntry();
        }
    }
}

