/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.Vector;

public class XMLUtils {
    public static final ElementNode getFirstChildElement(ElementNodeBase element) throws WMDocumentException {
        if (element != null) {
            for (Node node = element.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                if (node.getNodeType() != 1) continue;
                return (ElementNode)node;
            }
        }
        return null;
    }

    public static final ElementNode getNextSiblingElement(ElementNodeBase element) throws WMDocumentException {
        if (element != null) {
            for (Node node = element.getNextSiblingWm(); node != null; node = node.getNextSiblingWm()) {
                if (node.getNodeType() != 1) continue;
                return (ElementNode)node;
            }
        }
        return null;
    }

    public static final String getAttributeValue(ElementNodeBase element, Name namespaceName, Name localName) {
        return element != null ? element.getAttributeValue(namespaceName, localName) : null;
    }

    public static final String getCharacterData(ElementNodeBase element) throws WMDocumentException {
        if (element == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Node node = element.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
            if (node.getNodeType() != 3) continue;
            sb.append(node.getText());
        }
        return sb.toString();
    }

    public static final int countChildren(ElementNodeBase node) throws WMDocumentException {
        return 0;
    }

    public static final QName computeQName(ElementNodeBase node) {
        if (node == null) {
            return null;
        }
        return QName.create(node.getNamespaceUri(), node.getLocalNameWm());
    }

    public static final Attribute[] getAttributes(ElementNodeBase node) {
        if (node == null) {
            return null;
        }
        Attribute attribute = node.getFirstAttribute();
        if (attribute == null) {
            return null;
        }
        Vector<Attribute> bag = new Vector<Attribute>(4);
        while (attribute != null) {
            bag.addElement(attribute);
            attribute = attribute.getNext();
        }
        Object[] attrs = new Attribute[bag.size()];
        bag.copyInto(attrs);
        return attrs;
    }

    public static boolean validateNCName(String ncname) {
        return NCName.validate(ncname);
    }

    public static boolean validateQName(String qname) {
        String localName = null;
        String prefix = null;
        int colon = qname.indexOf(":");
        if (colon > 0) {
            prefix = qname.substring(0, colon);
            localName = qname.substring(colon + 1);
            if (prefix != null && prefix.startsWith("@")) {
                if (localName != null) {
                    return XMLUtils.validateNCName(localName);
                }
                return true;
            }
            if (prefix != null) {
                if (!XMLUtils.validateNCName(prefix)) {
                    return false;
                }
                if (localName != null) {
                    return XMLUtils.validateNCName(localName);
                }
                return false;
            }
            return false;
        }
        if ("*body".equals(qname) || qname != null && qname.startsWith("@")) {
            return true;
        }
        return XMLUtils.validateNCName(qname);
    }

    public static String encodeQName(String qname) {
        String localName = null;
        String prefix = null;
        int colon = qname.indexOf(":");
        if (colon > 0) {
            prefix = qname.substring(0, colon);
            localName = qname.substring(colon + 1);
            if (localName != null && !XMLUtils.validateNCName(localName)) {
                localName = NCName.encode(localName);
            }
            if (prefix != null && !prefix.startsWith("@") && !XMLUtils.validateNCName(prefix)) {
                prefix = NCName.encode(prefix);
            }
            return prefix + ":" + localName;
        }
        if ("*body".equals(qname) || XMLUtils.validateNCName(qname) || qname != null && qname.startsWith("@")) {
            return qname;
        }
        return NCName.encode(qname);
    }

    public static String decodeQName(String qname) {
        return NCName.decode(qname);
    }
}

