/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Trace;
import com.wm.util.Values;
import com.wm.util.template.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;

public class XMLTrace
extends Trace {
    private static String XML_HDR = "<?xml version=\"1.0\" standalone=\"yes\"?>\n";
    private static String XMLLOG_DELIM_BEG = "<IS_XML_LOG>\n";
    private static String XMLLOG_DELIM_END = "</IS_XML_LOG>\n";
    private static String XMLDOCTYPE = "\n<!DOCTYPE IS_LOG [\n<!ENTITY e1 SYSTEM \"";
    private static String XMLDOCTYPE2 = "\">\n]>\n\n<IS_LOG>\n&e1;\n</IS_LOG>\n";
    private Reporter reporter;

    public XMLTrace(String dictionaryFile, String outputFile, String outputTemplateFile, Properties props) throws FileNotFoundException, Exception {
        super(dictionaryFile, outputFile, props);
        File f = new File(outputTemplateFile);
        if (!f.isFile()) {
            throw new FileNotFoundException(outputTemplateFile);
        }
        this.reporter = new Reporter(f.getName(), new File(f.getParent()));
    }

    protected void WriteLog(int code, int severity, int facility, String facilityMsg, String msg) {
        if (severity <= this.getLevel() && this.isFacilitySet(facility)) {
            try {
                Values out = new Values();
                out.put("errorCode", Integer.toString(code));
                out.put("severity", this.getSeverityAsStr(severity));
                out.put("facility", facilityMsg);
                out.put("errorMsg", msg);
                out.put("time", this.getDateStamp());
                if (this.reporter != null) {
                    this.reporter.reportToOutput(out, this.log);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void writeInitLine() {
        if (this.getOutFileCreated()) {
            this.createRootDoc();
        }
    }

    private void createRootDoc() {
        try {
            File f = new File(this.getLogFile());
            StringBuffer rootDoc = new StringBuffer(f.getName());
            rootDoc.insert(0, "rootDoc");
            FileOutputStream fo = new FileOutputStream(f.getParent() + rootDoc.toString(), false);
            fo.write(XML_HDR.getBytes());
            fo.write((XMLDOCTYPE + "./" + f.getName() + XMLDOCTYPE2).getBytes());
            fo.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Trace dbgTrace = null;
        try {
            dbgTrace = new XMLTrace("d:\\logstr_en.txt", "d:\\server.xml", "d:\\template.xml", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dbgTrace.setFacility(1);
        dbgTrace.setLevel(9);
        dbgTrace.log(3, 1, "Hello");
        dbgTrace.log(3, 1, "Hello");
        dbgTrace.log(3, 1, "Hello");
    }
}

