/*
 * Decompiled with CFR 0.152.
 */
package com.wm.util;

import com.wm.util.Values;
import com.wm.util.coder.XMLCoder;
import java.io.File;
import java.io.IOException;

public class ValuesRegistry
extends Values {
    Exception error;
    File registryFile;
    XMLCoder coder;

    public ValuesRegistry(String filename) {
        this.registryFile = new File(filename);
        this.init();
    }

    public ValuesRegistry(File file) {
        this.registryFile = file;
        this.init();
    }

    private void init() {
        this.coder = new XMLCoder(true);
        this.error = null;
        if (!this.registryFile.exists()) {
            File parent = new File(this.registryFile.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
            this.writeToFile();
        } else {
            this.readFromFile();
        }
    }

    public synchronized Object removeWithWrite(String key) {
        Object o = super.remove(key);
        this.writeToFile();
        return o;
    }

    public synchronized Object putWithWrite(String k, Object value) {
        Object o = super.put(k, value);
        this.writeToFile();
        return o;
    }

    public final synchronized boolean readFromFile() {
        try {
            Values data = this.coder.readFromFile(this.registryFile);
            this.copyFrom(data);
            this.error = null;
            return true;
        }
        catch (IOException e) {
            this.error = e;
            return false;
        }
    }

    public final synchronized boolean writeToFile() {
        try {
            this.coder.writeToFile(this.registryFile, this);
            this.error = null;
            return true;
        }
        catch (IOException e) {
            this.error = e;
            return false;
        }
    }

    public final synchronized Exception getError() {
        return this.error;
    }
}

